/*
 * Board specific setup info
 *
 * (C) Copyright 2003, ARM Ltd.
 * Philippe Robin, <philippe.robin@arm.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#include <cnw5xxx.h>

#include "clock.h"

.globl secondary_cores
secondary_cores:
	mov	r12, lr

	/* Have we already remapped. */
	ldr	r8, =CNW5XXX_MISC_BASE
	ldr	r6, [r8, #0x00]
	and	r6, r6, #0x01	

	tst	r6, #0x01
	beq	2f
	mov	pc, #0x10000000		/* 0x60000000 for SPI-flash boot */
2:
        /* Enable software interrupt */
	ldr	r5, =CNW5XXX_TC11MP_GIC_CPU_BASE
	mov	r6, #0x01
	str	r6, [r5, #GIC_CPU_CTRL_OFFSET]
	mov	r6, #0xF0
	str	r6, [r5, #GIC_CPU_PRIMASK_OFFSET]

	/* Read core number into r0 */
	mrc	p15, 0, r0, c0, c0, 5
	and	r0, r0, #0x0f
1:
	/* Set WFI */
	mov	r2, #0
	mcr	p15, 0, r2, c7, c0, 4

	ldr	r5, =CNW5XXX_MISC_BASE
	ldr	r6, [r5, #0x0600]
	ldr	r5, =0x35678855
	cmp	r6, r5
	movne	pc, r6

	b	1b

	mov	lr, r12
	mov	pc, lr

/* Set up the platform, once the cpu has been initialized */
.globl lowlevel_init
lowlevel_init:
	mov	r12, lr

	ldr	r0, =CNW5XXX_PMU_BASE

	/* Disable PLL Power Down */
	mov	r1, #0
	str	r1, [r0, #0x1c]

    /* Add a delay */
    mov     r1, #0x10000
pll_delay:
    subs    r1, r1, #1
    bne     pll_delay

	/* Enable Peripheral Clock  */
	mov	r1, #0xffffffff
	str	r1, [r0]

	/* Exit Power On Reset State */
	mov	r1, #0xffffffff
	str	r1, [r0, #4]

	/* regulator control */
	ldr	r1, =0x00469A59
	str	r1, [r0, #0x20]

	/* ?? Disable Watchdog */

	/* ?? External interrupt pending clear */

	/* ?? Disable all interrupts */

	/* ?? init system clock */

	/* Initiallise DDR2 SDRAM Control -- Setup pll, mux, memory */
	bl	ddr2_sdram_ctrl_init

	/* Initiallise Static Memory Controller (SMC: NOR flash) */
	bl	smc_ctrl_init

#if defined(CONFIG_SPI) && defined(CONFIG_CNW5XXX)
	/* Initiallise SPI Control */
	bl	spi_ctrl_init
#endif

	mov	lr, r12
	mov	pc, lr


ddr2_sdram_ctrl_init:
	/* SDRAM control register base address 0x72000000 */
	ldr	r0, =CNW5XXX_DMC_BASE

	/* DLL initialization */
	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_CTRL_OFFSET]			/* 0x400 */

	ldr	r1, =0x00001410
	str	r1, [r0, #DMC_PHY_DETECT_CFG_OFFSET]		/* 0x408 */

	ldr	r1, =0x00000006
	str	r1, [r0, #DMC_PHY_GATE_CTRL_OFFSET]		/* 0x40C */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_0_CTRL_OFFSET]	/* 0x410 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_1_CTRL_OFFSET]	/* 0x414 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_2_CTRL_OFFSET]	/* 0x418 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_3_CTRL_OFFSET]	/* 0x41C */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_CLK_DLY_CTRL_OFFSET]		/* 0x420 */

	ldr	r1, =0x00000018
	str	r1, [r0, #DMC_PHY_DLL_LOCK_VALUE_OFFSET]	/* 0x424 */

	ldr	r1, =0x00000001
	str	r1, [r0, #DMC_PHY_DETECT_CTRL_OFFSET]		/* 0x404 */

	ldr	r1, =0x00000003
	str	r1, [r0, #DMC_PHY_DETECT_CTRL_OFFSET]		/* 0x404 */

	/* ZQ initialization (0x428):
         *
         * [15:13] sets DDS[2:0]
         *         000 300   ohm
         *         001 150   ohm
         *         010 100   ohm
         *         011  75   ohm
         *         100  60   ohm <- SHARP Board.
         *         101  50   ohm
         *         110  42.8 ohm
         *         111  37.5 ohm
         *
         *    [12] 0   enable ODT <- SHARP Board.
         *         1   disable ODT
         *
         *  [11:9] ODT value
         *         001 150 ohm
         *         010  75 ohm <- SHARP Board.
         *         011  50 ohm
         *         other values undefined
         */
	ldr	r1, =0x00068550			/* 0x0006E550 */
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x00068551			/* 0x0006E551 */
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x00068550			/* 0x0006E550 */
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x00068552			/* 0x0006E552 */
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x00068550			/* 0x0006E550 */
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x00078550			/* 0x0007E550 */
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	/* Enable PHY FIFO Read */
	ldr	r1, =0x00000002
	str	r1, [r0, #DMC_READ_DELAY_OFFSET]		/* 0x430 */

	/* Set CAS Latency */
	ldr	r1, =(DMC_CAS_LATENCY << 1)
	str	r1, [r0, #DMC_CAS_LATENCY_OFFSET]		/* 0x014 */

	ldr	r1, =DMC_T_MRD
	str	r1, [r0, #DMC_T_MRD_OFFSET]			/* 0x01C */


    ldr r5, =CNW5XXX_MISC_BASE
    ldr r6, [r5, #0x04]
    and r6, r6, #0x600
    ldr r5, =0x0    
    cmp r5, r6
    beq ddr_200 
    ldr r5, =0x200  
    cmp r5, r6
    beq ddr_266 
    ldr r5, =0x400  
    cmp r5, r6
    beq ddr_333 
    ldr r5, =0x600  
    cmp r5, r6
    beq ddr_400 

ddr_200:
	ldr	r1, =DMC_T_RAS_200
	str	r1, [r0, #DMC_T_RAS_OFFSET]			/* 0x020 */

	ldr	r1, =DMC_T_RC_200
	str	r1, [r0, #DMC_T_RC_OFFSET]			/* 0x024 */

	ldr	r1, =((DMC_SCH_RCD_200<<8)|DMC_T_RCD_200)
	str	r1, [r0, #DMC_T_RCD_OFFSET]			/* 0x028 */

	ldr	r1, =((DMC_SCH_RFC_200<<8)|DMC_T_RFC_200)
	str	r1, [r0, #DMC_T_RFC_OFFSET]			/* 0x02C */

	ldr	r1, =((DMC_SCH_RP_200<<8)|DMC_T_RP_200)
	str	r1, [r0, #DMC_T_RP_OFFSET]			/* 0x030 */

	ldr	r1, =DMC_T_RRD_200
	str	r1, [r0, #DMC_T_RRD_OFFSET]			/* 0x034 */

	ldr	r1, =DMC_T_WR_200
	str	r1, [r0, #DMC_T_WR_OFFSET]			/* 0x038 */

	ldr	r1, =DMC_T_WTR_200
	str	r1, [r0, #DMC_T_WTR_OFFSET]			/* 0x03C */

	ldr	r1, =((DMC_SCH_FAW_200<<8)|DMC_T_FAW_200)
	str	r1, [r0, #DMC_T_FAW_OFFSET]			/* 0x054 */
	
	ldr	r1, =DMC_REFRESH_PRD_200
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */
	
	b ddr_clock_end

ddr_266:
	ldr	r1, =DMC_T_RAS_266
	str	r1, [r0, #DMC_T_RAS_OFFSET]			/* 0x020 */

	ldr	r1, =DMC_T_RC_266
	str	r1, [r0, #DMC_T_RC_OFFSET]			/* 0x024 */

	ldr	r1, =DMC_SCH_RCD_266<<8|DMC_T_RCD_266
	str	r1, [r0, #DMC_T_RCD_OFFSET]			/* 0x028 */

	ldr	r1, =DMC_SCH_RFC_266<<8|DMC_T_RFC_266
	str	r1, [r0, #DMC_T_RFC_OFFSET]			/* 0x02C */

	ldr	r1, =DMC_SCH_RP_266<<8|DMC_T_RP_266
	str	r1, [r0, #DMC_T_RP_OFFSET]			/* 0x030 */

	ldr	r1, =DMC_T_RRD_266
	str	r1, [r0, #DMC_T_RRD_OFFSET]			/* 0x034 */

	ldr	r1, =DMC_T_WR_266
	str	r1, [r0, #DMC_T_WR_OFFSET]			/* 0x038 */

	ldr	r1, =DMC_T_WTR_266
	str	r1, [r0, #DMC_T_WTR_OFFSET]			/* 0x03C */

	ldr	r1, =DMC_SCH_FAW_266<<8|DMC_T_FAW_266
	str	r1, [r0, #DMC_T_FAW_OFFSET]			/* 0x054 */
	
	ldr	r1, =DMC_REFRESH_PRD_266
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */
	
	b ddr_clock_end

ddr_333:
	ldr	r1, =DMC_T_RAS_333
	str	r1, [r0, #DMC_T_RAS_OFFSET]			/* 0x020 */

	ldr	r1, =DMC_T_RC_333
	str	r1, [r0, #DMC_T_RC_OFFSET]			/* 0x024 */

	ldr	r1, =DMC_SCH_RCD_333<<8|DMC_T_RCD_333
	str	r1, [r0, #DMC_T_RCD_OFFSET]			/* 0x028 */

	ldr	r1, =DMC_SCH_RFC_333<<8|DMC_T_RFC_333
	str	r1, [r0, #DMC_T_RFC_OFFSET]			/* 0x02C */

	ldr	r1, =DMC_SCH_RP_333<<8|DMC_T_RP_333
	str	r1, [r0, #DMC_T_RP_OFFSET]			/* 0x030 */

	ldr	r1, =DMC_T_RRD_333
	str	r1, [r0, #DMC_T_RRD_OFFSET]			/* 0x034 */

	ldr	r1, =DMC_T_WR_333
	str	r1, [r0, #DMC_T_WR_OFFSET]			/* 0x038 */

	ldr	r1, =DMC_T_WTR_333
	str	r1, [r0, #DMC_T_WTR_OFFSET]			/* 0x03C */

	ldr	r1, =DMC_SCH_FAW_333<<8|DMC_T_FAW_333
	str	r1, [r0, #DMC_T_FAW_OFFSET]			/* 0x054 */
	
	ldr	r1, =DMC_REFRESH_PRD_333
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */
	
	b ddr_clock_end

ddr_400:
	ldr	r1, =DMC_T_RAS_400
	str	r1, [r0, #DMC_T_RAS_OFFSET]			/* 0x020 */

	ldr	r1, =DMC_T_RC_400
	str	r1, [r0, #DMC_T_RC_OFFSET]			/* 0x024 */

	ldr	r1, =DMC_SCH_RCD_400<<8|DMC_T_RCD_400
	str	r1, [r0, #DMC_T_RCD_OFFSET]			/* 0x028 */

	ldr	r1, =DMC_SCH_RFC_400<<8|DMC_T_RFC_400
	str	r1, [r0, #DMC_T_RFC_OFFSET]			/* 0x02C */

	ldr	r1, =DMC_SCH_RP_400<<8|DMC_T_RP_400
	str	r1, [r0, #DMC_T_RP_OFFSET]			/* 0x030 */

	ldr	r1, =DMC_T_RRD_400
	str	r1, [r0, #DMC_T_RRD_OFFSET]			/* 0x034 */

	ldr	r1, =DMC_T_WR_400
	str	r1, [r0, #DMC_T_WR_OFFSET]			/* 0x038 */

	ldr	r1, =DMC_T_WTR_400
	str	r1, [r0, #DMC_T_WTR_OFFSET]			/* 0x03C */

	ldr	r1, =DMC_SCH_FAW_400<<8|DMC_T_FAW_400
	str	r1, [r0, #DMC_T_FAW_OFFSET]			/* 0x054 */

	ldr	r1, =DMC_REFRESH_PRD_400
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */
	
ddr_clock_end:
	ldr	r1, =DMC_T_XP
	str	r1, [r0, #DMC_T_XP_OFFSET]			/* 0x040 */

	ldr	r1, =DMC_T_XSR
	str	r1, [r0, #DMC_T_XSR_OFFSET]			/* 0x044 */

	ldr	r1, =DMC_T_ESR
	str	r1, [r0, #DMC_T_ESR_OFFSET]			/* 0x048 */

	ldr	r1, =0x00014012
	str	r1, [r0, #DMC_MEMORY_CFG_OFFSET]		/* 0x00C*/

	ldr	r1, =0x00000618
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */

	ldr	r1, =0x00000034
	str	r1, [r0, #DMC_MEMORY_CFG2_OFFSET]		/* 0x04C */

	ldr	r1, =0x000000FF
	str	r1, [r0, #DMC_CHIP_0_CFG_OFFSET]		/* 0x200 */

	ldr	r1, =0x000C0000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]		/* 0x008 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x000A0000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x000B0000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	/* DDR ODT/drive strength settings are set in the commands starting with 0x0009xxxx
         *
         * [6,2]   sets ODT value
         *         00 ODT disabled
         *         01  75 ohm <- SHARP Board.
         *         10 150 ohm
         *         11  50 ohm
         *
         *   [1]   output driver strength
         *         0 Full strength <- SHARP Board.
         *         1 Reduced strength
         */
	ldr	r1, =0x00090004			/* 0x00090044 */
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00080B62
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00040000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00040000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00080A62
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00090384			/* 0x000903C4 */
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00090004			/* 0x00090044 */
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	/* auto refresh */
	ldr	r1, =0x00000000
	str	r1, [r0, #0x004]

	/* DMC base address */
	mov	pc, lr

smc_ctrl_init:
	/* SMC control register base address 0x73000000 */
	ldr	r0, =CNW5XXX_SMC_BASE

	/* set cycles for CS0 NOR FLASH trc = 110nsec. (we use 90nsec part)*/
	ldr	r1, =0x0002B3C6
	str	r1, [r0, #SMC_SET_CYCLES_OFFSET]

	/* set opmode bit, 16-bits width */
	ldr	r1, =0x00000801
	str	r1, [r0, #SMC_SET_OPMODE_OFFSET]

	/* an idle cycle occurs after each burst */
	ldr	r1, =0x00000001
	str	r1, [r0, #SMC_REFRESH_PERIOD_0_OFFSET]

	/* select CS0 */
	ldr	r1, =0x00400000
	str	r1, [r0, #SMC_DIRECT_CMD_OFFSET]

	mov	pc, lr

#if defined(CONFIG_SPI) && defined(CONFIG_CNW5XXX)
spi_ctrl_init:
	/* SPI control register base address 0x71000000 */
	ldr	r0, =CNW5XXX_SSP_BASE

	/* enable SPI high speed read for system boot up */
        ldr     r1, [r0, #SPI_CFG_OFFSET]
        mov     r2, #0x40000000
        orr     r1, r1, r2
        str     r1, [r0, #SPI_CFG_OFFSET]

        /* set bit rate */
        mov     r1, #0x01
        str     r1, [r0, #SPI_BIT_RATE_OFFSET]

	mov	pc, lr
#endif

