/*
 *  Copyright (c) 2008 Cavium Networks 
 * 
 *  This file is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License, Version 2, as 
 *  published by the Free Software Foundation. 
 *
 *  This file is distributed in the hope that it will be useful, 
 *  but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 *  NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this file; if not, write to the Free Software 
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 *  visit http://www.gnu.org/licenses/. 
 *
 *  This file may also be available under a different license from Cavium. 
 *  Contact Cavium Networks for more information
 */

#ifndef _CLOCK_H
#define _CLOCK_H



/* 
 * DMC Controller
 */

#define DMC_CAS_LATENCY		0x06
#define DMC_T_MRD		0x02
#define DMC_T_XP		0x03
#define DMC_T_XSR		0xC8
#define DMC_T_ESR		0xC8

/* 
 * DMC parameter for DDR2 clock frequency 200, 
 * MCLK = 200 MHz, clock cycle 5ns 
 */
#define DMC_CAS_LATENCY_200	0x0C
#define DMC_T_RAS_200		0x09	/* 45ns = 9*MCLK */

#define DMC_T_RC_200		0x0D	/* 65ns = 13*MCLK */

#define DMC_T_RCD_200		0x04	/* 20ns = 4*MCLK */
#define DMC_SCH_RCD_200		0x02	/* if ACLK is 233MHz, aclk cycle = 4.29ns, 20ns = 5*ACLK */

#define DMC_T_RFC_200		0x28	/* 197.5ns = 40*MCLK*/
#define DMC_SCH_RFC_200		0x2C

#define DMC_T_RP_200		0x04	/* 20ns = 4*MCLK */
#define DMC_SCH_RP_200		0x02	

#define DMC_T_RRD_200		0x02	/* 10ns = 2*MCLK */

#define DMC_T_WR_200		0x03	/* 15ns = 3*MCLK */

#define DMC_T_WTR_200		0x02	/* 10ns = 2*MCLK */

#define DMC_T_FAW_200		0x0A	/* 50ns = 10*MCLK */
#define DMC_SCH_FAW_200		0x09	/* 50ns = 12*ACLK*/

#define DMC_REFRESH_PRD_200 0x0618	/* 7.8us = 1560*MCLK */

/* 
 * DMC parameter for DDR2 clock frequency 266, 
 * MCLK = 266 MHz, clock cycle 3.759ns 
 */
#define DMC_CAS_LATENCY_266	0x08
#define DMC_T_RAS_266		0x0C	/* 45ns = 12*MCLK */
#define DMC_T_RC_266		0x10	/* 60ns = 16*MCLK */
#define DMC_T_RCD_266		0x04	/* 15ns = 4*MCLK */
#define DMC_SCH_RCD_266		0x01	/* if ACLK is 233MHz, aclk cycle = 4.29ns, 15ns = 4*ACLK */
#define DMC_T_RFC_266		0x35	/* 197.5ns = 53*MCLK */
#define DMC_SCH_RFC_266		0x2C	
#define DMC_T_RP_266		0x04	/* 15ns = 4*MCLK */
#define DMC_SCH_RP_266		0x01
#define DMC_T_RRD_266		0x03	/* 10ns = 3*MCLK */
#define DMC_T_WR_266		0x04	/* 15ns = 4*MCLK */
#define DMC_T_WTR_266		0x02	/* 7.5ns = 2*MCLK */
#define DMC_T_FAW_266		0x0E	/* 50ns = 14*MCLK */
#define DMC_SCH_FAW_266		0x09	
#define DMC_REFRESH_PRD_266 0x081B	/* 7.8us */

/* 
 * DMC parameter for DDR2 clock frequency 333, 
 * MCLK = 333 MHz, clock cycle 3.003ns 
 */
#define DMC_CAS_LATENCY_333	0x0A
#define DMC_T_RAS_333		0x0F	/* 45ns = 15*MCLK */
#define DMC_T_RC_333		0x14	/* 60ns = 20*MCLK */
#define DMC_T_RCD_333		0x05	/* 15ns = 5*MCLK */
#define DMC_SCH_RCD_333		0x01	/* if ACLK is 233MHz, aclk cycle = 4.29ns, 15ns = 4*ACLK */
#define DMC_T_RFC_333		0x42	/* 197.5ns = 66*MCLK*/
#define DMC_SCH_RFC_333		0x2C	
#define DMC_T_RP_333		0x05	/* 15ns = 5*MCLK */
#define DMC_SCH_RP_333		0x01
#define DMC_T_RRD_333		0x04	/* 10ns = 4*MCLK */
#define DMC_T_WR_333		0x05	/* 15ns */
#define DMC_T_WTR_333		0x03	/* 7.5ns */
#define DMC_T_FAW_333		0x11	/* 50ns */
#define DMC_SCH_FAW_333		0x09
#define DMC_REFRESH_PRD_333 0x0A26	/* 7.8us */

/* 
 * DMC parameter for DDR2 clock frequency 400, 
 * MCLK = 400 MHz, clock cycle 2.5ns 
 */
#define DMC_CAS_LATENCY_400	0x0C
#define DMC_T_RAS_400		0x12	/* 45ns = 18*MCLK */
#define DMC_T_RC_400		0x18	/* 60ns = 24*MCLK */
#define DMC_T_RCD_400		0x06	/* 15ns = 6*MCLK */
#define DMC_SCH_RCD_400		0x01	/* if ACLK is 233MHz, aclk cycle = 4.29ns, 15ns = 4*ACLK */
#define DMC_T_RFC_400		0x4F	/* 197.5ns = 79*MCLK */
#define DMC_SCH_RFC_400		0x2C	
#define DMC_T_RP_400		0x06	/* 15ns = 6*MCLK */
#define DMC_SCH_RP_400		0x01
#define DMC_T_RRD_400		0x04	/* 10ns = 4*MCLK */
#define DMC_T_WR_400		0x06	/* 15ns = 6*MCLK */
#define DMC_T_WTR_400		0x03	/* 7.5ns = 3*MCLK */
#define DMC_T_FAW_400		0x14	/* 50ns*/
#define DMC_SCH_FAW_400		0x09
#define DMC_REFRESH_PRD_400 0x0C30	/* 7.8us */

#endif /* _CLOCK_H */
