/* ported from octeon */

#include <common.h>
#include <nand.h>
#include <cnw5xxx.h>

static void writeb (int byte, void *ptr)
{
	*(volatile unsigned char *)ptr = byte;
}

static void cavium_cmd_ctrl(struct mtd_info *mtd, int cmd, unsigned int ctrl)
{
	struct nand_chip *this = mtd->priv;
	int offset = 0;

	if (ctrl & NAND_CLE)
		offset =  (1 << NAND_CLE_ADDR_BIT);
	if (ctrl & NAND_ALE)
		offset =  (1 << NAND_ALE_ADDR_BIT);
    
	if (cmd != NAND_CMD_NONE)
		writeb(cmd, this->IO_ADDR_W + offset);

	if (cmd == 0x10)
		udelay(10000);

	udelay(1000);
}

static int cavium_scan_bbt(struct mtd_info *mtd)
{
	return 0;
}

#if 0
static int cavium_block_bad(struct mtd_info *mtd)
{
	return 0;
}
#endif

int board_nand_init(struct nand_chip *nand)
{
	/* From the SMC's perspective, our NAND Flash looks like SRAM */
	*(volatile unsigned *)(CNW5XXX_SMC_BASE+0x18) = 0;
	asm("nop");
	*(volatile unsigned *)(CNW5XXX_SMC_BASE+0x10) = 0x01400000;
	asm("nop");

	nand->cmd_ctrl = cavium_cmd_ctrl;
	nand->IO_ADDR_R = nand->IO_ADDR_W = (void *)CFG_NAND_BASE;
	nand->ecc.mode = NAND_ECC_SOFT;
	nand->chip_delay = 20;
	nand->options = NAND_NO_READRDY | NAND_NO_AUTOINCR;
	nand->scan_bbt = cavium_scan_bbt;
//        nand->block_bad = cavium_block_bad;

	/* send reset command to the NAND Flash */
	udelay(1000);
	*(volatile unsigned char *) (CFG_NAND_BASE + (1 << NAND_CLE_ADDR_BIT)) = 0xff;
	asm("nop");
	udelay(1000);

	return 0;
}
