/*
 * (C) Copyright 2002
 * Gary Jennejohn, DENX Software Engineering, <gj@denx.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */



OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)
SECTIONS
{
    . = 0x00000000;
    . = ALIGN(4);
    .text	:
    {
	. = .;
	_start = . ;
	cpu/arm11mpcore/start.o (.text)
	*(.text)
    }

    . = ALIGN(4);    
    .rodata : 
    {
        . = ALIGN(4);
	    *(.rodata)
	    . = ALIGN(4);
	    *(.rodata.*)
        . = ALIGN(4);
	    *(.rodata.str1.*)
	}

    . = ALIGN(4);
    .data : 
    {
        . = ALIGN(4);
	        *(.data)
        . = ALIGN(4);
	        *(.data.rel)
        . = ALIGN(4);
	        *(.data.rel.*)
	}
	
    . = ALIGN(4);
	.got : 
    {  
        . = ALIGN(4);
	        *(.got)
        . = ALIGN(4);
	        *(.got.*)
        . = ALIGN(4);
    }
    
    . = ALIGN(4);
    __u_boot_cmd_start = .;
	.u_boot_cmd : 
	{
	    *(.u_boot_cmd) 
	}
	__u_boot_cmd_end = .;
	    
    . = ALIGN(4);
    __bss_start = .;
    .bss : 
    {
        *(.bss) 
    }
    __bss_end = .;
    __end = .;
    
    . = ALIGN(4);

/* 1M region includes STACK area, heap - 512K, env - 128K(1 sector of flash), 128 bytes bytes of bdinfo and 3 words for abort stack */
    . = . + 1M; 
    . = ALIGN(4);
    .END_OF_MEMORY ALIGN(0x10000) :
    { 
	__eofm = .; 
    }
	
	. = ALIGN(4);
	__start2_core2 = 0x07e60000;
}

