/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include "u-boot/md5.h"
#include "environment.h"

//"uart_filednload <sdram_address> <length> <crc32>\n"

int do_uart_filednload( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    volatile unsigned char * pAddress;
    volatile unsigned char * pEnd;
    unsigned int Address;
    unsigned int Count;
    unsigned int Crc32;
    unsigned int ComputedCrc32;
	
	int rc = -1;	

	if (argc < (1+3)  )
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
	}	
	
	printf("\nplease download file in binary mode\n");

    Address = (unsigned int)simple_strtoul( argv[1] , NULL , 16);
    pAddress = (volatile unsigned int *) Address ;
    Count = (unsigned int)simple_strtoul( argv[2] , NULL , 16);
    Crc32  = (unsigned int)simple_strtoul( argv[3] , NULL , 16);

    pEnd = pAddress + Count ;


    while (pAddress < pEnd )
    {       
        * pAddress = (unsigned char)serial_getc() ;
        pAddress ++;
        if( 0 ==  (unsigned int) (pAddress) & 0xFFFFFF00 )
        {
            serail_putc(".");
        }
    }
    printf("file download is done, verifying CRC32 please wait...\n");
    ComputedCrc32 = crc32(0, (volatile unsigned int *) Address , Count );

    if (ComputedCrc32 == Crc32 )
    {
        printf("CRC32 is verified, file downloaded sucessfully to memory\n");
    }
    else
    {
        printf("ERROR: fail to verify CRC32, file may not be downloaded successfully to memory\n");
    }

	return (rc);
}


U_BOOT_CMD(
	uart_filednload,	1+3,	0,	do_uart_filednload,
	"uart_filednload     - Uart file download to memory\n",
    "uart_filednload <sdram_address> <length> <crc32>\n"
);

