/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include "u-boot/md5.h"
#include "environment.h"

//"uart_fileupload <sdram_address> <length>\n"

int do_uart_fileupload( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    volatile unsigned char * pAddress;
    volatile unsigned char * pEnd;
    unsigned int Address;
    unsigned int Count;
    unsigned int Crc32;
    unsigned int ComputedCrc32;
	
	int rc = -1;	

	if (argc < (1+2)  )
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
	}

    Address = (unsigned int)simple_strtoul( argv[1] , NULL , 16);
    pAddress = (volatile unsigned int *) Address ;
    Count = (unsigned int)simple_strtoul( argv[2] , NULL , 16);
    //Crc32  = (unsigned int)simple_strtoul( argv[3] , NULL , 16);

    pEnd = pAddress + Count ;

    ComputedCrc32 = crc32(0, (volatile unsigned int *) Address , Count );
    while (pAddress < pEnd )
    {       
       serial_putc( (unsigned char) (* pAddress) )  ;
       pAddress ++;
    }
    serial_putc( ( ComputedCrc32 >> 0 ) & 0xFF);
    serial_putc( ( ComputedCrc32 >> 8 ) & 0xFF);
    serial_putc( ( ComputedCrc32 >> 16) & 0xFF);
    serial_putc( ( ComputedCrc32 >> 24) & 0xFF);

	return (rc);
}


U_BOOT_CMD(
	uart_fileupload,	1+2,	0,	do_uart_fileupload,
	"uart_fileupload - Upload memory via uart\n",
    "uart_fileupload <sdram_address> <length>\n"
);

