/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include "u-boot/md5.h"
#include "environment.h"

extern void PrintMd5(const unsigned char* NetHdMd5);
extern int do_usb(cmd_tbl_t *cmdtp, int flag, int argc, char* argv[] );
extern void LedOff(void);
extern void LedOn(void);


#define _U	0x01	/* upper */
#define _L	0x02	/* lower */
#define _D	0x04	/* digit */
#define _C	0x08	/* cntrl */
#define _P	0x10	/* punct */
#define _S	0x20	/* white space (space/lf/tab) */
#define _X	0x40	/* hex digit */
#define _SP	0x80	/* hard space (0x20) */

extern unsigned char _ctype[];

#define __ismask(x) (_ctype[(int)(unsigned char)(x)])

#define isalnum(c)	((__ismask(c)&(_U|_L|_D)) != 0)
#define isalpha(c)	((__ismask(c)&(_U|_L)) != 0)
#define iscntrl(c)	((__ismask(c)&(_C)) != 0)
#define isdigit(c)	((__ismask(c)&(_D)) != 0)
#define isgraph(c)	((__ismask(c)&(_P|_U|_L|_D)) != 0)
#define islower(c)	((__ismask(c)&(_L)) != 0)
#define isprint(c)	((__ismask(c)&(_P|_U|_L|_D|_SP)) != 0)
#define ispunct(c)	((__ismask(c)&(_P)) != 0)
#define isspace(c)	((__ismask(c)&(_S)) != 0)
#define isupper(c)	((__ismask(c)&(_U)) != 0)
#define isxdigit(c)	((__ismask(c)&(_D|_X)) != 0)

#define isascii(c) (((unsigned char)(c))<=0x7f)
#define toascii(c) (((unsigned char)(c))&0x7f)

static inline unsigned char tolower(unsigned char c)
{
	if (isupper(c))
		c -= 'A'-'a';
	return c;
}

static inline unsigned char toupper(unsigned char c)
{
	if (islower(c))
		c -= 'a'-'A';
	return c;
}

//upgrade uboot stat
//upgrade uboot start
//upgrade nethd stat
//upgrade nethd start
//upgrade all stat
//upgrade all start
//upgrade all force

typedef enum IMAGE_TYPE
{
	UBOOT_CORE1=0,
	UBOOT_CORE2,
	NETHD
}IMAGE_TYPE;

#define IO_WRITE(addr, val) (*(volatile unsigned int *)(addr) = (val))
#define IO_READ(addr) (*(volatile unsigned int *)(addr))

#define UBOOT_CORE1_VERSION_NO ( (const char*)( UBOOT_CORE1_IN_FLASH + 0x100) )	//For Core1
#define UBOOT_CORE2_VERSION_NO ( (const char*)( UBOOT_CORE2_IN_FLASH + 0x100) )	//For Core2

extern int do_fat_fsload(cmd_tbl_t *cmdtp, int flag, int argc, char** argv);
extern int do_flerase(cmd_tbl_t *cmdtp, int flag, int argc, char* argv[]);
extern int do_mem_cp (cmd_tbl_t *cmdtp, int flag, int argc, char* argv[]);

//--------------------------------------------------------------------------------------------------
static unsigned char UBootCore1VersionNo[32];
static unsigned char UBootCore2VersionNo[32];
static unsigned char NetHdVersionNo[32];
static unsigned char NetHdMd5[16];
//---------------------------------------------------------------------------------------------------
int GetNvRamValue(char* aTag, char* aValue, int aBufferLenth)
{
		//int i;
		int j;
		int nxt;
		char *name = aTag;
		int k = -1;
		int status =0;

		for (j=0; env_get_char(j) != '\0'; j=nxt+1) 
		{
			for (nxt=j; env_get_char(nxt) != '\0'; ++nxt)
			{
				;
			}
			
			k = envmatch((uchar *)name, j);
			
			if (k < 0) 
			{
				continue;
			}
			
			puts (name);
			putc ('=');
			
			while (k < nxt)
			{
				putc(env_get_char ( k ) );
				* aValue = env_get_char( k ) ;

				k++;
				aValue ++;
			}
			* aValue = 0;

			putc ('\n');
			break;
		}
		
		if (k < 0) 
		{
			status = -1;
			printf ("## Error: \"%s\" not defined\n", name);
		}

		return status;	
}
//--------------------------------------------------------------------------------------------------
void strtolower(char* apBuf)
{
	while( *apBuf)
	{
		*apBuf = tolower( *apBuf);
		apBuf++;
	}
}
//--------------------------------------------------------------------------------------------------
int VerifyMD5(unsigned char* paBuffer, unsigned int aLength,unsigned char* SuppliedMD5)
{
	int status;
	unsigned char output[16];
	md5( paBuffer , aLength, output);
	status = memcmp(output, SuppliedMD5, sizeof(unsigned char) * 16 );
	if (0 == status )
	{
		printf("MD5 is matching\n");
	}
	else
	{
		printf("Fail to verify MD5\n");
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
int ReadVersionNumberFromCavm_BootLoader_BinFile(void)
{
    int status;
	//int filelength = MD5_SUM_IN_FILE; 
	char* cmd1[] = { "fatload" , "usb", "0" , TEMP_BUFFER_TO_STORE_FW_IMAGE_INSTRING, "cavm_bootloader.bin"  };
	status = do_fat_fsload(NULL, 0, 6 , cmd1);
	if ( 0 == status)
	{
		memcpy(UBootCore1VersionNo, (void*)( TEMP_BUFFER_TO_STORE_FW_IMAGE + 0x100) , 32 );
		memcpy(UBootCore2VersionNo,	(void*)( TEMP_BUFFER_TO_STORE_FW_IMAGE + 0x60100) , 32 );

		printf("USB stick - cavm_bootloader.bin contains following images\n");
		printf("UBootCore1 - %s\n", UBootCore1VersionNo);
		printf("UBootCore2 - %s\n", UBootCore2VersionNo);
		printf("------------------------------------------------\n");
    }
	else
	{
		printf("ERROR: failed to load cavm_bootloader.bin\n");
	}
	return status;

}

int ReadAllVersionNumbers(void)
{
	//int i;
	int status;
	char* cmd1[] = { "fatload" , "usb", "0" , NULL /*TEMP_BUFFER_TO_STORE_FW_IMAGE_INSTRING*/ , "cavm_netHD.bin", "0x170" }; //read 512 bytes
	char TempBuf[16];
	char* pcmd1[6] = { cmd1[0] , cmd1[1] , cmd1[2] , TempBuf , cmd1[4] , cmd1[5] };
	char TempBufForVersionInfo[0x170];
	sprintf(TempBuf, "%08x", (unsigned int)TempBufForVersionInfo );

	status = do_fat_fsload(NULL, 0, 6 , pcmd1 ); //read version number  @ offset 0x100, 0x120, 0x140.
	if ( 0 == status )
	{
		memcpy(NetHdVersionNo,		(void*) (TempBufForVersionInfo/*TEMP_BUFFER_TO_STORE_FW_IMAGE*/ + 0x100) , 32 );
		memcpy(UBootCore1VersionNo, (void*)( TempBufForVersionInfo/*TEMP_BUFFER_TO_STORE_FW_IMAGE*/ + 0x120) , 32 );
		memcpy(UBootCore2VersionNo,	(void*)( TempBufForVersionInfo/*TEMP_BUFFER_TO_STORE_FW_IMAGE*/ + 0x140) , 32 );
		memcpy(NetHdMd5			  , (void*)( TempBufForVersionInfo/*TEMP_BUFFER_TO_STORE_FW_IMAGE*/ + 0x160) , 16 );//copy md5

		printf("USB stick - cavm_netHD.bin contains following images\n");
		printf("UBootCore1 - %s\n", UBootCore1VersionNo);
		printf("UBootCore2 - %s\n", UBootCore2VersionNo);
		printf("netHD      - %s\n", NetHdVersionNo);
		printf("netHD(MD5) - ");
		PrintMd5(NetHdMd5);
		printf("------------------------------------------------\n");
	}
	else
	{
		printf("Unable to read cavm_netHD.bin file\n");
	}
	return status;
}

int ReadAllVersionNumbersTftp(void)
{
	//int i;
	memcpy(NetHdVersionNo,		(void*) (0x4000000 + 0x100) , 32 );
	memcpy(UBootCore1VersionNo, (void*)( 0x4000000 + 0x120) , 32 );
	memcpy(UBootCore2VersionNo,	(void*)( 0x4000000 + 0x140) , 32 );
	memcpy(NetHdMd5,            (void*)( 0x4000000 + 0x160) , 16 );

	printf("TFTP Server - cavm_netHD.bin contains following images\n");
	printf("UBootCore1 - %s\n", UBootCore1VersionNo);
	printf("UBootCore2 - %s\n", UBootCore2VersionNo);
	printf("netHD      - %s\n", NetHdVersionNo);
	printf("netHD(MD5) - ");
	PrintMd5(NetHdMd5);
	printf("------------------------------------------------\n");
    return 0;
}

//--------------------------------------------------------------------------------------------------
int LoadCavmBootLoaderIamge(void)
{
    int status;
	//int filelength = MD5_SUM_IN_FILE; 
	char* cmd1[] = { "fatload" , "usb", "0" , TEMP_BUFFER_TO_STORE_FW_IMAGE_INSTRING, "cavm_bootloader.bin" };
	printf("Going for loading complete image of cavm_bootloader.bin in memory at address 0x%08x , pl. wait...\n", TEMP_BUFFER_TO_STORE_FW_IMAGE);
	status = do_fat_fsload(NULL, 0, 5 , cmd1);
	if ( 0 == status)
	{
    }
	else
	{
		printf("ERROR: failed to load complete image of cavm_bootloader.bin\n");
	}
	return status;
}
int LoadNetHdCompleteImage(void)
{
	int status;
	int filelength = MD5_SUM_IN_FILE; 
	char* cmd1[] = { "fatload" , "usb", "0" , TEMP_BUFFER_TO_STORE_FW_IMAGE_INSTRING, "cavm_nethd.bin" };
	printf("Going for loading complete image of cavm_nethd.bin in memory at address 0x%08x , pl. wait...\n", TEMP_BUFFER_TO_STORE_FW_IMAGE);
	status = do_fat_fsload(NULL, 0, 5 , cmd1);
	if ( 0 == status)
	{
		//Now verify MD5
		printf("Verifying MD5 - pl. wait...\n");
		status =  VerifyMD5( (unsigned char*) TEMP_BUFFER_TO_STORE_FW_IMAGE , filelength , (unsigned char*)( TEMP_BUFFER_TO_STORE_FW_IMAGE + filelength) );
		if (0 == status )
		{
			printf("cavm_nethd.bin passes MD5 verification process\n");
		}
		else
		{
			printf("ERROR: Fail to verify MD5 of cavm_nethd.bin\n");
		}
	}
	else
	{
		printf("ERROR: failed to load complete image of cavm_nethd.bin\n");
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
void PrintFlashVersion(void)
{
	char TempBuf[32];
	memset(TempBuf, 0, sizeof(TempBuf) );
	memcpy(TempBuf, (char*) (UBOOT_CORE1_IN_FLASH + 0x100 ), sizeof(TempBuf)-1 );
	if (TempBuf[0] != 'U')
	{
		strcpy(TempBuf,"Unknown");
	}
	printf("U-Boot Core1 Version: %s\n", TempBuf );

	memset(TempBuf, 0, sizeof(TempBuf) );
	memcpy(TempBuf, (char*) (UBOOT_CORE2_IN_FLASH + 0x100 ), sizeof(TempBuf)-1 );
	if (TempBuf[0] != 'U')
	{
		strcpy(TempBuf,"Unknown");
	}
	printf("U-Boot Core2 Version: %s\n",  TempBuf);


	memset(TempBuf, 0, sizeof(TempBuf) );
	memcpy(TempBuf, (char*) (BOOTP_IAMGE_IN_FLASH + 0x100 ), sizeof(TempBuf)-1 );
	if (TempBuf[0] != 'n')
	{
		strcpy(TempBuf,"Unknown");
	}
	printf("netHD Version: %s\n",  TempBuf );
}
int ImageCanBeUpgrade(IMAGE_TYPE aImageType , int* paUpgradeIsRequired , int* pMd5Matching)
{
	int status;	
	char TempBuf1[128]={0};
	char TempBuf2[128]={0};

	char TempBuf3[16]={0};//md5
	char TempBuf4[16]={0};//md5

	char* p1;
	char* p2;
	char* p3;
	int my_version = -1;
	int usb_version = -1;

	* paUpgradeIsRequired = 0;
	* pMd5Matching = 0;

	memset(TempBuf1, 0, sizeof(TempBuf1) );
	memset(TempBuf2, 0, sizeof(TempBuf2) );

	//find our version and what is supplied in flash.bin file. and display version info.
	if ( UBOOT_CORE1 == aImageType  )
	{
		memcpy(TempBuf1	,  (char*) (UBOOT_CORE1_IN_FLASH + 0x100 )	, sizeof(UBootCore1VersionNo) );
		memcpy(TempBuf2	,  UBootCore1VersionNo						, sizeof(UBootCore1VersionNo) );
	}
	else if (UBOOT_CORE2 == aImageType )
	{
		memcpy(TempBuf1	,  (char*) (UBOOT_CORE2_IN_FLASH + 0x100 )	, sizeof(UBootCore2VersionNo) );
		memcpy(TempBuf2	,  UBootCore2VersionNo						, sizeof(UBootCore2VersionNo) );
	}
	else if (NETHD == aImageType )
	{
		memcpy(TempBuf1	,  (char*) (BOOTP_IAMGE_IN_FLASH + 0x100 )	, sizeof(NetHdVersionNo) );
		memcpy(TempBuf2	,  NetHdVersionNo						    , sizeof(NetHdVersionNo) );
		memcpy(TempBuf3	,  (char*) (BOOTP_IAMGE_IN_FLASH + 0x160 )	, sizeof(TempBuf3) );
		memcpy(TempBuf4 ,  NetHdMd5 , sizeof(TempBuf4) );
	}
	else
	{
		status = -1;
		return status;
	}

	p1 = TempBuf1;
	p2 = TempBuf2;
	printf("Current running version = %s\n", p1);
	printf("USB Stick contains version = %s\n", p2);

	//exteract version, and check if it is lower than only upgrade else skip.
	p3 = strstr(p1, "-svn");
	strcpy( TempBuf1 , p3 + strlen("-svn") );
	if (p3 != 0 )
	{
		my_version = simple_strtoul( TempBuf1 , NULL, 10);
	}

	p3 = strstr(p2, "-svn");
	strcpy( TempBuf2 , p3 + strlen("-svn") );
	if (p3 != 0 )
	{
		usb_version = simple_strtoul( TempBuf2 , NULL, 10);
	}

	if( ( my_version == -1) || (usb_version == -1 ) || (my_version < usb_version) )
	{
		* paUpgradeIsRequired = 1;
	}

	//Add check for 'M' or 'S' suffix.
	if (my_version == usb_version)
	{
		if (TempBuf2 [ strlen(TempBuf1) ] != 0 )	//TempBuf1 contains my_version.
		{
			//it might contain 'M' or 'S' - at this we are decoing that - 'M' - devloper modified build and 'S' - SQA build.
			if ( 0 != strcmp( TempBuf1,TempBuf2 ) )
			{
				* paUpgradeIsRequired = 1;
			}
		}

		//It is null, don't upgrade.
		//Now its time to compare MD5sum - this is new feature added. if MD5 is not matching go for upgrade.
		printf("netHD image versions are matching, comparing MD5. Please wait...\n");
		if (0 != memcmp(TempBuf3, TempBuf4,16) )
		{
			//md5 is not matching, upgrade is required.
			* paUpgradeIsRequired = 1;
		}
		else
		{
			* paUpgradeIsRequired = 0;
			* pMd5Matching=1;
		}
	}
	status =0;
	return status;
}
//--------------------------------------------------------------------------------------------------
int CommonCodeForUpgrade(unsigned int aSourceAddressInMemory, unsigned int aDestinationAddressInFlash , unsigned int aLength )
{
	int status=0;
	int try_cnt=4;
	int fail_cnt=0;

	char BackupBuffer[512];

	char TempCmd2_1[16];	char TempCmd2_2[16];

	char TempCmd31_1[16];	char TempCmd31_2[16];	char TempCmd31_3[16];
	char TempCmd32_1[16];	char TempCmd32_2[16];	char TempCmd32_3[16];
//	char TempCmd33_1[16];	char TempCmd33_2[16];	char TempCmd33_3[16];


	char* pCmd2[3] = {  "erase" ,   NULL ,  NULL  } ;

	char* pCmd31[4] = {  "cp.b"  ,   NULL ,  NULL, NULL } ;
	char* pCmd32[4] = {  "cp.b"  ,   NULL ,  NULL, NULL } ;
//	char* pCmd33[4] = {  "cp.b"  ,   NULL ,  NULL, NULL } ;


	//write from base to +0x100
	sprintf(TempCmd2_1 , "0x%x", aDestinationAddressInFlash );		sprintf(TempCmd2_2 , "0x%x", aDestinationAddressInFlash + aLength - 1 );		//erase command.
	pCmd2[1] =  TempCmd2_1 ;	pCmd2[2] =  TempCmd2_2 ;


	//take-backup.
	memcpy(BackupBuffer, (unsigned char*) ( aSourceAddressInMemory+0 ), sizeof(BackupBuffer) );

	//Fill version buffer with 0xFF
	memset( (unsigned char*) ( aSourceAddressInMemory+0 ), 0xFF, 0x20 );//32 byte of version number


	//write from base to +0x100
	sprintf(TempCmd31_1 , "0x%x", aSourceAddressInMemory+0 );	sprintf(TempCmd31_2 , "0x%x", aDestinationAddressInFlash + 0 );	sprintf(TempCmd31_3 , "0x%x", aLength );		
	pCmd31[1] =  TempCmd31_1 ;	pCmd31[2] =  TempCmd31_2 ;	pCmd31[3] =  TempCmd31_3 ;

	//write only version # at very end of programming.
	sprintf(TempCmd32_1 , "0x%x", aSourceAddressInMemory+0 );	sprintf(TempCmd32_2 , "0x%x", aDestinationAddressInFlash + 0 );	sprintf(TempCmd32_3 , "0x%x", sizeof(BackupBuffer)  );		
	pCmd32[1] =  TempCmd32_1 ;	pCmd32[2] =  TempCmd32_2 ;	pCmd32[3] =  TempCmd32_3 ;

	//write from base + 0x120 - End
//	sprintf(TempCmd33_1 , "0x%x", aSourceAddressInMemory+0x120 );	sprintf(TempCmd33_2 , "0x%x", aDestinationAddressInFlash + 0x120 );	sprintf(TempCmd33_3 , "0x%x", aLength - 0x120 );	
//	pCmd33[1] =  TempCmd33_1 ;	pCmd33[2] =  TempCmd33_2 ;	pCmd33[3] =  TempCmd33_3 ;

	while (try_cnt-- )
	{
		//now erase and program flash.
		printf("%s %s %s\n", pCmd2[0], pCmd2[1], pCmd2[2]);
		status =  do_flerase(NULL, 0,3, pCmd2) ;		

		if (status == 0 )
		{
			printf("%s %s %s %s\n", pCmd31[0], pCmd31[1], pCmd31[2], pCmd31[3]);
			status = do_mem_cp(NULL, 0,4, pCmd31);

			//restore data from backup buffer.
			memcpy( (unsigned char*) ( aSourceAddressInMemory+0 ) , BackupBuffer , sizeof(BackupBuffer) );

			printf("%s %s %s %s\n", pCmd32[0], pCmd32[1], pCmd32[2], pCmd32[3]);
			status = status + do_mem_cp(NULL, 0,4, pCmd32);

		//	printf("%s %s %s %s\n", pCmd32[0], pCmd32[1], pCmd32[2], pCmd32[3]);
		//	status = status + do_mem_cp(NULL, 0,4, pCmd32);

			if (0 == status  )
			{
				//erase and programming is done successfully, break loop and exit.
				fail_cnt=0;
				break;
			}
			else
			{
				fail_cnt++;
				printf("ERROR: failed to programmed, trying one more time...\n");
			}
		}
		else
		{
			fail_cnt++;
			printf("ERROR: failed to erase, trying one more time...\n");
		}
		//now program
	}

	if (fail_cnt != 0 )
	{
		printf("ERROR: all attempts of programming failed, please contact Cavium\n");
		status=-1;
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
int UpgradeUBoot_CavmBootloader(void)
{
	int status;
	
	printf("Upgrading U-Boot\n");
	status = CommonCodeForUpgrade( TEMP_BUFFER_TO_STORE_FW_IMAGE  , UBOOT_CORE1_IN_FLASH , 0xC0000 );
	if (0 == status)
	{
		printf("UBoot for Core1 and Core2 programmed successfully\n");
	}
	else
	{
		printf("ERROR: UBoot for Core1 and Core2 programmeing failed\n");
	}
	return status;
}

int UpgradeUBootCore1(void)
{
	int status;
	
	printf("Upgrading Core1\n");
	status = CommonCodeForUpgrade( TEMP_BUFFER_TO_STORE_FW_IMAGE + UBOOT_CORE1_IN_FILE , UBOOT_CORE1_IN_FLASH , UBOOT_CORE1_MAX_SIZE );
	if (0 == status)
	{
		printf("UBoot Core1 programmed successfully\n");
	}
	else
	{
		printf("ERROR: UBoot Core1 programmeing failed\n");
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
int UpgradeUBootCore2(void)
{
	int status;
	printf("Upgrading Core2\n");
	status = CommonCodeForUpgrade( TEMP_BUFFER_TO_STORE_FW_IMAGE + UBOOT_CORE2_IN_FILE , UBOOT_CORE2_IN_FLASH , UBOOT_CORE1_MAX_SIZE );
	if (0 == status)
	{
		printf("UBoot Core2 programmed successfully\n");
	}
	else
	{
		printf("ERROR: UBoot Core2 programmeing failed\n");
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
int UpgradeNetHD(void)
{
	int status;
	printf("Upgrading NetHD\n");
	status = CommonCodeForUpgrade( TEMP_BUFFER_TO_STORE_FW_IMAGE + BOOTP_IAMGE_IN_FILE , BOOTP_IAMGE_IN_FLASH , BOOTP_IAMGE_MAX_SIZE );
	if (0 == status)
	{
		printf("NetHD programmed successfully\n");
	}
	else
	{
		printf("ERROR: NetHD programmeing failed\n");
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
int UpgradeUBoot(void)
{
	int status ;
	status = UpgradeUBootCore1();
	status = UpgradeUBootCore2();
	return status;
}
//--------------------------------------------------------------------------------------------------
int EraseLastSectorOfNetHD(void)
{
	int status;
	char* cmd2[] = { "erase" , "0x10FC0000", "0x10FDFFFF" };
	printf("EraseLastSectorOfNetHD::going for %s %s %s\n", cmd2[0], cmd2[1], cmd2[2]);
	status =  do_flerase(NULL, 0,3,  cmd2) ;	
	printf("status = %d\n" , status );
	return status;
}
//--------------------------------------------------------------------------------------------------
int StartUsbService(void)
{
	extern int usb_stor_curr_dev;
	int status;
	char* usb_start[] = { "usb" , "start" };
	//printf("Going for UpgradeAllIfRequired\n");
	status = do_usb(NULL, 0, 2, usb_start );
	if ( usb_stor_curr_dev < 0)
	{
		status = -1;
	}
	return status;
}
//--------------------------------------------------------------------------------------------------
int StopUsbService(void)
{
	int status;
	char* usb_stop[] = { "usb" , "stop" };
	printf("Usb serive is stopped now\n");
	status = do_usb(NULL, 0, 2, usb_stop );
	return status;
}
//--------------------------------------------------------------------------------------------------
int UpgradeAllIfRequired(int* apUpgradewasPerformed)
{
	int status=0;
	int UBootCore1UpgradeIsRequired=0;
	int UBootCore2UpgradeIsRequired=0;
	int NetHDUpgradeIsRequired=0;
	int UpgradeUBootAlso=0;
	int Md5Matching=0;

	char * s1 = getenv( "UBOOT_UPDATES2" );

	*apUpgradewasPerformed = 0;

	if ( 0 == strcmp("1", s1 ) )
	{
		UpgradeUBootAlso = 1;
	}		

	status = StartUsbService();
	if ( 0 != status)
	{
		return -1;
	}

	status = ReadAllVersionNumbers();
	if ( 0 != status)
	{
		goto UpgradeAllIfRequired_exit;
	}
	
	if ( 1 == UpgradeUBootAlso )
	{
		status = ImageCanBeUpgrade(UBOOT_CORE1,  & UBootCore1UpgradeIsRequired , & Md5Matching);
		status = ImageCanBeUpgrade(UBOOT_CORE2,  & UBootCore2UpgradeIsRequired , & Md5Matching);
	}

	status = ImageCanBeUpgrade(NETHD,  & NetHDUpgradeIsRequired , & Md5Matching);

    {
        //if usb_updates2 == 2 than upgrade netHD (ignore current version number).
        char * us1 = getenv( "USB_UPDATES2" );
	    if ( 0 == strcmp("2", us1 ) )
	    {
			if (0 == Md5Matching )
			{
				NetHDUpgradeIsRequired = 1;
			}
	    }
    }

	if(0 != ( UBootCore1UpgradeIsRequired | UBootCore2UpgradeIsRequired | NetHDUpgradeIsRequired) )
	{
		status = LoadNetHdCompleteImage();
	}
	if (0 != status )
	{
		goto UpgradeAllIfRequired_exit;
	}
	
	if ( 1 == UBootCore1UpgradeIsRequired )
	{
		printf("UBootCore1 upgrade is required\n");
		status = UpgradeUBootCore1();
		*apUpgradewasPerformed = 1;
		if (0 != status )
		{
			goto UpgradeAllIfRequired_exit;
		}
	}
	else
	{
		printf("UBootCore1 upgrade is NOT required\n");
	}
	//-------------------
	if ( 1 == UBootCore2UpgradeIsRequired )
	{
		printf("UBootCore2 upgrade is required\n");
		status = UpgradeUBootCore2();
		*apUpgradewasPerformed = 1;
		if (0 != status )
		{
			goto UpgradeAllIfRequired_exit;
		}
	}
	else
	{
		printf("UBootCore2 upgrade is NOT required\n");
	}
	//-------------------
	if ( 1 == NetHDUpgradeIsRequired )
	{
		printf("NetHd upgrade is required\n");
		status = UpgradeNetHD();
		*apUpgradewasPerformed = 1;
	}
	else
	{
		printf("NetHd upgrade is NOT required\n");
	}	

UpgradeAllIfRequired_exit:
	//StopUsbService();
	return status;
}
//--------------------------------------------------------------------------------------------------
int do_upgrade( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int status=0;
	int status1=0;
	int status2=0;
	int status3=0;
	int UBootCore1UpgradeIsRequired=0;
	int UBootCore2UpgradeIsRequired=0;
	int NetHdUpgradeIsRequired=0;
	int Md5Matching=0;

	int rc = 0;	

	if (argc < (1+2)  )
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
	}	

	//print current flash version.
	PrintFlashVersion();

	status = StartUsbService();
	if ( 0 != status )
	{
		printf("ERROR: unabel to mount USB deive\n");
		return -1;
	}


	if (  (0 == strcmp(argv[1] , "uboot") ) &&
		   (0 == strcmp(argv[2] , "cavm_bootloader.bin" ) )
		   )
	{
		//print version number from cavm_bootloader.bin file.
		status = ReadVersionNumberFromCavm_BootLoader_BinFile();
	}
	else
	{
		status = ReadAllVersionNumbers();	
		status1 = ImageCanBeUpgrade(UBOOT_CORE1, & UBootCore1UpgradeIsRequired , & Md5Matching);
		status2 = ImageCanBeUpgrade(UBOOT_CORE2, & UBootCore2UpgradeIsRequired , & Md5Matching);
		status3 = ImageCanBeUpgrade(NETHD ,  & NetHdUpgradeIsRequired , & Md5Matching);
	}
	if ( 0 != status)
	{
		return -1;
	}


    if (    (   (0 == strcmp(argv[1] , "uboot") ) ||
                (0 == strcmp(argv[1] , "nethd") ) ||
                (0 == strcmp(argv[1] , "all" ) ) 
            ) 
          &&
          (
                (0 == strcmp(argv[2] , "stat") ) ||
                (0 == strcmp(argv[2] , "start") ) ||
                (0 == strcmp(argv[2] , "force" ) ) ||
                (0 == strcmp(argv[2] , "cavm_bootloader.bin" ) ) 
          )
     )
    {
         if ( 0 == strcmp(argv[2], "stat") )
         {
             //if it is stat than there is no need to load entire image.
         }
         else if ( 0 ==  strcmp(argv[2], "cavm_bootloader.bin") )
         {
             status = LoadCavmBootLoaderIamge(); if ( 0 != status ) { return status; }
             UpgradeUBoot_CavmBootloader();
             return 0;
         }
         else
         {
                if(   ( ( UBootCore1UpgradeIsRequired + UBootCore2UpgradeIsRequired + NetHdUpgradeIsRequired) > 0 ) ||
                      (  0 == strcmp(argv[2] , "force") )
                )
                {
		            status = LoadNetHdCompleteImage(); if ( 0 != status ) { return status; }
                }
         }
    }
    else
    {
        printf("ERROR: Invalid parameter(s) passed\n");
        return -1;
    }

	LedOn();
	if ( 0 == strcmp(argv[2], "stat") )
	{
    }
    else if ( 0 == strcmp(argv[2] , "start" ) )
    {
        if( 0 == strcmp(argv[1], "all" ) ) 
		{
            if( ( UBootCore1UpgradeIsRequired == 1) || (UBootCore2UpgradeIsRequired == 1) )
            {
			    status1 = UpgradeUBootCore1();
			    status2 = UpgradeUBootCore2();
            }
            if ( NetHdUpgradeIsRequired == 1 )
            {
                status3 = UpgradeNetHD();
            }
		}
        else if( 0 == strcmp(argv[1], "nethd") ) 
		{
            if ( NetHdUpgradeIsRequired == 1)
            {
			    status3 = UpgradeNetHD();
            }
		}
        else if( 0 == strcmp(argv[1], "uboot") ) 
		{
			if( ( UBootCore1UpgradeIsRequired == 1) || (UBootCore2UpgradeIsRequired == 1) )
            {
                status1 = UpgradeUBootCore1();
			    status2 = UpgradeUBootCore2();
            }
		}
		else
		{
			printf("ERROR: invalid argument - %s\n" , argv[1] );
			return -1;
		}
    }
    else if ( 0 == strcmp(argv[2] , "force" ) )
    {
		if( 0 == strcmp(argv[1], "all" ) ) 
		{
			status1 = UpgradeUBootCore1();
			status2 = UpgradeUBootCore2();
			status3 = UpgradeNetHD();
		}
        else if( 0 == strcmp(argv[1], "nethd") ) 
		{
			status3 = UpgradeNetHD();
		}
        else if( 0 == strcmp(argv[1], "uboot") ) 
		{
			status1 = UpgradeUBootCore1();
			status2 = UpgradeUBootCore2();
		}
		else
		{
			printf("ERROR: invalid argument - %s\n" , argv[1] );
			return -1;
		}
    }
    //-------------------------------------------------------------------------------------
	rc=0;
	LedOff();
	return (rc);
}

extern int do_tftpb (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[]);

int do_upgradetftp( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int status=0;
	int status1=0;
	int status2=0;
	int status3=0;
	int UBootCore1UpgradeIsRequired=0;
	int UBootCore2UpgradeIsRequired=0;
	int NetHdUpgradeIsRequired=0;
	int Md5Matching=0;

    char TempBuf0[16];
    char TempBuf1[512];
    char TempBuf2[512];
    char* p1[3];
	
    if (argc != 4 )
    {
        printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
    }

    strcpy(TempBuf0, "tftp" );
    strcpy(TempBuf1, "0x04000000" );
    strcpy(TempBuf2, "cavm_netHD.bin" );
    p1[0] = & TempBuf0[0];
    p1[1] = & TempBuf1[0];
    p1[2] = & TempBuf2[0];

    setenv("serverip" , argv[1] );   

    status = do_tftpb (NULL, 0, 3, p1 );

    if ( 0 == status )
    {
        if (status != 0 )
		{
			return status;
		}

        status = ReadAllVersionNumbersTftp();

		status1 = ImageCanBeUpgrade(UBOOT_CORE1, & UBootCore1UpgradeIsRequired , & Md5Matching);
		status2 = ImageCanBeUpgrade(UBOOT_CORE2, & UBootCore2UpgradeIsRequired , & Md5Matching);
		status3 = ImageCanBeUpgrade(NETHD ,  & NetHdUpgradeIsRequired , & Md5Matching);
		
		//u-boot and nethd upgrade both.
		if ( 0 == strcmp(argv[3], "stat"))
		{
		}
		else if ( 0 == strcmp(argv[3], "start" ) )
		{
			if ( 0 == status1 )			
			{
				if ( 1 == UBootCore1UpgradeIsRequired )
				{
                    if( ( 0 == strcmp(argv[2], "uboot" ) ) || ( 0 == strcmp(argv[2], "all" ) ) )
                    {
                        status1 = UpgradeUBootCore1();
                        status2 = UpgradeUBootCore2();
                    }
				}
			}

            if ( 0 == status3 )			
			{
				if ( 1 == NetHdUpgradeIsRequired )
				{
                    if( ( 0 == strcmp(argv[2], "nethd") )  || ( 0 == strcmp(argv[2], "all" ) ) )
                    {
					    status3 = UpgradeNetHD();
                    }
				}
			}
		}
		else if( ( 0 == strcmp(argv[2], "all" ) ) &&  ( 0 == strcmp(argv[3], "force" ) )  )
		{
			status1 = UpgradeUBootCore1();
			status2 = UpgradeUBootCore2();
			status3 = UpgradeNetHD();
		}
        else if( ( 0 == strcmp(argv[2], "nethd") ) &&  ( 0 == strcmp(argv[3], "force" ) ) )
		{
			status3 = UpgradeNetHD();
		}
        else if( ( 0 == strcmp(argv[2], "uboot") ) &&  ( 0 == strcmp(argv[3], "force" ) ) )
		{
			status1 = UpgradeUBootCore1();
			status2 = UpgradeUBootCore2();
		}
    }
    return 0;
}

/**************************************************/
U_BOOT_CMD(
	upgrade,	1+2,	0,	do_upgrade,
	"upgrade     - firmware upgarade for u-boot and nethd using usb memory stick\n",
    "upgrade <uboot/nethd> <stat/start/force>\n"
);

U_BOOT_CMD(
	upgradetftp,	1+3,	0,	do_upgradetftp,
	"upgradetftp - firmware upgarade for u-boot and nethd over tftp\n",
    "upgradetftp <tftp_server_ip_address> <nethd/uboot/all> <stat/start/force>\n"
);
