/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include "u-boot/md5.h"
#include "environment.h"

extern int Sec_GetTagCount(void);
extern char* Sec_GetTagValAtOffset(int aOffset);

int do_nvram_set_defaults( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    int i;
    //int src_ptr=0;
    int dst_ptr=0;
    const char* p1;
    //Clear regular nvram
    env_ClearAll();
    char TempBuf[256];
    int Count = Sec_GetTagCount();
    for(i=0; i < Count ; i++ )
    {
        strcpy ( TempBuf , (const char*)Sec_GetTagValAtOffset(i) );
        p1 = strstr(TempBuf , "seccer_" );
        if (p1 == TempBuf)
        {
            //don't push hdcp secured certificate.
        }
        else
        {
            memcpy ( env_ptr->data + dst_ptr, TempBuf, strlen(TempBuf) );
            dst_ptr = dst_ptr + strlen(TempBuf);
            dst_ptr++;
        }
    }
    *( env_ptr->data + dst_ptr)=0;
    env_ptr->crc = crc32(0, env_ptr->data , sizeof( env_ptr->data ) );
    printf("first string in nvram is %s\n", env_ptr->data );
	saveenv();
	return 0;
}

/**************************************************/
U_BOOT_CMD(
	nvram_set_defaults ,	1,	0,	do_nvram_set_defaults ,
	"nvram_set_defaults	- set nvram default parameter\n",
	"nvram_set_defaults\n"
);
//-----------------------------------------------------------------------------------------------------------------------------------------------------
