/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include "cnw5xxx.h"

/* select core
 *
 * Syntax:
 *	sc {core_no}
 * e.g. "sc 1" OR "sc 2"
 */

int gSelectedCoreNo=1;
int mMyCoreNo=1;

#define IO_WRITE(addr, val) (*(volatile unsigned int *)(addr) = (val))
#define IO_READ(addr) (*(volatile unsigned int *)(addr))

int do_select_core( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int core_no=1;

	int rc = 0;	

	if (argc < 2) 
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return 1;
	}	
	core_no = simple_strtoul(argv[1], NULL, 16);
	if ( ( 1 == core_no ) || (2 == core_no) ) 
	{
		printf("Select core %d\n", core_no );
		gSelectedCoreNo = core_no;
		IO_WRITE(0x7880001c, gSelectedCoreNo);
	}
	else
	{
		printf("ERROR: Invalid core selected\n");
	}
	return (rc);
}



/**************************************************/
U_BOOT_CMD(
	sc,	2,	0,	do_select_core,
	"sc	- select core\n",
	"sc 1 OR sc 2\n"
);


int do_continue2( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int rc = 0;	
	IO_WRITE( CNW5XXX_MISC_BASE + 0x0600 , 0x35678857 ) ;//core 2 was waiting for 0x35678856
	return rc;
}

/**************************************************/
U_BOOT_CMD(
	continue2,	1,	0,	do_continue2,
	"continue2 - core2 will comeout from halt, and it will continue\n",
	"continue2\n"
);

int do_delayIn_mSec(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int Cnt,i;
	Cnt = simple_strtoul(argv[1], NULL, 10);
	for(i=0;i<Cnt;i++)
	{
		udelay(1000);
	}
    return 0;
}

U_BOOT_CMD(
	delay,	2,	0,	do_delayIn_mSec,
	"delay - Delay in mSec (intput parameter decimal)\n",
	"delay 1000\n"
);
