/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <common.h>
#include "cnw5xxx.h"
#include <watchdog.h>
#include <command.h>
#include "u-boot/md5.h"
#include "environment.h"
#include "Hw_Gpio.h"

void RemovePullupFromCecLines(void)
{
	IO_WRITE( 0x76000024 , 0x00FFFFFF & IO_READ(0x76000024) ) ; //For HDMI compliance - electrical test D31-D28 are always set to 0
}

void GpioSetOutputMode(int aGpioPinNo)
{
	GPIOA_DIRECTION_REG = GPIOA_DIRECTION_REG | ( 1 << aGpioPinNo  ) ; 
}
void GpioSetInputMode(int aGpioPinNo)
{
	GPIOA_DIRECTION_REG = GPIOA_DIRECTION_REG & ( ~ ( 1 << aGpioPinNo  ) ) ;
	//Programm GPIO-PULL-UP/DN Control register - configure for Pull-Up else user push button will not work.
	IO_WRITE( 0x76000024 , 0x00FFFFFF & ( (IO_READ(0x76000024) & ( ~ ( 0x3 << (aGpioPinNo*2) ) ) ) | ( 0x2 << (aGpioPinNo*2)  ) ) ) ; //For HDMI compliance - electrical test D31-D28 are always set to 0
}
void GpioSet(int aGpioPinNo, int aData)
{
	if ( 0 == aData)
	{
		GPIOA_DATA_BIT_SET_REG = (1<<aGpioPinNo);    
	}
	else
	{
		GPIOA_DATA_BIT_CLEAR_REG = (1<<aGpioPinNo);
	}
}
int GpioGet(int aGpioPinNo)
{
	return  ((GPIOA_DATA_INPUT_REG & (1 <<aGpioPinNo) ) == 0 ) ? 1 : 0 ;
}

//"gpio_setmode <gpio#> <input/output>"
//"gpio_set <gpio#> <1/0>
//"gpio_get <gpio#>
//
int do_gpio_set( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    int gpio_pin_no = 0;
    int gpio_data = 0;	
//	int rc = -1;	

	if (argc != (1+2)  )
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
	}

    gpio_pin_no = simple_strtoul( argv[1] , NULL, 10);
    gpio_data = simple_strtoul( argv[2] , NULL, 10);

    GpioSet(gpio_pin_no , gpio_data);
    return 0;
}
int do_gpio_get( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    int gpio_pin_no = 0;
   	int gpio_data=0;
//	int rc = -1;	

	if (argc != (1+1)  )
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
	}
    gpio_pin_no = simple_strtoul( argv[1] , NULL, 10);
    gpio_data = GpioGet(gpio_pin_no );
    printf("GPIO_%d=%d\n", gpio_pin_no , gpio_data );
    return 0;
}
int do_gpio_set_mode( cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
     int gpio_pin_no = 0;
//    int gpio_data = 0;	
	int rc = -1;	

	if (argc != (1+2)  )
	{
		printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
	}

    gpio_pin_no = simple_strtoul( argv[1] , NULL, 10);

    if( 0 == strcmp (argv[2] , "input" )  )
    {
        GpioSetInputMode( gpio_pin_no );
        rc=0;
    }
    else if (0 == strcmp (argv[2] , "output" ) )
    {
        GpioSetOutputMode( gpio_pin_no );
        rc=0;
    }
    else
    {
        printf ("Usage:\n%s\n", cmdtp->usage);
		return -1;
    }
	return (rc);
}


U_BOOT_CMD(
	gpio_setmode,	1+2,	0,	do_gpio_set_mode,
	"gpio_setmode <gpio#> <input/output>\n",
    "gpio_setmode <gpio#> <input/output>\n"
);
U_BOOT_CMD(
	gpio_set,	1+2,	0,	do_gpio_set,
	"gpio_set <gpio#> <1/0>\n",
    "gpio_set <gpio#> <1/0>\n"
);
U_BOOT_CMD(
	gpio_get,	1+1,	0,	do_gpio_get,
	"gpio_get <gpio#>\n",
    "gpio_get <gpio#>\n"
);
