/*
 *
 *  Copyright (c) 2008 Cavium Networks 
 * 
 *  This file is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License, Version 2, as 
 *  published by the Free Software Foundation. 
 *
 *  This file is distributed in the hope that it will be useful, 
 *  but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 *  NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this file; if not, write to the Free Software 
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 *  visit http://www.gnu.org/licenses/. 
 *
 *  This file may also be available under a different license from Cavium. 
 *  Contact Cavium Networks for more information
 */
#include <common.h>
#include <command.h>
#include <cnw5xxx.h>

extern inline u32 arm11_read_ccnt(void);
extern inline void arm11_enable_ccnt(void);
extern inline void arm11_enable_ccnt64(void);
extern inline void arm11_reset_ccnt(void);
extern inline u32 arm11_reset_and_read_ccnt(void);



inline u32 arm11_read_ccnt(void)
{
    u32 val;
    asm volatile("mrc p15, 0, %0, c15, c12, 1" : "=r" (val));
    return val;
}


inline void arm11_enable_ccnt(void)
{
    u32 val;
    asm volatile("mrc p15, 0, %0, c15, c12, 0" : "=r" (val));
    val &= ~0x8;
    val |= 0x1;
    asm volatile("mcr p15, 0, %0, c15, c12, 0" : : "r" (val));
}

/* CCNT incremented for every 64th cycle */
inline void arm11_enable_ccnt64(void)
{
    u32 val;
    asm volatile("mrc p15, 0, %0, c15, c12, 0" : "=r" (val));
    val &= ~0x8;
    val |= 0x9;
    asm volatile("mcr p15, 0, %0, c15, c12, 0" : : "r" (val));
}

inline void arm11_reset_ccnt(void)
{
    u32 val;
    asm volatile("mrc p15, 0, %0, c15, c12, 0" : "=r" (val));
    val |= 0x4;
    asm volatile("mcr p15, 0, %0, c15, c12, 0" : : "r" (val));
}


inline u32 arm11_reset_and_read_ccnt(void)
{
	arm11_reset_ccnt();
	return arm11_read_ccnt();
}

