/*
 *  armboot - Startup Code for unknown CPU-core
 *
 *  Copyright (c) 2003  Texas Instruments
 *
 *  ----- Adapted for OMAP1610 OMAP730 from ARM925t code ------
 *
 *  Copyright (c) 2001	Marius Grger <mag@sysgo.de>
 *  Copyright (c) 2002	Alex Zpke <azu@sysgo.de>
 *  Copyright (c) 2002	Gary Jennejohn <gj@denx.de>
 *  Copyright (c) 2003	Richard Woodruff <r-woodruff2@ti.com>
 *  Copyright (c) 2003	Kshitij <kshitij@ti.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>
#include <cnw5xxx.h>
#include "version_autogenerated.h"

/*
 *************************************************************************
 *
 * Jump vector table
 *
 *************************************************************************
 */

.globl _start
.globl _arm_start
.globl __start
.globl _eofm
.globl __eofm 
.globl _bss_start
.globl __bss_start
.globl _bss_end
.globl __end
.globl __ver
.globl IRQ_STACK_START
.globl FIQ_STACK_START
.globl start_code
.globl gMyCpuCoreNo


_start:
	b	    start_code
	ldr	    pc, _undefined_instruction
	ldr	    pc, _software_interrupt
	ldr	    pc, _prefetch_abort
	ldr	    pc, _data_abort
	ldr	    pc, _not_used
	ldr	    pc, _irq
	ldr	    pc, _fiq

	
				.ALIGN(8)
__ver: 			.ascii   U_BOOT_VERSION
				.ALIGN(8)

_undefined_instruction:	.word undefined_instruction
_software_interrupt:	.word software_interrupt
_prefetch_abort:		.word prefetch_abort
_data_abort:			.word data_abort
_not_used:			    .word not_used
_irq:				    .word irq
_fiq:				    .word fiq
				        .balignl 16,0xdeadbeef

/*
 *************************************************************************
 *
 * Startup Code (called from the ARM reset exception vector)
 *
 * do important init only if we don't start from memory!
 * setup memory and board specific bits prior to relocation.
 * relocate armboot to ram
 * setup stack
 *
 *************************************************************************
 */

_TEXT_BASE:		    .word	TEXT_BASE /* address of _start in the linked image */
_arm_start: 		.word 	_start
_eofm:      		.word 	__eofm
_bss_start:		    .word   __bss_start
_bss_end:		    .word   __end
IRQ_STACK_START:	.word	0x0badc0de	/* IRQ stack memory (calculated at run-time) */
FIQ_STACK_START:	.word 	0x0badc0de	/* IRQ stack memory (calculated at run-time) */
_start_armboot:		.word   start_armboot


//the actual start code

start_code:
	ldr	r0, =0x76000600 /* restore AMP register */
	ldr	r1, =0x35678855
	str	r1, [r0]

	ldr	r0, =CORE2_STATUS_REG
	ldr	r1, =CORE2_UNUSED
	str	r1, [r0]
    
	/* Re-map */
	ldr	r0, =0x76000000
	mov	r1, #1
	str	r1, [r0]

	/* Set up the stack						    */
stack_setup_core2:

	ldr	r0, _eofm
	sub	r0, r0, #CFG_MALLOC_LEN	    /* malloc area                      */
	sub	r0, r0, #CFG_GBL_DATA_SIZE  /* bdinfo                        */
#ifdef CONFIG_USE_IRQ
	sub	r0, r0, #(CONFIG_STACKSIZE_IRQ+CONFIG_STACKSIZE_FIQ)
#endif
	sub	sp, r0, #12		    /* leave 3 words for abort-stack    */

clear_bss_core2:
	ldr	    r0, _bss_start		/* find start of bss segment        */
	ldr	    r1, _bss_end		/* stop here                        */
	mov 	r2, #0  		/* clear                            */
clbss_l_core2:str	r2, [r0]		/* clear loop...                    */
	add	r0, r0, #4
	cmp	r0, r1
	ble	clbss_l_core2

    ldr	r0, =gMyCpuCoreNo /* restore AMP register */
	ldr	r1, =2
	str	r1, [r0]

	ldr	pc, _start_armboot

//-------------------------------------------------------------------------------------------------------

/*
 *************************************************************************
 *
 * Interrupt handling
 *
 *************************************************************************
 */

@
@ IRQ stack frame.
@
#define S_FRAME_SIZE	72

#define S_OLD_R0	68
#define S_PSR		64
#define S_PC		60
#define S_LR		56
#define S_SP		52

#define S_IP		48
#define S_FP		44
#define S_R10		40
#define S_R9		36
#define S_R8		32
#define S_R7		28
#define S_R6		24
#define S_R5		20
#define S_R4		16
#define S_R3		12
#define S_R2		8
#define S_R1		4
#define S_R0		0

#define MODE_SVC 0x13
#define I_BIT	 0x80

/*
 * use bad_save_user_regs for abort/prefetch/undef/swi ...
 * use irq_save_user_regs / irq_restore_user_regs for IRQ/FIQ handling
 */

	.macro	bad_save_user_regs
	@ carve out a frame on current user stack
	sub	sp, sp, #S_FRAME_SIZE
	stmia	sp, {r0 - r12}	@ Save user registers (now in svc mode) r0-r12

#if defined (CONFIG_CNW5XXX)
	ldr	r2, _eofm
#else
	ldr	r2, _armboot_start
#endif
	sub	r2, r2, #(CONFIG_STACKSIZE+CFG_MALLOC_LEN)
	sub	r2, r2, #(CFG_GBL_DATA_SIZE+8)  @ set base 2 words into abort stack
	@ get values for "aborted" pc and cpsr (into parm regs)
	ldmia	r2, {r2 - r3}
	add	r0, sp, #S_FRAME_SIZE		@ grab pointer to old stack
	add	r5, sp, #S_SP
	mov	r1, lr
	stmia	r5, {r0 - r3}	@ save sp_SVC, lr_SVC, pc, cpsr
	mov	r0, sp		@ save current stack into r0 (param register)
	.endm

	.macro	irq_save_user_regs
	sub	sp, sp, #S_FRAME_SIZE
	stmia	sp, {r0 - r12}			@ Calling r0-r12
	@ !!!! R8 NEEDS to be saved !!!! a reserved stack spot would be good.
	add	r8, sp, #S_PC
	stmdb	r8, {sp, lr}^		@ Calling SP, LR
	str	lr, [r8, #0]		@ Save calling PC
	mrs	r6, spsr
	str	r6, [r8, #4]		@ Save CPSR
	str	r0, [r8, #8]		@ Save OLD_R0
	mov	r0, sp
	.endm

	.macro	irq_restore_user_regs
	ldmia	sp, {r0 - lr}^			@ Calling r0 - lr
	mov	r0, r0
	ldr	lr, [sp, #S_PC]			@ Get PC
	add	sp, sp, #S_FRAME_SIZE
	subs	pc, lr, #4		@ return & move spsr_svc into cpsr
	.endm

	.macro get_bad_stack
#if defined (CONFIG_CNW5XXX)
	ldr	r13, _eofm
#else
	ldr	r13, _armboot_start		@ setup our mode stack
#endif
	sub	r13, r13, #(CONFIG_STACKSIZE+CFG_MALLOC_LEN)
	sub	r13, r13, #(CFG_GBL_DATA_SIZE+8) @ reserved a couple spots in abort stack

	str	lr, [r13]	@ save caller lr in position 0 of saved stack
	mrs	lr, spsr	@ get the spsr
	str	lr, [r13, #4]	@ save spsr in position 1 of saved stack
	mov	r13, #MODE_SVC	@ prepare SVC-Mode
	@ msr	spsr_c, r13
	msr	spsr, r13	@ switch modes, make sure moves will execute
	mov	lr, pc		@ capture return pc
	movs	pc, lr		@ jump to next instruction & switch modes.
	.endm

	.macro get_irq_stack			@ setup IRQ stack
	ldr	sp, IRQ_STACK_START
	.endm

	.macro get_fiq_stack			@ setup FIQ stack
	ldr	sp, FIQ_STACK_START
	.endm

/*
 * exception handlers
 */
	.align  5
.globl undefined_instruction
undefined_instruction:
	get_bad_stack
	bad_save_user_regs
	bl	do_undefined_instruction

	.align	5
.globl software_interrupt
software_interrupt:
	get_bad_stack
	bad_save_user_regs
	bl	do_software_interrupt

	.align	5
.globl prefetch_abort
prefetch_abort:
	get_bad_stack
	bad_save_user_regs
	bl	do_prefetch_abort

	.align	5
.globl data_abort
data_abort:
	get_bad_stack
	bad_save_user_regs
	bl	do_data_abort

	.align	5
.globl not_used
not_used:
	get_bad_stack
	bad_save_user_regs
	bl	do_not_used

#ifdef CONFIG_USE_IRQ
	.align	5
.globl irq
irq:
	get_irq_stack
	irq_save_user_regs
	bl 	do_irq
	irq_restore_user_regs

	.align	5
.globl fiq
fiq:
	get_fiq_stack
	/* someone ought to write a more effiction fiq_save_user_regs */
	irq_save_user_regs
	bl 	do_fiq
	irq_restore_user_regs

#else

	.align	5
.globl irq
irq:
	get_bad_stack
	bad_save_user_regs
	bl	do_irq

	.align	5
.globl fiq
fiq:
	get_bad_stack
	bad_save_user_regs
	bl	do_fiq

#endif
	.align  5
.globl reset_cpu
reset_cpu:
        /* Global Software Reset */
	ldr	r0, =0x77000004
	mov	r1, #0
	str	r1, [r0]

_loop_forever:
        b       _loop_forever


.globl ArmGoesToWFI

ArmGoesToWFI:
	/* Set WFI */
	mov	r2, #0
	mcr	p15, 0, r2, c7, c0, 4
	b	ArmGoesToWFI

//--------------------------------------
.global RunExternalApp

RunExternalApp:
	mov pc, r0
//-----------------------------------
.globl DDRInitFromBootpImage
DDRInitFromBootpImage:
    push {fp,lr}
    ldr	r0, =0x10200160
    ldr	r1, [r0]
    ldr r0, =0x10200000
    add r1, r1,r0
    mov pc,r1
    pop {fp,pc}

//-------------------------------------------
.globl SplashInitFromBootpImage
SplashInitFromBootpImage:
    push {fp,lr}
    ldr	r0, =0x10200168
    ldr	r1, [r0]
    ldr r0, =0x10200000
    add r1, r1,r0
    mov pc,r1
    pop {fp,pc}
//------------------------------------------

