/*
 * Copyright (c) 2008 Cavium Networks 
 * 
 * Scott Shu
 *
 * macros for the CNW5XXX GEC Network Driver
 *
 * This file is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License, Version 2, as 
 * published by the Free Software Foundation. 
 *
 * This file is distributed in the hope that it will be useful, 
 * but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 * NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License 
 * along with this file; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 * visit http://www.gnu.org/licenses/. 
 *
 * This file may also be available under a different license from Cavium. 
 * Contact Cavium Networks for more information
 */

#ifndef	_CNW5XXX_GEC_H_
#define	_CNW5XXX_GEC_H_

#include <cnw5xxx.h>

#define DRV_NAME	"cnw5xxx_gec"
#define DRV_VERSION	"0.1"
#define DRV_FIRMWARE	0x0011

#ifdef CONFIG_GEC_JUMBO
#define MAX_PACKET_SIZE		9600
#else
#define MAX_PACKET_SIZE		1536
#endif
#define MIN_PACKET_SIZE		60

#define TX_DESC_ALIGNED_SIZE	0x20
#define RX_DESC_ALIGNED_SIZE	0x20

#define TX_DESC_SIZE		10
#define RX_DESC_SIZE		10

#define MAX_PEND_INT_CNT	0x06
#define MAX_PEND_INT_TIME	0x20

#define PACKET_BUFFER_SIZE	1600
#define NUM_PKT_BUFFER		128

#define DEFAULT_VLAN_ID		1

typedef struct {
	u32 sdp;	/* Segment Data Pointer */

	u32 sdl:16;	/* Segment Data Length */
	u32 tco:1;
	u32 uco:1;
	u32 ico:1;
	u32 rsv_1:8;	/* Reserved */
	u32 intr:1;
	u32 lsd:1;
	u32 fsd:1;
	u32 eor:1;
	u32 cown:1;

	u32 ctv:1;
	u32 rsv_2:13;
	u32 tc:2;
	u32 rsv_3:16;

	u32 c_vid:12;
	u32 c_cfi:1;
	u32 c_pri:3;
	u32 rsv_4:16;	/* Reserved */

	u8 align[16];	/* Notice: alignment 32 Byte */

} __attribute__ ((packed)) TNDesc;

typedef struct {
	u32 sdp;	/* Segment Data Pointer */

	u32 sdl:16;
	u32 l4f:1;
	u32 ipf:1;
	u32 prot:4;
	u32 rsv_1:6;
	u32 lsd:1;
	u32 fsd:1;
	u32 eor:1;
	u32 cown:1;

	u32 ctv:1;
	u32 rsv_2:3;
	u32 exdv:1;
	u32 mymac:1;
	u32 hitmac:1;
	u32 rmcmac:1;
	u32 rsv_3:3;
	u32 crc_err:1;
	u32 un_eth:1;
	u32 osize:1;
	u32 rsv_4:2;
	u32 ip_offset:5;
	u32 rsv_5:11;

	u32 c_vid:12;
	u32 c_cfi:1;
	u32 c_pri:3;
	u32 rsv_6:16;

	u8 align[16];	/* Notice: alignment 32 Byte */

} __attribute__ ((packed)) FNDesc;

typedef struct pkt {
	u8		*pkt_buffer;
	u32		length;
	struct pkt	*next;
} pkt_t;

typedef struct {
	struct	net_device *dev;

	/* TN */
	TNDesc	*tn_desc_ring;
	TNDesc	*tn_desc_cur_ring;	/* pointer to the current descriptor */
	int	num_tn_queues;		/* 4 */

	/* FN */
	FNDesc	*fn_desc_ring;
	FNDesc	*fn_desc_cur_ring;	/* pointer to the current descriptor */
	int	num_fn_queues;		/* 1 */

	pkt_t	*fn_pkt_ring[RX_DESC_SIZE];

	u32	tn_desc_cur_index;	/* point to next free descriptors */
	u32	fn_desc_cur_index;	/* point to next free descriptors */

	pkt_t	*fn_pkt_pool;
	u8	*fn_pkt_buffer_pool;
	u32	fn_free_pkt_count;
	pkt_t	*fn_free_pkt_list;
	
	u32	tn_pkt_count;
	u32	fn_pkt_count;

	u8	phy_addr;
	u16	phy_id;

	u8	mac[6];
} gec_device;

#define	GEC_MEM_MAP_VALUE(reg_offset)		(*((u32	volatile *)(CNW5XXX_GEC_BASE + reg_offset)))

/*
 * define access macros
 */
#define	GEC_PHY_CTRL0		GEC_MEM_MAP_VALUE(0x000)
#define	GEC_MAC_CFG0		GEC_MEM_MAP_VALUE(0x004)
#define	GEC_MAC_CFG1		GEC_MEM_MAP_VALUE(0x008)
#define	GEC_FC_CFG0		GEC_MEM_MAP_VALUE(0x00C)
#define GEC_FC_CFG1		GEC_MEM_MAP_VALUE(0x010)
#define	GEC_ARL_CFG		GEC_MEM_MAP_VALUE(0x014)
#define	GEC_MY_MAC_H		GEC_MEM_MAP_VALUE(0x018)
#define	GEC_MY_MAC_L		GEC_MEM_MAP_VALUE(0x01C)
#define	GEC_HASH_CTRL		GEC_MEM_MAP_VALUE(0x020)
#define GEC_HASH_MAC_H		GEC_MEM_MAP_VALUE(0x024)
#define GEC_HASH_MAC_L		GEC_MEM_MAP_VALUE(0x028)
#define	GEC_VLAN_CTRL		GEC_MEM_MAP_VALUE(0x02C)
#define	GEC_VLAN_ID_01		GEC_MEM_MAP_VALUE(0x030)
#define	GEC_VLAN_ID_23		GEC_MEM_MAP_VALUE(0x034)
#define GEC_INT_STATUS		GEC_MEM_MAP_VALUE(0x038)

#define INT0_TNTC_FG_EN		(1 << 25)
#define INT0_TNQE_FG_EN		(1 << 24)
#define INT1_TNTC_FG_EN		(1 << 23)
#define INT1_TNQE_FG_EN		(1 << 22)
#define INT2_TNTC_FG_EN		(1 << 21)
#define INT2_TNQE_FG_EN		(1 << 20)
#define INT3_TNTC_FG_EN		(1 << 19)
#define INT3_TNQE_FG_EN		(1 << 18)
#define INT_FNRC_FG_EN		(1 << 17)
#define INT_FNQF_FG_EN		(1 << 16)
#define MAGIC_PKT_REC_FG_EN	(1 << 5)
#define MIB_CNT_OVER_FG_EN	(1 << 4)
#define PORT_STATUS_CHG_FG_EN	(1 << 3)
#define RXFIFO_FULL_FG_EN	(1 << 2)
#define TXFIFO_OVRUN_FG_EN	(1 << 1)
#define TXFIFO_UNRUN_FG_EN	(1 << 0)

#define	GEC_INT_MASK		GEC_MEM_MAP_VALUE(0x03C)

#define GEC_CLK_SKEW_SET	GEC_MEM_MAP_VALUE(0x040)
#define GEC_MAX_LENGTH_CFG	GEC_MEM_MAP_VALUE(0x044)

#define	GEC_TEST_MODE0		GEC_MEM_MAP_VALUE(0x050)
#define	GEC_TEST_MODE1		GEC_MEM_MAP_VALUE(0x054)

#define	GEC_DMA_CFG		GEC_MEM_MAP_VALUE(0x100)
#define	GEC_DLY_INT_CFG		GEC_MEM_MAP_VALUE(0x104)
#define	GEC_TC_CFG		GEC_MEM_MAP_VALUE(0x108)

#define	GEC_TN0_DMA_CTRL	GEC_MEM_MAP_VALUE(0x110)
#define	GEC_TN0_DESC_PTR	GEC_MEM_MAP_VALUE(0x114)
#define	GEC_TN0_BASE_ADDR	GEC_MEM_MAP_VALUE(0x118)

#define	GEC_TN1_DMA_CTRL	GEC_MEM_MAP_VALUE(0x120)
#define	GEC_TN1_DESC_PTR	GEC_MEM_MAP_VALUE(0x124)
#define	GEC_TN1_BASE_ADDR	GEC_MEM_MAP_VALUE(0x128)

#define	GEC_TN2_DMA_CTRL	GEC_MEM_MAP_VALUE(0x130)
#define	GEC_TN2_DESC_PTR	GEC_MEM_MAP_VALUE(0x134)
#define	GEC_TN2_BASE_ADDR	GEC_MEM_MAP_VALUE(0x138)

#define	GEC_TN3_DMA_CTRL	GEC_MEM_MAP_VALUE(0x140)
#define	GEC_TN3_DESC_PTR	GEC_MEM_MAP_VALUE(0x144)
#define	GEC_TN3_BASE_ADDR	GEC_MEM_MAP_VALUE(0x148)

#define	GEC_FN_DMA_CTRL		GEC_MEM_MAP_VALUE(0x150)
#define	GEC_FN_DESC_PTR		GEC_MEM_MAP_VALUE(0x154)
#define	GEC_FN_BASE_ADDR	GEC_MEM_MAP_VALUE(0x158)

#define	GEC_TN_DMA_STA		GEC_MEM_MAP_VALUE(0x180)
#define	GEC_FN_DMA_STA		GEC_MEM_MAP_VALUE(0x184)
#define	GEC_TN_MRD_CNT		GEC_MEM_MAP_VALUE(0x188)
#define	GEC_TN_MWT_CNT		GEC_MEM_MAP_VALUE(0x18C)
#define	GEC_FN_MRD_CNT		GEC_MEM_MAP_VALUE(0x190)
#define	GEC_FN_MWT_CNT		GEC_MEM_MAP_VALUE(0x194)

#define GEC_CDMA_MON_CFG	GEC_MEM_MAP_VALUE(0x1A0)
#define GEC_CDMA_MON_CNT	GEC_MEM_MAP_VALUE(0x1A4)
#define GEC_CDMA_MON_STA	GEC_MEM_MAP_VALUE(0x1A8)

#define GEC_VER_NUM		GEC_MEM_MAP_VALUE(0x1F0)

#define	GEC_MIB_C_RXOKPKT	GEC_MEM_MAP_VALUE(0x200)
#define	GEC_MIB_C_RXOKBYTE	GEC_MEM_MAP_VALUE(0x204)
#define	GEC_MIB_C_RXRUNT	GEC_MEM_MAP_VALUE(0x208)
#define	GEC_MIB_C_RXLONG	GEC_MEM_MAP_VALUE(0x20C)
#define	GEC_MIB_C_RXNOBUF	GEC_MEM_MAP_VALUE(0x210)
#define	GEC_MIB_C_RXCRC		GEC_MEM_MAP_VALUE(0x214)
#define	GEC_MIB_C_RXMACDROP	GEC_MEM_MAP_VALUE(0x218)
#define	GEC_MIB_C_RXVLANDROP	GEC_MEM_MAP_VALUE(0x21C)
#define	GEC_MIB_C_RXCSMERR	GEC_MEM_MAP_VALUE(0x220)

#define	GEC_MIB_C_RXPAUSE	GEC_MEM_MAP_VALUE(0x228)

#define	GEC_MIB_C_TXPAUSE	GEC_MEM_MAP_VALUE(0x230)
#define GEC_MIB_C_TXSKIP	GEC_MEM_MAP_VALUE(0x234)

#define	GEC_MIB_C_TX0_OKPKT	GEC_MEM_MAP_VALUE(0x250)
#define	GEC_MIB_C_TX0_OKBYTE	GEC_MEM_MAP_VALUE(0x254)
#define	GEC_MIB_C_TX1_OKPKT	GEC_MEM_MAP_VALUE(0x258)
#define	GEC_MIB_C_TX1_OKBYTE	GEC_MEM_MAP_VALUE(0x25C)
#define	GEC_MIB_C_TX2_OKPKT	GEC_MEM_MAP_VALUE(0x260)
#define	GEC_MIB_C_TX2_OKBYTE	GEC_MEM_MAP_VALUE(0x264)
#define	GEC_MIB_C_TX3_OKPKT	GEC_MEM_MAP_VALUE(0x268)
#define	GEC_MIB_C_TX3_OKBYTE	GEC_MEM_MAP_VALUE(0x26C)

#endif /* _CNW5XXX_GEC_H_ */
