
/*******************************************************************************
 *
 * Copyright (c) 2010 Cavium Networks 
 * Derek Chickles, <derek.chickles@caviumnetworks.com>
 * 
 * This file is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License, Version 2, as 
 * published by the Free Software Foundation. 
 *
 * This file is distributed in the hope that it will be useful, 
 * but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 * NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License 
 * along with this file; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 * visit http://www.gnu.org/licenses/. 
 *
 * This file may also be available under a different license from Cavium. 
 * Contact Cavium Networks for more information
 *
 ******************************************************************************/

#include <common.h>

#include <cnw5xxx.h>

#define IO_WRITE(addr, val) (*(volatile unsigned int *)(addr) = (val))
#define IO_READ(addr) (*(volatile unsigned int *)(addr))

#ifdef CONFIG_CNW5XXX_PCI
void pci_init_board (void)
{
	if ( 1 == gMyCpuCoreNo)
	{
		unsigned int temp;

	    /* Enable PCIe reference clock */
		temp = IO_READ(CNW5XXX_PMU_BASE + PMU_SYS_CLK_CTRL_OFFSET);
		temp |= (1 << 28);
		IO_WRITE(CNW5XXX_PMU_BASE + PMU_SYS_CLK_CTRL_OFFSET, temp);

	    /* Assert PCIe RESET */
		temp = IO_READ(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET);
		temp &= ~(1 << 26);
		IO_WRITE(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET, temp);
    
		udelay(CONFIG_CNW5XXX_PCI_RESET_DELAY);

	    /* De-assert PCIe RESET */
		temp = IO_READ(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET);
		temp |= (1 << 26);
		IO_WRITE(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET, temp);
	}
}
#endif
