/*******************************************************************************
 *
 * Copyright (c) 2008 Cavium Networks 
 * Scott Shu, <scott.shu@caviumnetworks.com>
 * 
 * This file is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License, Version 2, as 
 * published by the Free Software Foundation. 
 *
 * This file is distributed in the hope that it will be useful, 
 * but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 * NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License 
 * along with this file; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 * visit http://www.gnu.org/licenses/. 
 *
 * This file may also be available under a different license from Cavium. 
 * Contact Cavium Networks for more information
 *
 ******************************************************************************/

#include <common.h>

#include "serial_cnw5xxx.h"

#include <cnw5xxx.h>

#define IO_WRITE(addr, val) (*(volatile unsigned int *)(addr) = (val))
#define IO_READ(addr) (*(volatile unsigned int *)(addr))

static volatile unsigned char *const port[] = CONFIG_CNW5XXX_PORTS;
#define NUM_PORTS (sizeof(port)/sizeof(port[0]))

#ifdef CONFIG_CNW5XXX_SERIAL
int serial_init (void)
{
	if ( 1 == gMyCpuCoreNo)
	{
	unsigned int temp;
#ifndef CONFIG_CNW5XXX_BOARD_CYPRESS
	unsigned int divisor;
#endif

	/* clock out for hardware debug */
	temp = IO_READ(CNW5XXX_PMU_BASE + PMU_SYS_CLK_CTRL_OFFSET);
	temp |= (0x0f << 16);
	temp |= (0x00 << 20);
	IO_WRITE(CNW5XXX_PMU_BASE + PMU_SYS_CLK_CTRL_OFFSET, temp);

	/* Hardware Initialization. */
	/* scott.silicon */
	/* Clock 24MHz for UART */
	temp = IO_READ(CNW5XXX_PMU_BASE + PMU_PLL_HM_PD_CTRL_OFFSET);
	temp &= ~(0x1 << 3);
	IO_WRITE(CNW5XXX_PMU_BASE + PMU_PLL_HM_PD_CTRL_OFFSET, temp);

	/* UART clock enable */
	temp = IO_READ(CNW5XXX_PMU_BASE + PMU_CLK_GATE_OFFSET);
	temp |= (0x1 << 8);
	IO_WRITE(CNW5XXX_PMU_BASE + PMU_CLK_GATE_OFFSET, temp);

	/* UART software reset */
	temp = IO_READ(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET);
	temp &= ~(0x1 << 8);
	IO_WRITE(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET, temp);

#ifdef CONFIG_CNW5XXX_BOARD_CYPRESS
	/* Set PMU CSR */
	temp = CONFIG_BAUDRATE * 16 * 1024 / 1000 * 1024 / 1000 * 1024 / 300;	/* CSR number */
	temp |= (0x1 << 30);							/* CSR enable */
	IO_WRITE(CNW5XXX_PMU_BASE + PMU_CSR_OFFSET, temp);
#endif

	udelay(300000);

	/* exit reset */
	temp = IO_READ(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET);
	temp |= (0x1 << 8);
	IO_WRITE(CNW5XXX_PMU_BASE + PMU_SOFT_RST_OFFSET, temp);

	/* Enter DLAB mode */
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LCR,
		   IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LCR) | UART_CNW5XXX_LCR_DLAB_ENABLE);

	/* Set pre-scalar value of UART baud rate generator */
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_PSR, (0x01 & 0x03));

#ifdef CONFIG_CNW5XXX_BOARD_CYPRESS
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_DLL, 0x01);
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_DLM, 0x00);
#else
	temp = 16 * CONFIG_BAUDRATE;
	divisor = CONFIG_CNW5XXX_CLOCK / temp;

	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_DLL, (divisor & 0xff));
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_DLM, ((divisor & 0xff00) >> 8));
#endif

	/* Exit DLAB mode */
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LCR,
		   IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LCR) & ~(UART_CNW5XXX_LCR_DLAB_ENABLE));

	/* Set the UART to be 8 bits, 1 stop bit, no parity. */
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LCR,
		   (UART_CNW5XXX_LCR_WLEN_8 | UART_CNW5XXX_LCR_STOP_BIT_1 | UART_CNW5XXX_LCR_PARITY_NONE));

	/* Set the UART to fifo enabled. */
#define CONFIG_CNW5XXX_UART_FIFO
#ifdef CONFIG_CNW5XXX_UART_FIFO
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_FCR,
		   (UART_CNW5XXX_FCR_FIFO_ENABLE | UART_CNW5XXX_FCR_RXFIFO_TRIGGER_LEVEL_8 |
		    UART_CNW5XXX_FCR_RXFIFO_RESET | UART_CNW5XXX_FCR_TXFIFO_RESET));
#endif
	/* Finally, enable the UART */

	 IO_WRITE(port[CONFIG_CONS_INDEX] + UART_CNW5XXX_SPR, 1) ; //Take UART under control so other core will not use uart.

	}
	return 0;
}
#endif /* CONFIG_CNW5XXX_SERIAL */

extern int  gSelectedCoreNo;
int serial_getc (void)
{
	unsigned int data;

	/* Wait until there is data in the FIFO */
	while (1)
	{
		/* wait */
		if ( 1 == gMyCpuCoreNo)
		{
			if ( 1 == ( IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_SPR) & 0xFF ) )
			{
				gSelectedCoreNo =1;
				if ( (IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LSR) & UART_CNW5XXX_LSR_DATA_READY) == UART_CNW5XXX_LSR_DATA_READY )
				{
					break;
				}
			}
		}
		else
		{
			if ( 2 == ( IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_SPR) & 0xFF ) )
			{
				gSelectedCoreNo =2;
				if ( (IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LSR) & UART_CNW5XXX_LSR_DATA_READY) == UART_CNW5XXX_LSR_DATA_READY )
				{
					break;
				}
			}
		}
		//some other core (core 2) is using UART		
	}

	data = IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_RBR);

	return (int) data;
}

static void cnw5xxx_putc (char c)
{
	/* Wait until there is space in the FIFO */
	while ((IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LSR) & UART_CNW5XXX_LSR_THR_EMPTY) != UART_CNW5XXX_LSR_THR_EMPTY)
		; /* wait */

	/* Send the character */
	IO_WRITE (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_THR, c);
}

void serial_putc (const char c)
{
	if (c == '\n')
		cnw5xxx_putc ('\r');

	cnw5xxx_putc (c);
}

void serial_puts (const char *s)
{
	while (*s) {
		serial_putc (*s++);
	}
}

int serial_tstc (void)
{
	return ((IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LSR) & UART_CNW5XXX_LSR_DATA_READY) == UART_CNW5XXX_LSR_DATA_READY);
}

int serial_getc_nowait(void)
{
	if ((IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_LSR) & UART_CNW5XXX_LSR_DATA_READY) == UART_CNW5XXX_LSR_DATA_READY)
    {
        return (unsigned char) IO_READ (port[CONFIG_CONS_INDEX] + UART_CNW5XXX_RBR);
    }
    return -1;
}

void serial_setbrg (void)
{
}

