#ifndef __HW_GPIO_H__
#define __HW_GPIO_H__


#define SYS_GPIOA_BASE_ADDR                    0x74000000


#define GPIOA_BASE_ADDR                         (SYS_GPIOA_BASE_ADDR)

#define GPIOA_MEM_MAP_ADDR(reg_offset)          (GPIOA_BASE_ADDR + reg_offset)
 
#define GPIOA_MEM_MAP_VALUE(reg_offset)         (*((UInt32 volatile *)GPIOA_MEM_MAP_ADDR(reg_offset)))

#define GPIOA_DATA_OUTPUT_REG                   GPIOA_MEM_MAP_VALUE(0x00)
#define GPIOA_DATA_INPUT_REG                    GPIOA_MEM_MAP_VALUE(0x04)
#define GPIOA_DIRECTION_REG                     GPIOA_MEM_MAP_VALUE(0x08)

#define GPIOA_DATA_BIT_SET_REG                  GPIOA_MEM_MAP_VALUE(0x10)
#define GPIOA_DATA_BIT_CLEAR_REG                GPIOA_MEM_MAP_VALUE(0x14)

#define GPIOA_INTERRUPT_ENABLE_REG              GPIOA_MEM_MAP_VALUE(0x20)
#define GPIOA_INTERRUPT_RAW_STATUS_REG          GPIOA_MEM_MAP_VALUE(0x24)
#define GPIOA_INTERRUPT_MASKED_STATUS_REG       GPIOA_MEM_MAP_VALUE(0x28)
#define GPIOA_INTERRUPT_MASK_REG                GPIOA_MEM_MAP_VALUE(0x2C)
#define GPIOA_INTERRUPT_CLEAR_REG               GPIOA_MEM_MAP_VALUE(0x30)
#define GPIOA_INTERRUPT_TRIGGER_METHOD_REG      GPIOA_MEM_MAP_VALUE(0x34)
#define GPIOA_INTERRUPT_TRIGGER_BOTH_EDGES_REG  GPIOA_MEM_MAP_VALUE(0x38)
#define GPIOA_INTERRUPT_TRIGGER_TYPE_REG        GPIOA_MEM_MAP_VALUE(0x3C)

#define GPIOA_BOUNCE_ENABLE_REG                 GPIOA_MEM_MAP_VALUE(0x40)
#define GPIOA_BOUNCE_CLOCK_PRESCALE_REG         GPIOA_MEM_MAP_VALUE(0x44)


#define MAX_GPIO_PINS           (32)

#define GPIO_0_MASK             (1 << 0)
#define GPIO_1_MASK             (1 << 1)
#define GPIO_2_MASK             (1 << 2)
#define GPIO_3_MASK             (1 << 3)
#define GPIO_4_MASK             (1 << 4)
#define GPIO_5_MASK             (1 << 5)
#define GPIO_6_MASK             (1 << 6)
#define GPIO_7_MASK             (1 << 7)
#define GPIO_8_MASK             (1 << 8)
#define GPIO_9_MASK             (1 << 9)
#define GPIO_10_MASK            (1 << 10)
#define GPIO_11_MASK            (1 << 11)
#define GPIO_12_MASK            (1 << 12)
#define GPIO_13_MASK            (1 << 13)
#define GPIO_14_MASK            (1 << 14)
#define GPIO_15_MASK            (1 << 15)
#define GPIO_16_MASK            (1 << 16)
#define GPIO_17_MASK            (1 << 17)
#define GPIO_18_MASK            (1 << 18)
#define GPIO_19_MASK            (1 << 19)
#define GPIO_20_MASK            (1 << 20)
#define GPIO_21_MASK            (1 << 21)
#define GPIO_22_MASK            (1 << 22)
#define GPIO_23_MASK            (1 << 23)
#define GPIO_24_MASK            (1 << 24)
#define GPIO_25_MASK            (1 << 25)
#define GPIO_26_MASK            (1 << 26)
#define GPIO_27_MASK            (1 << 27)
#define GPIO_28_MASK            (1 << 28)
#define GPIO_29_MASK            (1 << 29)
#define GPIO_30_MASK            (1 << 30)
#define GPIO_31_MASK            (1 << 31)


/*
 * macro declarations for GPIO Set A
 */
#define HAL_GPIOA_READ_DATA_OUT_STATUS(data_out_state) \
    ((data_out_state) = (GPIOA_DATA_OUTPUT_REG))

#define HAL_GPIOA_READ_DATA_IN_STATUS(data_in_state) \
    ((data_in_state) = (GPIOA_DATA_INPUT_REG))

#define HAL_GPIOA_SET_DIRECTION_OUTPUT(gpio_index) \
    ((GPIOA_DIRECTION_REG) |= (gpio_index))

#define HAL_GPIOA_SET_DIRECTION_INPUT(gpio_index) \
    ((GPIOA_DIRECTION_REG) &= ~(gpio_index))

#define HAL_GPIOA_SET_DATA_OUT_HIGH(gpio_index) \
    ((GPIOA_DATA_BIT_SET_REG) = (gpio_index))

#define HAL_GPIOA_SET_DATA_OUT_LOW(gpio_index) \
    ((GPIOA_DATA_BIT_CLEAR_REG) = (gpio_index))

#define HAL_GPIOA_ENABLE_INTERRUPT(gpio_index) \
    ((GPIOA_INTERRUPT_ENABLE_REG) |= (gpio_index))

#define HAL_GPIOA_READ_INTERRUPT_ENABLE(data) \
    ((data) = (GPIOA_INTERRUPT_ENABLE_REG))



    
#define HAL_GPIOA_DISABLE_INTERRUPT(gpio_index) \
    ((GPIOA_INTERRUPT_ENABLE_REG) &= ~(gpio_index))

#define HAL_GPIOA_READ_INTERRUPT_RAW_STATUS(raw_state) \
    ((raw_state) = (GPIOA_INTERRUPT_RAW_STATUS_REG))
    
#define HAL_GPIOA_READ_INTERRUPT_MASKED_STATUS(masked_raw_state) \
    ((masked_raw_state) = (GPIOA_INTERRUPT_MASKED_STATUS_REG))

#define HAL_GPIOA_DISABLE_INTERRUPT_MASK(gpio_index) \
    ((GPIOA_INTERRUPT_MASK_REG) &= ~(gpio_index))

#define HAL_GPIOA_ENABLE_INTERRUPT_MASK(gpio_index) \
    ((GPIOA_INTERRUPT_MASK_REG) |= (gpio_index))

#define HAL_GPIOA_CLEAR_INTERRUPT(gpio_index) \
    ((GPIOA_INTERRUPT_CLEAR_REG) = (gpio_index))

#define HAL_GPIOA_SET_INTERRUPT_EDGE_TRIGGER_MODE(gpio_index) \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) &= ~(gpio_index))
    
#define HAL_GPIOA_SET_INTERRUPT_LEVEL_TRIGGER_MODE(gpio_index) \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) |= (gpio_index))

#define HAL_GPIOA_SET_INTERRUPT_SINGLE_EDGE_TRIGGER_MODE(gpio_index) \
{ \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) &= ~(gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_BOTH_EDGES_REG) &= ~(gpio_index)); \
}

#define HAL_GPIOA_SET_INTERRUPT_BOTH_EDGE_TRIGGER_MODE(gpio_index) \
{ \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) &= ~(gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_BOTH_EDGES_REG) |= (gpio_index)); \
}

#define HAL_GPIOA_SET_INTERRUPT_SINGLE_RISING_EDGE_TRIGGER_MODE(gpio_index) \
{ \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) &= ~(gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_BOTH_EDGES_REG) &= ~(gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_TYPE_REG) &= ~(gpio_index)); \
}

#define HAL_GPIOA_SET_INTERRUPT_SINGLE_FALLING_EDGE_TRIGGER_MODE(gpio_index) \
{ \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) &= ~(gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_BOTH_EDGES_REG) &= ~(gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_TYPE_REG) |= (gpio_index)); \
}

#define HAL_GPIOA_SET_INTERRUPT_HIGH_LEVEL_TRIGGER_MODE(gpio_index) \
{ \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) |= (gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_TYPE_REG) &= ~(gpio_index)); \
}

#define HAL_GPIOA_SET_INTERRUPT_LOW_LEVEL_TRIGGER_MODE(gpio_index) \
{ \
    ((GPIOA_INTERRUPT_TRIGGER_METHOD_REG) |= (gpio_index)); \
    ((GPIOA_INTERRUPT_TRIGGER_TYPE_REG) |= (gpio_index)); \
}

#define HAL_GPIOA_ENABLE_BOUNCE(gpio_index) \
    ((GPIOA_BOUNCE_ENABLE_REG) |= (gpio_index))

#define HAL_GPIOA_DISABLE_BOUNCE(gpio_index) \
    ((GPIOA_BOUNCE_ENABLE_REG) &= ~(gpio_index))

#define HAL_GPIOA_READ_BOUNCE_PRESCALE_RATIO(prescale_ratio) \
    ((prescale_ratio) = ((GPIOA_BOUNCE_CLOCK_PRESCALE_REG) & 0x0000FFFF))

#define HAL_GPIOA_WRITE_BOUNCE_PRESCALE_RATIO(prescale_ratio) \
    ((GPIOA_BOUNCE_CLOCK_PRESCALE_REG) = (prescale_ratio & 0x0000FFFF))

//--------------------------------------------------------------------------------------------------------------------------------------------




#endif 
