/*
 *  Copy from Linux : arch/arm/mach-cns3000/include/mach/board-vega.h
 *
 *  Copyright (c) 2008 Cavium Networks 
 * 
 *  This file is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License, Version 2, as 
 *  published by the Free Software Foundation. 
 *
 *  This file is distributed in the hope that it will be useful, 
 *  but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 *  NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this file; if not, write to the Free Software 
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 *  visit http://www.gnu.org/licenses/. 
 *
 *  This file may also be available under a different license from Cavium. 
 *  Contact Cavium Networks for more information
 */

#ifndef __CNW5XXX_H__
#define __CNW5XXX_H__

/*
 * Peripheral addresses
 */

#define CNW5XXX_FLASH0_BASE		0x10000000	/* Flash/SRAM Memory Bank 0 */
#define CNW5XXX_FLASH0_SIZE		SZ_16M
#define CNW5XXX_FLASH1_BASE		0x11000000	/* Flash/SRAM Memory Bank 1 */
#define CNW5XXX_FLASH1_SIZE		SZ_16M
#define CNW5XXX_FLASH2_BASE		0x12000000	/* Flash/SRAM Memory Bank 2 */
#define CNW5XXX_FLASH2_SIZE		SZ_16M
#define CNW5XXX_FLASH3_BASE		0x13000000	/* Flash/SRAM Memory Bank 3 */
#define CNW5XXX_FLASH3_SIZE		SZ_16M

#define CNW5XXX_DDR2SDRAM_BASE		0x20000000	/* DDR2 SDRAM Memory */

#define CNW5XXX_SPI_FLASH_BASE		0x60000000	/* SPI Serial Flash Memory */
#define CNW5XXX_GEC_BASE		0x70000000	/* Gigabit Ethernet Controller */
#define CNW5XXX_SSP_BASE		0x71000000	/* Synchronous Serial Port - I2C(TWI)/SPI */

#define I2C_CFG_OFFSET				0x20
#define I2C_TIMEOUT_OFFSET			0x24
#define I2C_SLAVE_ADDR_OFFSET			0x28
#define I2C_WR_DATA_OFFSET			0x2C
#define I2C_RD_DATA_OFFSET			0x30
#define I2C_INTR_STAT_OFFSET			0x34
#define I2C_INTR_ENA_OFFSET			0x38
#define I2C_OUT_DLY_OFFSET			0x3C

#define SPI_CFG_OFFSET				0x40
#define SPI_STAT_OFFSET				0x44
#define	SPI_BIT_RATE_OFFSET			0x48
#define SPI_TX_CTRL_OFFSET			0x4C
#define SPI_TX_DATA_OFFSET			0x50
#define SPI_RX_CTRL_OFFSET			0x54
#define SPI_RX_DATA_OFFSET			0x58
#define SPI_FIFO_TX_CFG_OFFSET			0x5C
#define SPI_FIFO_TX_CTRL_OFFSET			0x60
#define SPI_FIFO_RX_CFG_OFFSET			0x64
#define SPI_INTR_STAT_OFFSET			0x68
#define SPI_INTR_ENA_OFFSET			0x6C
#define SPI_ACCESS_CMD_OFFSET			0x70

#define CNW5XXX_DMC_BASE		0x72000000	/* DMC Control (DDR2 SDRAM) */

#define DMC_MEMC_STATUS_OFFSET			0x000
#define DMC_MEMC_CMD_OFFSET			0x004
#define DMC_DIRECT_CMD_OFFSET			0x008
#define DMC_MEMORY_CFG_OFFSET			0x00C
#define DMC_REFRESH_PRD_OFFSET			0x010
#define DMC_CAS_LATENCY_OFFSET			0x014
#define DMC_WRITE_LATENCY_OFFSET		0x018
#define DMC_T_MRD_OFFSET			0x01C
#define DMC_T_RAS_OFFSET			0x020
#define DMC_T_RC_OFFSET				0x024
#define DMC_T_RCD_OFFSET			0x028
#define DMC_T_RFC_OFFSET			0x02C
#define DMC_T_RP_OFFSET				0x030
#define DMC_T_RRD_OFFSET			0x034
#define DMC_T_WR_OFFSET				0x038
#define DMC_T_WTR_OFFSET			0x03C
#define DMC_T_XP_OFFSET				0x040
#define DMC_T_XSR_OFFSET			0x044
#define DMC_T_ESR_OFFSET			0x048
#define DMC_MEMORY_CFG2_OFFSET			0x04C
#define DMC_MEMORY_CFG3_OFFSET			0x050
#define DMC_T_FAW_OFFSET			0x054
#define DMC_ID_0_CFG_OFFSET			0x100
#define DMC_CHIP_0_CFG_OFFSET			0x200
#define DMC_USER_STATUS_OFFSET			0x300
#define DMC_USER_CONFIG0_OFFSET			0x304
#define DMC_USER_CONFIG1_OFFSET			0x308
#define DMC_FEATURE_CTRL_OFFSET			0x30C

#define DMC_PHY_CTRL_OFFSET						0x400
#define DMC_PHY_DETECT_CTRL_OFFSET				0x404
#define DMC_PHY_DETECT_CFG_OFFSET				0x408
#define DMC_PHY_GATE_CTRL_OFFSET				0x40C
#define DMC_PHY_RD_DATA_SLICE_0_CTRL_OFFSET		0x410
#define DMC_PHY_RD_DATA_SLICE_1_CTRL_OFFSET		0x414
#define DMC_PHY_RD_DATA_SLICE_2_CTRL_OFFSET		0x418
#define DMC_PHY_RD_DATA_SLICE_3_CTRL_OFFSET		0x41C
#define DMC_PHY_CLK_DLY_CTRL_OFFSET				0x420
#define DMC_PHY_DLL_LOCK_VALUE_OFFSET			0x424
#define DMC_PHY_ZQ_CTRL_OFFSET					0x428
#define DMC_PHY_ZQ_STATUS_OFFSET				0x42C
#define DMC_READ_DELAY_OFFSET					0x430

#define DMC_PERIPH_ID_0_OFFSET			0xFE0
#define DMC_PCELL_ID_0_OFFSET			0xFF0

#define CNW5XXX_SMC_BASE		0x73000000	/* SMC Control */

#define SMC_MEMC_STATUS_OFFSET			0x000
#define SMC_MEMIF_CFG_OFFSET			0x004
#define SMC_MEMC_CFG_SET_OFFSET			0x008
#define SMC_MEMC_CFG_CLR_OFFSET			0x00C
#define SMC_DIRECT_CMD_OFFSET			0x010
#define SMC_SET_CYCLES_OFFSET			0x014
#define SMC_SET_OPMODE_OFFSET			0x018
#define SMC_REFRESH_PERIOD_0_OFFSET		0x020
#define SMC_REFRESH_PERIOD_1_OFFSET		0x024

#define SMC_SRAM_CYCLES0_0_OFFSET		0x100		/* SMC Interface 0, NOR flash */
#define SMC_OPMODE0_0_OFFSET			0x104
#define SMC_SRAM_CYCLES0_1_OFFSET		0x120
#define SMC_OPMODE0_1_OFFSET			0x124
#define SMC_SRAM_CYCLES0_2_OFFSET		0x140
#define SMC_OPMODE0_2_OFFSET			0x144
#define SMC_SRAM_CYCLES0_3_OFFSET		0x160
#define SMC_OPMODE0_3_OFFSET			0x164

#define SMC_NAND_CYCLES1_0_OFFSET		0x180		/* SMC Interface 1, NAND flash */
#define SMC_OPMODE1_0_OFFSET			0x184
#define SMC_NAND_CYCLES1_1_OFFSET		0x1A0
#define SMC_OPMODE1_1_OFFSET			0x1A4
#define SMC_NAND_CYCLES1_2_OFFSET		0x1C0
#define SMC_OPMODE1_2_OFFSET			0x1C4
#define SMC_NAND_CYCLES1_3_OFFSET		0x1E0
#define SMC_OPMODE1_3_OFFSET			0x1E4

#define SMC_USER_STATUS_OFFSET			0x200
#define SMC_USER_CONFIG_OFFSET			0x204

#define SMC_ECC_STATUS_OFFSET			0x300
#define SMC_ECC_MEMCFG_OFFSET			0x304
#define SMC_ECC_MEMCOMMAND1_OFFSET		0x308
#define SMC_ECC_MEMCOMMAND2_OFFSET		0x30C
#define SMC_ECC_ADDR0_OFFSET			0x310
#define SMC_ECC_ADDR1_OFFSET			0x314
#define SMC_ECC_VALUE0_OFFSET			0x318
#define SMC_ECC_VALUE1_OFFSET			0x31C
#define SMC_ECC_VALUE2_OFFSET			0x320
#define SMC_ECC_VALUE3_OFFSET			0x324

#define SMC_MBECC1_STATUS_OFFSET		0x600		/* MBECC add-on */
#define SMC_MBECC1_CFG_OFFSET			0x604
#define SMC_MBECC1_MEMCMD0_OFFSET		0x608
#define SMC_MBECC1_MEMCMD1_OFFSET		0x60C

#define SMC_PERIPH_ID_0_OFFSET			0xFE0
#define SMC_PERIPH_ID_1_OFFSET			0xFE4
#define SMC_PERIPH_ID_2_OFFSET			0xFE8
#define SMC_PERIPH_ID_3_OFFSET			0xFEC
#define SMC_PCELL_ID_0_OFFSET			0xFF0
#define SMC_PCELL_ID_1_OFFSET			0xFF4
#define SMC_PCELL_ID_2_OFFSET			0xFF8
#define SMC_PCELL_ID_3_OFFSET			0xFFC

#define SMC_INT_OUTPUTS_OFFSET			0xE08

#define CNW5XXX_GPIOA_BASE		0x74000000	/* GPIO port A */
#define CNW5XXX_GPIOB_BASE		0x74800000	/* GPIO port B */
#define CNW5XXX_EFS_BASE		0x75000000	/* E-Fuse */

#define CNW5XXX_MISC_BASE		0x76000000	/* Misc Control */

#define MISC_REMAP_OFFSET			0x00
#define MISC_CHIP_CFG_OFFSET			0x04

#define MISC_IO_CTRL_OFFSET			0x10
#define MISC_GPIOA_PIN_EN_OFFSET		0x14
#define MISC_GPIOB_PIN_EN_OFFSET		0x18

#define MISC_SPInCS1_PIN		(0x1 << 7)
#define MISC_SPInCS0_PIN		(0x1 << 8)
#define MISC_SPICLK_PIN			(0x1 << 9)
#define MISC_SPIDT_PIN			(0x1 << 10)
#define MISC_SPIDR_PIN			(0x1 << 11)
#define MISC_SPI_PIN			(MISC_SPInCS1_PIN | MISC_SPInCS0_PIN | MISC_SPICLK_PIN | MISC_SPIDT_PIN | MISC_SPIDR_PIN)

#define MISC_I2C_SCL_PIN		(0x1 << 12)
#define MISC_I2C_SDA_PIN		(0x1 << 13)
#define MISC_I2C_PIN			(MISC_I2C_SCL_PIN | MISC_I2C_SDA_PIN)

#define MISC_IOCDA_OFFSET			0x1C
#define MISC_IOCDB_OFFSET			0x20
#define MISC_GPIOAPUD0_OFFSET			0x24
#define MISC_GPIOAPUD1_OFFSET			0x28
#define MISC_GPIOBPUD0_OFFSET			0x2C
#define MISC_GPIOBPUD1_OFFSET			0x30
#define MISC_IOPUD_OFFSET			0x34

#define MISC_CPU_CLUST_ID_OFFSET		0x100
#define MISC_CPU_PERIPH_BASE_OFFSET		0x104
#define MISC_L2CC_CTRL_OFFSET			0x200
#define MISC_L2CC_FADR_OFFSET			0x204

#define CNW5XXX_PMU_BASE		0x77000000	/* Power Management Control */

#define PMU_CLK_GATE_OFFSET			0x00
#define PMU_SOFT_RST_OFFSET			0x04
#define PMU_HS_CFG_OFFSET			0x08
#define PMU_CACTIVE_STA_OFFSET			0x0C
#define PMU_PWR_STA_OFFSET			0x10
#define PMU_SYS_CLK_CTRL_OFFSET			0x14
#define PMU_PLL_LCD_I2S_CTRL_OFFSET		0x18
#define PMU_PLL_HM_PD_CTRL_OFFSET		0x1C
#define PMU_REGULAT_CTRL_OFFSET			0x20
#define PMU_WDT_CTRL_OFFSET			0x24
#define PMU_WU_CTRL0_OFFSET			0x28
#define PMU_WU_CTRL1_OFFSET			0x2C
#define PMU_CSR_OFFSET				0x30
#define PMU_AV_CLK_RST_CTRL_OFFSET		0x34
#define PMU_MB_INT_STS_OFFSET			0x38
#define PMU_MB_INT_MSK_OFFSET			0x3C
#define PMU_MB_INT_SET_OFFSET			0x40
#define PMU_MB_INT_CLR_OFFSET			0x44
#define PMU_DATA2ARM11_OFFSET			0x48
#define PMU_DATA2HOST_OFFSET			0x4C

#define CNW5XXX_UART0_BASE		0x78000000	/* UART 0 */
#define CNW5XXX_UART1_BASE		0x78400000	/* UART 1 */
#define CNW5XXX_UART2_BASE		0x78800000	/* UART 2 */
/* The other UART registers are defined in drivers/serial/serial_cnw5xxx.h */

#define CNW5XXX_DMAC_BASE		0x79000000	/* Generic DMA Control */

#define CNW5XXX_CRYPTO_BASE		0x7B000000	/* Crypto */

#define CNW5XXX_TIMER_BASE		0x7C800000	/* Timer (external timer) */

#define TIMER0_COUNTER_OFFSET			0x00
#define TIMER0_AUTO_RELOAD_OFFSET		0x04
#define TIMER0_MATCH_V1_OFFSET			0x08
#define TIMER0_MATCH_V2_OFFSET			0x0C

#define TIMER1_COUNTER_OFFSET			0x10
#define TIMER1_AUTO_RELOAD_OFFSET		0x14
#define TIMER1_MATCH_V1_OFFSET			0x18
#define TIMER1_MATCH_V2_OFFSET			0x1C

#define TIMER0_1_CONTROL_OFFSET			0x30
#define TIMER0_1_INTERRUPT_STATUS_OFFSET	0x34
#define TIMER0_1_INTERRUPT_MASK_OFFSET		0x38

#define TIMER_FREERUN_OFFSET			0x40
#define TIMER_FREERUN_CONTROL_OFFSET		0x44

#define CNW5XXX_AXI_IXC_BASE		0x7F000000	/* AXI IXC */

#define CNW5XXX_USBOTG_BASE		0x81000000	/* USB OTG Control */

#define CNW5XXX_USB_BASE		0x82000000	/* USB Host Control */

#define CNW5XXX_PVU_BASE		0x84000000	/* PureVu */

#define CNW5XXX_SDIO_BASE		0x85000000	/* SDIO */

#define SDIO_DMA_SYS_ADDR_OFFSET		0x00
#define SDIO_BLK_CNT_SIZE_OFFSET		0x04
#define SDIO_ARGUMENT_CTRL_OFFSET		0x08
#define SDIO_CMD_TRAN_MODE_OFFSET		0x0C
#define SDIO_RESPONSE0_OFFSET			0x10
#define SDIO_RESPONSE1_OFFSET			0x14
#define SDIO_RESPONSE2_OFFSET			0x18
#define SDIO_RESPONSE3_OFFSET			0x1C
#define SDIO_BUF_DATA_PORT_OFFSET		0x20
#define SDIO_PRE_STATE_OFFSET			0x24
#define SDIO_SD_HOST_CTRL_OFFSET		0x28
#define SDIO_PWR_HOST_CTRL_OFFSET		0x2C
#define SDIO_INTR_STATUS_OFFSET			0x30
#define SDIO_INTR_ENABLE_OFFSET			0x34
#define SDIO_INTR_SIG_ENABLE_OFFSET		0x38
#define SDIO_CMD12_ERR_STATUS_OFFSET		0x3C
#define SDIO_CAPABILITY0_OFFSET			0x40
#define SDIO_CAPABILITY1_OFFSET			0x44
#define SDIO_MAX_CURR_CAP0_OFFSET		0x48
#define SDIO_MAX_CURR_CAP1_OFFSET		0x4C
#define SDIO_FORCE_EVENT_OFFSET			0x50
#define SDIO_HOST_CTRL_SLOT_STATUS_OFFSET	0xFC

#define CNW5XXX_2DG_BASE		0x87000000	/* 2D Graphic Control */

#define CNW5XXX_USB_OHCI_BASE		0x88000000	/* USB Open Host Control Interface (OHCI) */

#define CNW5XXX_L2C_BASE		0x92000000	/* L2 Cache Control */

#define CNW5XXX_PCIE0_MEM_BASE		0xA0000000	/* PCIe Port 0 Memory Space */
#define CNW5XXX_PCIE0_HOST_BASE		0xAB000000	/* PCIe Port 0 RC Configuration Space */
#define CNW5XXX_PCIE0_IO_BASE		0xAC000000	/* PCIe Port 0 IO Space */
#define CNW5XXX_PCIE0_CFG0_BASE		0xAD000000	/* PCIe Port 0 CFG Type 0 */
#define CNW5XXX_PCIE0_CFG1_BASE		0xAE000000	/* PCIe Port 0 CFG Type 1 */
#define CNW5XXX_PCIE0_MSG_BASE		0xAF000000	/* PCIe Port 0 Message Space */

#define CNW5XXX_AXI_SRAM_BASE		0xB0000000	/* AXI SRAM Memory Space */

#define CNW5XXX_NAND_FLASH0_BASE	0xC0000000	/* NAND Flash Memory Bank 0 */
#define CNW5XXX_NAND_FLASH0_SIZE	SZ_128M
#define CNW5XXX_NAND_FLASH1_BASE	0xC8000000	/* NAND Flash Memory Bank 1 */
#define CNW5XXX_NAND_FLASH1_SIZE	SZ_128M
#define CNW5XXX_NAND_FLASH2_BASE	0xD0000000	/* NAND Flash Memory Bank 2 */
#define CNW5XXX_NAND_FLASH2_SIZE	SZ_128M
#define CNW5XXX_NAND_FLASH3_BASE	0xD8000000	/* NAND Flash Memory Bank 3 */
#define CNW5XXX_NAND_FLASH3_SIZE	SZ_128M

/*
 *
 */
#define CNW5XXX_TC11MP_SCU_BASE		0x90000000	/* IRQ, Test chip */

#define SCU_CTRL_OFFSET			0x00
#define SCU_CONFIG_OFFSET		0x04
#define SCU_CPU_STATUS_OFFSET		0x08
#define SCU_INVALIDATE_OFFSET		0x0c
#define SCU_FPGA_REVISION_OFFSET	0x10

#define CNW5XXX_TC11MP_GIC_CPU_BASE	0x90000100	/* Test chip interrupt controller CPU interface */
#define CNW5XXX_TC11MP_TWD_BASE		0x90000700
#define CNW5XXX_TC11MP_TWD_SIZE		0x00000100
#define CNW5XXX_TC11MP_GIC_DIST_BASE	0x90001000	/* Test chip interrupt controller distributor */

#define GIC_CPU_CTRL_OFFSET		0x00
#define GIC_CPU_PRIMASK_OFFSET		0x04
#define GIC_CPU_BINPOINT_OFFSET		0x08
#define GIC_CPU_INTACK_OFFSET		0x0c
#define GIC_CPU_EOI_OFFSET		0x10
#define GIC_CPU_RUNNINGPRI_OFFSET	0x14
#define GIC_CPU_HIGHPRI_OFFSET		0x18


/* ------- L2 Cache related defines ------------ */

#define CNW5XXX_L2CC_BASE_VIRT		0xFFF27000

#define L2CC_CACHE_ID				0x000
#define L2CC_CACHE_TYPE				0x004
#define L2CC_CTRL					0x100
#define L2CC_AUX_CTRL				0x104
#define L2CC_TAG_RAM_LATENCY_CTRL	0x108
#define L2CC_DATA_RAM_LATENCY_CTRL	0x10C
#define L2CC_EVENT_CNT_CTRL			0x200
#define L2CC_EVENT_CNT1_CFG			0x204
#define L2CC_EVENT_CNT0_CFG			0x208
#define L2CC_EVENT_CNT1_VAL			0x20C
#define L2CC_EVENT_CNT0_VAL			0x210
#define L2CC_INTR_MASK				0x214
#define L2CC_MASKED_INTR_STAT		0x218
#define L2CC_RAW_INTR_STAT			0x21C
#define L2CC_INTR_CLEAR				0x220
#define L2CC_CACHE_SYNC				0x730
#define L2CC_INV_LINE_PA			0x770
#define L2CC_INV_WAY				0x77C
#define L2CC_CLEAN_LINE_PA			0x7B0
#define L2CC_CLEAN_LINE_IDX			0x7B8
#define L2CC_CLEAN_WAY				0x7BC
#define L2CC_CLEAN_INV_LINE_PA		0x7F0
#define L2CC_CLEAN_INV_LINE_IDX		0x7F8
#define L2CC_CLEAN_INV_WAY			0x7FC
#define L2CC_LOCKDOWN_0_WAY_D		0x900
#define L2CC_LOCKDOWN_0_WAY_I		0x904
#define L2CC_LOCKDOWN_1_WAY_D		0x908
#define L2CC_LOCKDOWN_1_WAY_I		0x90C
#define L2CC_LOCKDOWN_2_WAY_D		0x910
#define L2CC_LOCKDOWN_2_WAY_I		0x914
#define L2CC_LOCKDOWN_3_WAY_D		0x918
#define L2CC_LOCKDOWN_3_WAY_I		0x91C
#define L2CC_LOCKDOWN_4_WAY_D		0x920
#define L2CC_LOCKDOWN_4_WAY_I		0x924
#define L2CC_LOCKDOWN_5_WAY_D		0x928
#define L2CC_LOCKDOWN_5_WAY_I		0x92C
#define L2CC_LOCKDOWN_6_WAY_D		0x930
#define L2CC_LOCKDOWN_6_WAY_I		0x934
#define L2CC_LOCKDOWN_7_WAY_D		0x938
#define L2CC_LOCKDOWN_7_WAY_I		0x93C
#define L2CC_LOCKDOWN_LINE_EN		0x950
#define L2CC_UNLOCK_ALL_LINE_WAY	0x954
#define L2CC_ADDR_FILTER_START		0xC00
#define L2CC_ADDR_FILTER_END		0xC04
#define L2CC_DEBUG_CTRL				0xF40

#define CACHE_LINE_SIZE				32


#define CORE1_CORE2_SPLASH_INIT ( 0x8000000 - (5*4) )//0x07FF_FFEC//Splash_Init- 0-bootp, 1-CORE1, 2-CORE2
#define CORE1_CORE2_DDR_INIT    ( 0x8000000 - (4*4) )//0x07FF_FFF0//DDR_INIT     0-bootp, 1-CORE1, 2-CORE2
#define CORE2_GO_ADDRESS		( 0x8000000 - (3*4) )//0x07FF_FFF4
#define CORE1_STATUS_REG		( 0x8000000 - (2*4) )//0x07FF_FFF8
#define CORE2_STATUS_REG		( 0x8000000 - (1*4) )//0x07FF_FFFC

#define IO_WRITE(addr, val) (*(volatile unsigned int *)(addr) = (val))
#define IO_READ(addr) (*(volatile unsigned int *)(addr))

//typedef enum CORE1_STATUS
//{
#define CORE1_NOT_RUNNING	(0x10)
#define CORE1_DDR_INIT_DONE (0x11)
#define CORE1_RUNNING		(0x12)
#define CORE1_DONE			(0x13)
#define CORE1_UNUSED1		(0x14)
#define CORE1_UNUSED2		(0x15)

//}CORE1_STATUS;

//typedef enum CORE2_STATUS
//{
#define CORE2_NOT_RUNNING	(0x20)
#define CORE2_UNUSED		(0x21)
#define CORE2_RUNNING		(0x22)
#define CORE2_NETHD_MODIFIED (0x24)
#define CORE2_DONE2			(0x25)
//}CORE2_STATUS;

/*------------------------------------------*/

#endif	/* __CNW5XXX_H__ */
