/*
 * (C) Copyright 2003
 * Texas Instruments.
 * Kshitij Gupta <kshitij@ti.com>
 * Configuation settings for the TI OMAP Innovator board.
 *
 * (C) Copyright 2004
 * ARM Ltd.
 * Philippe Robin, <philippe.robin@arm.com>
 * Configuration for Versatile PB.
 *
 * (C) Copyright 2008
 * Cavium Networks Ltd.
 * Scott Shu <scott.shu@caviumnetworks.com>
 * Configuration for Cavium Networks CNW5XXX Platform
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H
/*
 *  Code, etc. common to all ARM supplied development boards
 */
#include <armsupplied.h>

/*
 * Board info register
 */
#define SYS_ID  (0x10000000)
#define ARM_SUPPLIED_REVISION_REGISTER SYS_ID

/*
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_CNW5XXX		1		/* in a Cavium Networks CNW5XXX SoC */
#define CONFIG_CNW5XXX_CHIPA	1		/* Chip Ver_A */

#define	CONFIG_BOOT_ONENAND
#undef CONFIG_BOOT_ONENAND

#define CFG_MEMTEST_START	0x001A0000      /* low memory required of uboot. */
//#define CFG_MEMTEST_END		0x08000000	/* 128MB, 0x10000000 for 256MB */
#define CFG_MEMTEST_END_CORE1	0x07e5ffff	/* 128MB minus the required space of uboot. */
#define CFG_MEMTEST_END_CORE2	0x07e5ffff	/* 128MB minus the required space of uboot. */
//#define CFG_ALT_MEMTEST		1           /* alternate long testing patterns */
#ifndef CFG_ALT_MEMTEST
 #define CFG_SHORT_MEMTEST		1       /* short testing patterns */
 /* special controls for diagsnostics dual core test, see fasm_diags.c */
 #define CFG_MTEST_MMUTLB_DDUAL	0x07800000  /* MMU TLB setup addr - not adjustable yet */
 #define CFG_MTEST_START_DDUAL	0x07900000  /* range for diags dual core test */
 #define CFG_MTEST_END_DDUAL  	0x07e5ffff  /* range for diags dual core test */
 #define CFG_MTEST_STVAL_DDUAL	0xFEDCBA98  /* start value for ddual core test */
 #define CFG_MTEST_PASS_DDUAL   0xCABACABA  /* pass value for ddual core test */
 #define CFG_MTEST_FAIL_DDUAL   0xDEADDEAD  /* fail value for ddual core test */
 #define CFG_MTEST_TIMO_DDUAL   0xFEED0040  /* timeout fail value for ddual core test */
 #define CFG_MTEST_DISA_DDUAL   0xDAB00DAB  /* disable value for ddual core test */
#endif //

#define CFG_HZ	       		(1000)
#define CFG_HZ_CLOCK		1000000		/* Timers clocked at 1Mhz */
#define CFG_TIMERBASE		0x7C800000	/* Timer 1 base	*/
#define CFG_TIMER_RELOAD	0xFFFFFFFF
#define TIMER_LOAD_VAL		CFG_TIMER_RELOAD

//#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs	*/
//#define CONFIG_SETUP_MEMORY_TAGS	1
//#define CONFIG_MISC_INIT_R		1	/* call misc_init_r during start up */

/*
 * Size of malloc() pool
 */
#define CFG_MALLOC_LEN		(CONFIG_ENV_SIZE + 512*1024)
#define CFG_GBL_DATA_SIZE	128	/* size in bytes reserved for initial data */

/*
 * Hardware drivers
 */

#define CONFIG_CNW5XXX_BOARD_CYPRESS		1

/*
 * select serial console configuration
 */
/*
 * NS16550 Configuration
 */
# define CFG_SERIAL0		0x78000000
# define CFG_SERIAL1		0x78400000
# define CFG_SERIAL2		0x78800000

#define CONFIG_CNW5XXX_SERIAL
#define CONFIG_CNW5XXX_CLOCK	24000000
#define CONFIG_CNW5XXX_PORTS	{ (void *)CFG_SERIAL0, (void *)CFG_SERIAL1, (void *)CFG_SERIAL2 }
#define CONFIG_CONS_INDEX	2

#define CONFIG_BAUDRATE		115200
#define CFG_BAUDRATE_TABLE	{ 2400, 4800, 9600, 19200, 38400, 57600, 115200 }

#define CONFIG_CMDLINE_EDITING

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE

/*
 * PCIe
 */
#define CONFIG_CNW5XXX_PCI
#define CONFIG_CNW5XXX_PCI_RESET_DELAY    100000   /* 100 ms */

/*
 * Real Time Clock
 */
#undef CONFIG_RTC_CNW5XXX

/* 
 * MMC/SD Host Controller
 */
#define CONFIG_CNW5XXX_MMC	1

#ifdef CONFIG_CNW5XXX_MMC
#define CONFIG_MMC              1
#define CONFIG_DOS_PARTITION    1
#endif

/*
 * I2C
 */
#define CONFIG_CNW5XXX_I2C	1
 #undef CONFIG_CNW5XXX_I2C

#ifdef CONFIG_CNW5XXX_I2C
#define CONFIG_HARD_I2C		/* I2C with hardware support */
#undef CONFIG_SOFT_I2C		/* I2C bit-banged */

#define I2C_INIT
#define I2C_ACTIVE		0
#define I2C_TRISTATE		0

#define CFG_I2C_SLAVE		0x0	/* mask valid bits */
#define CFG_I2C_SPEED		100000	/* use the standard 100KHz speed, max = 400KHz */
#endif /* CONFIG_CNW5XXX_I2C */

/*
 * Command line configuration.
 */
#define CONFIG_CMD_BDI
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_ENV
#define CONFIG_CMD_FLASH
#define CONFIG_CMD_USB
#define CONFIG_CMD_IMI
#define CONFIG_CMD_MEMORY
#define CONFIG_CMD_NET
#define CONFIG_CMD_PING
#define CONFIG_CMD_LOADB
#define CONFIG_CMD_CACHE
#define CONFIG_CMD_ELF
#define CONFIG_CMD_RUN
#define CONFIG_CMD_NAND
 #undef CONFIG_CMD_NAND
#define CONFIG_CMD_JFFS2

#ifdef CONFIG_BOOT_ONENAND
#define CONFIG_ONENAND_U_BOOT

 #undef CONFIG_CMD_FLASH
#define CONFIG_CMD_ONENAND

#define CFG_ONENAND_BASE	0x10000000
#define CFG_MAX_ONENAND_DEVICE	1

#define CONFIG_OPTIMIZED_FOR_1K
#endif

#define CONFIG_JFFS2_CMDLINE

#define MTDIDS_DEFAULT    "nor0=jffs2"
#define MTDPARTS_DEFAULT  "mtdparts=jffs2:768K@0x140000(splash)"

#ifdef CONFIG_RTC_CNW5XXX
#define CONFIG_CMD_DATE
#endif

#ifdef CONFIG_CNW5XXX_MMC
#define CONFIG_CMD_MMC
#define CONFIG_CMD_FAT
#endif

#ifdef CONFIG_CNW5XXX_I2C
#define CONFIG_CMD_I2C
#endif


#define CONFIG_UDP_CHECKSUM
#define CONFIG_UDP_FRAGMENT	1

#define CONFIG_BOOTDELAY	2

#if 0

#ifdef CONFIG_UDP_FRAGMENT
#define CONFIG_EXTRA_ENV_SETTINGS	\
	"pv_ddr2_speed=0\0"		\
	"tftp_bsize=512\0"		\
	"udp_frag_size=512\0"		\
	"mtdparts="MTDPARTS_DEFAULT"\0"	\
	"mtdids="MTDIDS_DEFAULT"\0"	\
	"partition=nor0\0"
#else 
#define CONFIG_EXTRA_ENV_SETTINGS	\
	"pv_ddr2_speed=0\0"		\
	"mtdparts="MTDPARTS_DEFAULT"\0"	\
	"mtdids="MTDIDS_DEFAULT"\0"	\
	"partition=nor0\0"
#endif

#define CFG_AUTOLOAD "no"

/*
The kernel command line & boot command below are for a Cavium Networks CNW5XXX board
0x00000000  u-boot
0x0000????  knuxernel 
0x0000????  Root File System
*/

#define CONFIG_BOOTARGS "root=/dev/mtdblock0 mem=128M console=ttyS0"
#ifdef CONFIG_BOOT_ONENAND
#define CONFIG_BOOTCOMMAND "onenand"
#else
#define CONFIG_BOOTCOMMAND "go 10200000"
#endif

/*
 * Static configuration when assigning fixed address
 */
#define CONFIG_ETHADDR		00:53:43:4F:54:54
#define CONFIG_NETMASK		255.255.0.0		/* talk on MY local net */
#define CONFIG_IPADDR		172.20.5.230		/* static IP I currently own */
#define CONFIG_SERVERIP		172.20.5.200		/* current IP of my dev pc */
#define CONFIG_BOOTFILE		bootpImage		/* file to load */

#endif

#define MAX( a,b)     	( (a > b) ? (a) : (b) )
#define MIN( a,b)      	( (a > b) ? (b) : (a) )

/*
 * Miscellaneous configurable options
 */
#define CFG_LONGHELP				/* undef to save memory		 */
#define CFG_PROMPT_CORE1		("CNW5XXX-1 # ")
#define CFG_PROMPT_CORE2		("CNW5XXX-2 # ")
#define CFG_CBSIZE		        (256)		/* Console I/O Buffer Size	*/
/* Print Buffer Size */
#define CFG_PBSIZE		        ( CFG_CBSIZE + MAX ( sizeof(CFG_PROMPT_CORE1) , sizeof(CFG_PROMPT_CORE2) ) + 16 )
#define CFG_MAXARGS		        (16)		/* max number of command args	 */
#define CFG_BARGSIZE		    (CFG_CBSIZE)	/* Boot Argument Buffer Size		*/
#undef	CFG_CLKS_IN_HZ				            /* everything, incl board info, in Hz */
#define CFG_LOAD_ADDR		    (0x00800000)	/* default load address */

/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */
#define CONFIG_STACKSIZE	(128*1024)	/* regular stack */
#ifdef CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ	(4*1024)	/* IRQ stack */
#define CONFIG_STACKSIZE_FIQ	(4*1024)	/* FIQ stack */
#endif

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#undef PHYS_SDRAM_32BIT					/* undefined: 16 bits, defined: 32 bits */

#define CONFIG_NR_DRAM_BANKS		1		/* we have 1 bank of DRAM */
#define PHYS_SDRAM_1		       	0x00000000	/* SDRAM Bank #1 */

#ifdef PHYS_SDRAM_32BIT
#define PHYS_SDRAM_1_SIZE		0x10000000	/* 0x10000000 = 256 MB */
#else
#define PHYS_SDRAM_1_SIZE		0x08000000	/* 0x08000000 = 128 MB */
#endif

#define CFG_MONITOR_BASE		TEXT_BASE

/*-----------------------------------------------------------------------
 * Ethernet configuration
 */
#define CONFIG_DRIVER_CNW5XXX_GEC
#define CONFIG_NETDEV			eth0

/*-----------------------------------------------------------------------
 * USB OHCI configuration
 */
#ifdef CONFIG_CMD_USB
#define CONFIG_USB_OHCI_NEW		1
#define CFG_USB_OHCI_CPU_INIT		1
#define CFG_USB_OHCI_REGS_BASE		CNW5XXX_USB_OHCI_BASE
#define CFG_USB_OHCI_SLOT_NAME		"cnw5xxx"
#define CFG_USB_OHCI_MAX_ROOT_PORTS	4
#define LITTLEENDIAN			1

#define CONFIG_USB_STORAGE
#ifndef CONFIG_DOS_PARTITION
#define CONFIG_DOS_PARTITION		1
#endif
#endif
/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
/*
 *  Use the CFI flash driver for ease of use
 */
#define CFG_FLASH_BASE			0x10000000

#define CFG_FLASH_CFI			1
#define CONFIG_FLASH_CFI_DRIVER		1
#define CONFIG_FLASH_SHOW_PROGRESS	45			/* count down from 45/5: 9..1 */

#define CFG_FLASH_CFI_WIDTH		FLASH_CFI_16BIT
#define CONFIG_FLASH_CFI_LEGACY

#define CFG_FLASH_LEGACY_16MiBx16

#define CFG_MAX_FLASH_BANKS		1			/* max number of memory banks */

#if defined(CFG_FLASH_LEGACY_8MiBx8)
	#define PHYS_FLASH_SIZE			0x00800000	/* 8MB */
	#define CFG_MAX_FLASH_SECT		135		/* 135 max number of sectors on one chip */
#elif defined(CFG_FLASH_LEGACY_128MiBx16)
	#define PHYS_FLASH_SIZE			0x08000000	/* 128MB */
	#define CFG_MAX_FLASH_SECT		1024		/* 1024 max number of sectors on one chip */
#elif defined(CFG_FLASH_LEGACY_16MiBx16)
	#define PHYS_FLASH_SIZE			0x01000000	/* 16MB */
	#define CFG_MAX_FLASH_SECT		128		/* 128 max number of sectors on one chip */
#else
	#define PHYS_FLASH_SIZE			0x08000000	/* 128MB */
	#define CFG_MAX_FLASH_SECT		1024		/* 1024 max number of sectors on one chip */
#endif

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT		(120 * CFG_HZ)		/* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT		(120 * CFG_HZ)		/* Timeout for Flash Write */

#define CFG_FLASH_EMPTY_INFO		1			/* flinfo indicates empty blocks */

/*
 * SPI serial flash (dataflash) (Base Address: 0x60000000)
 */
#define CONFIG_SPI_FLASH_BOOT		1
 #undef CONFIG_SPI_FLASH_BOOT
#define CONFIG_SPI			1
 #undef CONFIG_SPI

#define CFG_SPI_FLASH_BASE		0x60000000

#define CFG_MAX_DATAFLASH_BANKS		1
#define CFG_DATAFLASH_LOGIC_ADDR_CS0	CFG_SPI_FLASH_BASE	/* Logical adress for CS0 */

/* environment data, spi dataflash only. */
#define  CONFIG_ENV_IS_IN_DATAFLASH
 #undef  CONFIG_ENV_IS_IN_DATAFLASH	/* comment this line to program spiflash on u-boot */

#ifdef CONFIG_ENV_IS_IN_DATAFLASH

#undef CFG_FLASH_CFI
#undef CONFIG_FLASH_CFI_DRIVER
#undef CONFIG_FLASH_CFI_LEGACY
#undef CFG_FLASH_LEGACY_8MiBx8
#undef CFG_FLASH_LEGACY_16MiBx16

#define CONFIG_HAS_DATAFLASH		1
#define CONFIG_CNW5XXX_SPI		1

#define CONFIG_ENV_SIZE			0x40000			/* Total Size of Environment Sector */
#define CONFIG_ENV_OFFSET		0x80000			/* the offset of u-boot environment on dataflash */
#define CONFIG_ENV_ADDR			(CFG_DATAFLASH_LOGIC_ADDR_CS0 + CONFIG_ENV_OFFSET) /* the address of environment */

#define CONFIG_KERNEL_OFFSET		0x100000		/* the offset of bootpImage on dataflash */
#define	CONFIG_KERNEL_END		0x7FFFFF		/* the end of bootpImage on dataflash */
#elif defined(CONFIG_BOOT_ONENAND)
#define CFG_NO_FLASH
#undef CFG_FLASH_CFI
#undef CONFIG_FLASH_CFI_DRIVER
#undef CONFIG_FLASH_CFI_LEGACY
#undef CFG_FLASH_LEGACY_8MiBx8
#undef CFG_FLASH_LEGACY_16MiBx16
#undef CONFIG_ENV_IS_IN_FLASH

#define CONFIG_ENV_IS_IN_ONENAND	1
#define CONFIG_ENV_ADDR			0x00040000
#define CONFIG_ENV_SIZE			0x20000
#else /* !CONFIG_ENV_IS_IN_DATAFLASH */
#define CONFIG_ENV_IS_IN_FLASH		1
#define CONFIG_ENV_SIZE			0x20000
#define CONFIG_ENV_OFFSET		(PHYS_FLASH_SIZE - CONFIG_ENV_SIZE)
#define CONFIG_ENV_ADDR			(CFG_FLASH_BASE + CONFIG_ENV_OFFSET)
#endif /* CONFIG_ENV_IS_IN_DATAFLASH */

#ifdef CONFIG_SPI_FLASH_BOOT
#undef CONFIG_BOOTCOMMAND
#define CONFIG_BOOTCOMMAND		""
#endif /* CONFIG_SPI_FLASH_BOOT */

/* Defines for NAND flash support */
#define CFG_NAND_BASE        0xE0000000
#define CFG_MAX_NAND_DEVICE  1	/* Max number of NAND devices */
/* Address lines that are used for ALE/CLE control signals */
#define NAND_ALE_ADDR_BIT    13
#define NAND_CLE_ADDR_BIT    14

#define CFG_CONSOLE_INFO_QUIET

#define CONFIG_CMD_MD5SUM
#define CONFIG_MD5


//-----------------------------------------------------------------------------------------------------------------------
#define TEMP_BUFFER_TO_STORE_FW_IMAGE		   (0x04000000)
#define TEMP_BUFFER_TO_STORE_FW_IMAGE_INSTRING ("0x04000000")
//-----------------------------------------------------------------------------------------------------------------------
#define FLASH_START_ADDRESS		(0x10000000)
#define UBOOT_CORE1_OFFSET		(0x00000000)
#define UBOOT_CORE2_OFFSET		(0x00060000)
#define FPGA__OFFSET			(0x000C0000)
#define SPLASH_OFFSET			(0x00140000)
#define BOOTP_IAMGE_OFFSET		(0x00200000)
#define NVRAM_OFFSET			(0x00FE0000)
//-----------------------------------------------------------------------------------------------------------------------
#define UBOOT_CORE1_IN_FLASH	(FLASH_START_ADDRESS	+	UBOOT_CORE1_OFFSET	)		//0x10000000
#define UBOOT_CORE2_IN_FLASH	(FLASH_START_ADDRESS	+	UBOOT_CORE2_OFFSET	)		//0x10060000
#define FPGA_IN_FLASH			(FLASH_START_ADDRESS	+	FPGA__OFFSET		)		//0x100C0000
#define SPLASH_IN_FLASH			(FLASH_START_ADDRESS	+	SPLASH_OFFSET		)		//0x10140000
#define BOOTP_IAMGE_IN_FLASH	(FLASH_START_ADDRESS	+	BOOTP_IAMGE_OFFSET	)		//0x10200000
#define NVRAM_IN_FLASH			(FLASH_START_ADDRESS	+	NVRAM_OFFSET		)		//0x10FE0000
//-----------------------------------------------------------------------------------------------------------------------
#define UBOOT_CORE1_MAX_SIZE    (384*1024)
#define UBOOT_CORE2_MAX_SIZE    (384*1024)
#define FPGA_MAX_SIZE			(512*1024)
#define SPLASH_MAX_SIZE			(768*1024)
#define BOOTP_IAMGE_MAX_SIZE	(14208*1024)
#define NVRAM_MAX_SIZE			(128*1024)
//-----------------------------------------------------------------------------------------------------------------------
#define FILE_START_ADDRESS		(0)
#define BOOTP_IAMGE_IN_FILE		(FILE_START_ADDRESS	+	0											)		//0
#define UBOOT_CORE1_IN_FILE		(BOOTP_IAMGE_IN_FILE	+	BOOTP_IAMGE_MAX_SIZE)		//0xDE_0000
#define UBOOT_CORE2_IN_FILE		(UBOOT_CORE1_IN_FILE	+	UBOOT_CORE1_MAX_SIZE)		//0xE4_0000
#define MD5_SUM_IN_FILE			(UBOOT_CORE2_IN_FILE	+	UBOOT_CORE2_MAX_SIZE)
//#define FPGA_IN_FILE			(FLASH_START_ADDRESS	+	FPGA__OFFSET		)		//
//#define SPLASH_IN_FILE		(FLASH_START_ADDRESS	+	SPLASH_OFFSET		)		//
//#define NVRAM_IN_FILE			(FLASH_START_ADDRESS	+	NVRAM_OFFSET		)		//
//-----------------------------------------------------------------------------------------------------------------------








#endif /* __CONFIG_H */
