/*
 * Copyright (c) 2008 Cavium Networks
 *
 * Board specific setup info
 *
 * Scott Shu
 *
 * This file is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License, Version 2, as 
 * published by the Free Software Foundation. 
 *
 * This file is distributed in the hope that it will be useful, 
 * but AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or 
 * NONINFRINGEMENT.  See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License 
 * along with this file; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA or 
 * visit http://www.gnu.org/licenses/. 
 *
 * This file may also be available under a different license from Cavium. 
 * Contact Cavium Networks for more information
 */

#include <config.h>
#include <version.h>

#include <cnw5xxx.h>

#ifndef CONFIG_OPTIMIZED_FOR_1K
.globl ipl_secondary_cores
ipl_secondary_cores:
	mov	r12, lr

#ifndef CONFIG_OPTIMIZED_FOR_1K
	/* Have we already remapped. */
	ldr	r8, =CNW5XXX_MISC_BASE
	ldr	r6, [r8, #0x00]
	and	r6, r6, #0x01	

	tst	r6, #0x01
	beq	2f
	mov	pc, #0x10000000
2:
        /* Enable software interrupt */
	ldr	r5, =CNW5XXX_TC11MP_GIC_CPU_BASE
	mov	r6, #0x01
	str	r6, [r5, #GIC_CPU_CTRL_OFFSET]
	mov	r6, #0xF0
	str	r6, [r5, #GIC_CPU_PRIMASK_OFFSET]
#endif /* CONFIG_OPTIMIZED_FOR_1K */

1:
	/* Set WFI */
	mov	r2, #0
	mcr	p15, 0, r2, c7, c0, 4
	b	1b
	mov	lr, r12
	mov	pc, lr
#endif /* CONFIG_OPTIMIZED_FOR_1K */

/* Set up the platform, once the cpu has been initialized */
.globl lowlevel_init
lowlevel_init:
	mov	r12, lr

	/* SDRAM control register base address 0x72000000 */
	ldr	r0, =CNW5XXX_DMC_BASE

	/* DLL initialization */
	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_CTRL_OFFSET]			/* 0x400 */

	ldr	r1, =0x00001410
	str	r1, [r0, #DMC_PHY_DETECT_CFG_OFFSET]		/* 0x408 */

	ldr	r1, =0x00000006
	str	r1, [r0, #DMC_PHY_GATE_CTRL_OFFSET]		/* 0x40C */

#ifndef CONFIG_OPTIMIZED_FOR_1K
	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_0_CTRL_OFFSET]	/* 0x410 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_1_CTRL_OFFSET]	/* 0x414 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_2_CTRL_OFFSET]	/* 0x418 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_RD_DATA_SLICE_3_CTRL_OFFSET]	/* 0x41C */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_PHY_CLK_DLY_CTRL_OFFSET]		/* 0x420 */

	ldr	r1, =0x00000018
	str	r1, [r0, #DMC_PHY_DLL_LOCK_VALUE_OFFSET]	/* 0x424 */
#endif /* CONFIG_OPTIMIZED_FOR_1K */

	ldr	r1, =0x00000001
	str	r1, [r0, #DMC_PHY_DETECT_CTRL_OFFSET]		/* 0x404 */

	ldr	r1, =0x00000003
	str	r1, [r0, #DMC_PHY_DETECT_CTRL_OFFSET]		/* 0x404 */

	/* ZQ initialization */
	ldr	r1, =0x0006E550
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x0006E551
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x0006E550
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x0006E552
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x0006E550
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	ldr	r1, =0x0007E550
	str	r1, [r0, #DMC_PHY_ZQ_CTRL_OFFSET]		/* 0x428 */

	/* Enable PHY FIFO Read */
	ldr	r1, =0x00000002
	str	r1, [r0, #DMC_READ_DELAY_OFFSET]		/* 0x430 */

	/* Set CAS Latency */
	ldr	r1, =(0x06 << 1)
	str	r1, [r0, #DMC_CAS_LATENCY_OFFSET]		/* 0x014 */

	ldr	r1, =0x02
	str	r1, [r0, #DMC_T_MRD_OFFSET]			/* 0x01C */

	ldr	r1, =0x0F
	str	r1, [r0, #DMC_T_RAS_OFFSET]			/* 0x020 */

	ldr	r1, =0x14
	str	r1, [r0, #DMC_T_RC_OFFSET]			/* 0x024 */

	ldr	r1, =(0x01 << 8)|0x05
	str	r1, [r0, #DMC_T_RCD_OFFSET]			/* 0x028 */

	ldr	r1, =(0x2C << 8)|0x42
	str	r1, [r0, #DMC_T_RFC_OFFSET]			/* 0x02C */

	ldr	r1, =(0x01 << 8)|0x05
	str	r1, [r0, #DMC_T_RP_OFFSET]			/* 0x030 */

	ldr	r1, =0x04
	str	r1, [r0, #DMC_T_RRD_OFFSET]			/* 0x034 */

	ldr	r1, =0x05
	str	r1, [r0, #DMC_T_WR_OFFSET]			/* 0x038 */

	ldr	r1, =0x03
	str	r1, [r0, #DMC_T_WTR_OFFSET]			/* 0x03C */

	ldr	r1, =(0x09 << 8)|0x11
	str	r1, [r0, #DMC_T_FAW_OFFSET]			/* 0x054 */
	
	ldr	r1, =0x0A26
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */
	
#ifndef CONFIG_OPTIMIZED_FOR_1K
	ldr	r1, =0x03
	str	r1, [r0, #DMC_T_XP_OFFSET]			/* 0x040 */

	ldr	r1, =0xC8
	str	r1, [r0, #DMC_T_XSR_OFFSET]			/* 0x044 */

	ldr	r1, =0xC8
	str	r1, [r0, #DMC_T_ESR_OFFSET]			/* 0x048 */
#endif /* CONFIG_OPTIMIZED_FOR_1K */

	ldr	r1, =0x00014012
	str	r1, [r0, #DMC_MEMORY_CFG_OFFSET]		/* 0x00C*/

	ldr	r1, =0x00000618
	str	r1, [r0, #DMC_REFRESH_PRD_OFFSET]		/* 0x010 */

	ldr	r1, =0x00000034
	str	r1, [r0, #DMC_MEMORY_CFG2_OFFSET]		/* 0x04C */

	ldr	r1, =0x000000FF
	str	r1, [r0, #DMC_CHIP_0_CFG_OFFSET]		/* 0x200 */

	ldr	r1, =0x000C0000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]		/* 0x008 */

	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x000A0000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x000B0000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00090044
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00080B62
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

#ifndef CONFIG_OPTIMIZED_FOR_1K
	ldr	r1, =0x00000000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]
#endif /* CONFIG_OPTIMIZED_FOR_1K */

	ldr	r1, =0x00040000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

#ifndef CONFIG_OPTIMIZED_FOR_1K
	ldr	r1, =0x00040000
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]
#endif /* CONFIG_OPTIMIZED_FOR_1K */

	ldr	r1, =0x00080A62
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x000903C4
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00090044
	str	r1, [r0, #DMC_DIRECT_CMD_OFFSET]

	ldr	r1, =0x00000000					/* auto refresh */
	str	r1, [r0, #0x004]

	mov	lr, r12
	mov	pc, lr

