/*
 *  armboot - Startup Code for CNW5XXX CPU-core
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <cnw5xxx.h>

.globl _start
_start: 
	b	start_code

	ldr	pc, _hang
	ldr	pc, _hang
	ldr	pc, _hang
	ldr	pc, _hang
	ldr	pc, _hang
	ldr	pc, _hang
	ldr	pc, _hang

_hang:
	.word	do_hang

	.word	0x12345678
	.word	0x12345678
	.word	0x12345678
	.word	0x12345678
	.word	0x12345678
	.word	0x12345678
	.word	0x12345678	/* now 16*4=64 */

.global _end_vect
_end_vect:

	.balignl 16,0xdeadbeef
/*
 *************************************************************************
 *
 * Startup Code (called from the ARM reset exception vector)
 *
 * do important init only if we don't start from memory!
 * setup memory and board specific bits prior to relocation.
 * relocate armboot to ram
 * setup stack
 *
 *************************************************************************
 */

_TEXT_BASE:
	.word	TEXT_BASE /* address of _start in the linked image */

.globl _armboot_start
_armboot_start:
	.word _start

.globl _armboot_mem_end
_armboot_mem_end:
	.word	0x08000000

/*
 * These are defined in the board-specific linker script.
 */
.globl _bss_start
_bss_start:
	.word __bss_start

.globl _bss_end
_bss_end:
	.word _end

/*
 * the actual start code
 */

start_code:
	/*
	 * set the cpu to SVC32 mode
	 */
	mrs	r0, cpsr
	bic	r0, r0,#0x1f
	orr	r0, r0,#0xd3
	msr	cpsr, r0

#ifdef CONFIG_CNW5XXX_CHIPA
	ldr	r0, =0x76000310
	mov	r1, #0
	str	r1, [r0]

	ldr	r0, =0x73000020
	mov	r1, #1
	str	r1, [r0]
#endif

	/*
	 * flush v4 I/D caches
	 */
	mov	r0, #0
	mcr	p15, 0, r0, c7, c5, 0	/* flush v3/v4 cache */
	mcr	p15, 0, r0, c7, c6, 0	/* flush v4 TLB */

	/*
	 * disable MMU stuff and caches
	 */
	mrc	p15, 0, r0, c1, c0, 0
	bic	r0, r0, #0x00002300	@ clear bits 13, 9:8 (--V- --RS)
	bic	r0, r0, #0x00000087	@ clear bits 7, 2:0 (B--- -CAM)
	orr	r0, r0, #0x00000002	@ set bit 2 (A) Align
	orr	r0, r0, #0x00001000	@ set bit 12 (I) I-Cache
	mcr	p15, 0, r0, c1, c0, 0

	/* Read core number into r0 */
	mrc	p15, 0, r0, c0, c0, 5
	and	r0, r0, #0x0f

	cmp	r0, #0x00
	beq	ipl_primary_core

#ifdef CONFIG_OPTIMIZED_FOR_1K
	ldr	r8, =CNW5XXX_MISC_BASE
	ldr	r6, [r8, #0x00]
	and	r6, r6, #0x01

	tst	r6, #0x01
	beq	1f
	mov	pc, #0x10000000
1:
	/* Set WFI */
	mov	r2, #0
	mcr	p15, 0, r2, c7, c0, 4
	b	1b
#else
	bl	ipl_secondary_cores
#endif

ipl_primary_core:
	/* 
	 * Initialise memory 
	 * Setup memory and board specific bits prior to relocation.
	 */
	bl	lowlevel_init

relocate:
	adr	r0, _start		/* pc relative  address of label    */
	ldr	r1, =0x20000000

	ldr	r2, _armboot_start
	ldr	r3, _bss_start
	sub	r2, r3, r2		/* r2 <- size of armboot            */
	add	r2, r0, r2		/* r2 <- source end address         */

copy_loop:
	ldmia	r0!, {r3-r10}		/* copy from source address [r0]    */
	stmia	r1!, {r3-r10}		/* copy to   target address [r1]    */
	cmp	r0, r2			/* until source end addreee [r2]    */
	ble	copy_loop

	/* Re-map */
	ldr	r0, =0x76000000
	mov	r1, #1
	str	r1, [r0]

	/* Set up the stack						    */
stack_setup:
	ldr	r0, _armboot_mem_end
	sub     sp, r0, #128            /* leave 32 words for abort-stack   */

clear_bss:
	ldr	r0, _bss_start		/* find start of bss segment        */
	ldr	r1, _bss_end		/* stop here                        */
	mov 	r2, #0x00000000		/* clear                            */

#ifndef CONFIG_OPTIMIZED_FOR_1K
clbss_l:
	str	r2, [r0]		/* clear BSS location               */
	cmp	r0, r1			/* are we at the end yet            */
	add	r0, r0, #4		/* increment clear index pointer    */
	bne	clbss_l			/* keep clearing till at end        */
#endif

	ldr	pc, _start_armboot

_start_armboot: .word start_oneboot

/*
 * exception handlers
 */
	.align	5
do_hang:
	ldr	sp, _armboot_mem_end		/* use 32 words about stack */
	bl	hang				/* hang and never return */

