#define FLASHBASE 0x10000000

int nibble_to_hex (int nibble)
{
    if (nibble < 10)
        return nibble + '0';

    nibble -= 10;

    return nibble + 'A';    
}

char *uint32_to_hex (unsigned word)
{
    static char hex[9];
    int i, j;
    int nibble;

    for (i = 7, j = 0; i >= 0; i--, j++) {
        nibble = ( word >> (i*4) ) & 0xF;
        hex[j] = nibble_to_hex( nibble );
    }

    hex[8] = '\0';

    return hex;
}

void display_uint32 (unsigned word)
{
    unsigned *p;

    p = (unsigned *) uint32_to_hex( word );

    *(unsigned *)0xF0000038 = p[0];
    *(unsigned *)0xF000003c = p[1];
}

void display_string (char *s)
{
    unsigned u[2];
    int i;
    char *p;

    p = (char *)u;
    for (i = 0; i < 8; i++) {
        p[i] = s[i];
    }

    *(unsigned *)0xF0000038 = u[0];
    *(unsigned *)0xF000003c = u[1];
}

void nor_flash_write (unsigned offset, unsigned short value)
{
    *(volatile unsigned short *)(FLASHBASE + offset) = value;
}

unsigned short nor_flash_read (unsigned offset)
{
    return *(volatile unsigned short *)(FLASHBASE + offset);
}

/* The following function is an implementation of the Write Buffer Programming
   algorithm as described in section 7.7.2 of the S29GL-P MirrorBit Flash Family
   datasheet */
int nor_flash_write_buffer (unsigned short *src, unsigned dst, unsigned wordCount)
{
    unsigned sectorAddr;
    unsigned u;
    unsigned value;
    unsigned addrOfLastWord;
    unsigned short lastWord;

    if (wordCount == 0 || wordCount > 16) {
        display_string("Bad WC  ");
        return 1;
    }

    if (dst & 0x1f) {
        display_string("Bad dest");
        return 2;
    }

    sectorAddr = dst & 0xfffe0000;

    nor_flash_write( 0xAAA     , 0x00AA );
    nor_flash_write( 0x554     , 0x0055 );
    nor_flash_write( sectorAddr, 0x0025 );
    nor_flash_write( sectorAddr, wordCount-1 );

    for (u = 0; u < wordCount; u++) {
        nor_flash_write( dst + (u<<1), src[u] );
    }

    nor_flash_write( sectorAddr, 0x0029 );

    addrOfLastWord = dst + ((wordCount-1)<<1);
    lastWord = src[wordCount-1];

    u = 0;

    do {
        if (u == 1000) {
            display_string("Timeout!");
            return 3;
        }

        value = nor_flash_read( addrOfLastWord );
        u++;
    } while (value != lastWord);

    return 0;
}

void main (void)
{
    extern char image_start;
    extern char image_end;
    unsigned imageSize;
    unsigned iterations, remainder;
    void *src;
    int i;

    imageSize  = &image_end - &image_start;
    iterations = imageSize / 32;
    remainder  = imageSize % 32;
    src        = &image_start;

    for (i = 0; i < iterations; i++) {
        if (nor_flash_write_buffer( src + i*32, 0 + i*32, 16))
            while (1); /* inifinite loop */
    }

    if (remainder) {
        if (remainder & 1)
            remainder++;

        if (nor_flash_write_buffer( src + i*32, 0 + i*32, remainder>>1))
            while (1); /* infinite loop */
    }

    display_string("uboot ok");

    for (i = 0; i < 1000; i++) {
    }

    /* soft reset */
    *(unsigned *)0x77000004 = 0;
}
