.globl _start
_start:

	b	start_code

	b	undefined_instruction
	b	.	/* software interrupt */
	b	.	/* prefetch abort     */
	b	.	/* data abort         */
	b	.	/* not used           */
	b	.	/* irqs               */
	b	.	/* fast irqs          */

	.balignl 16,0xdeadbeef

_TEXT_BASE:
	.word	TEXT_BASE

.globl _bss_start
_bss_start:
	.word __bss_start

.globl _bss_end
_bss_end:
	.word _end

/************************************************************************/

undefined_instruction:
	/* init SMC for 8-char display */
	mov	r0, #0x73000000
	mov	r1, #2
	str	r1, [r0, #0x18]
	mov	r1, #0x01c00000
	str	r1, [r0, #0x10]

	mov	r0, #0xF0000000
	ldr	r1, left_message
	str	r1, [r0, #0x38]

	ldr	r1, right_message
	str	r1, [r0, #0x3c]

	b	.

left_message:	.ascii	"unde"
right_message:	.ascii	"fins"

/************************************************************************/

start_code:

	/* init SMC for 8-char display */
	mov	r0, #0x73000000
	mov	r1, #2
	str	r1, [r0, #0x18]
	mov	r1, #0x01c00000
	str	r1, [r0, #0x10]

	/* setup the stack at the 120 megabyte address */
	mov	sp, #0x07800000

clear_bss:
	ldr	r0, _bss_start		/* find start of bss segment        */
	ldr	r1, _bss_end		/* stop here                        */
	mov 	r2, #0			/* clear                            */

clbss_l:str	r2, [r0]		/* clear loop...                    */
	add	r0, r0, #4
	cmp	r0, r1
	ble	clbss_l

	bl	main	/* jump to the main C function */

	b	.
