/** @file launcher.h
 *
 *   The AQUOS Launcher
 *
 *     Copyright (c) 2005, 2006 Sharp Corporation
 *
 */

#if !defined(LAUNCHER_H)
#define LAUNCHER_H

#include <sched.h>
#include <sys/types.h>


#define USE_THREAD /**< Launcer Ȥꥢ륿ॹåɤưɤ */
#define DEBUG_PROGNAME_POSTFIX "_debug"
#define FIFOFILE "/var/launcher/control"


enum {
  MAX_NUM_OF_ARGS       = 8, 
  MAX_LENGTH_OF_COMMAND = 80,
  LAUNCHER_SCHED_POLICY = SCHED_FIFO,
  PROGRAMS_SCHED_POLICY = SCHED_FIFO,
  WATCHDOG_INTERVAL     = 10,
};


typedef enum {
  Launch_Primary,    /**< λ¨ƥ֡, stdin = console   */
  Launch_Essential,  /**< λ¨ƥ֡, stdin = /dev/null */
  Launch_Repetitive, /**< λץκƵư,   stdin = /dev/null */
  Launch_OneShot,    /**< ưƽ,           stdin = /dev/null */
  Insmod,            /**< insmod ư */
} action_t;

typedef struct
{
  const action_t action;
  int            delay;
  const char*    string;
  const char*    dbgopts;
  pid_t          pid;
  int            pipe_fd[2];
} process_table_t;


static process_table_t the_proctab[] =
{
  //{ Insmod,             0, "/sbin/insmod /root/iLink/bks4shlx.o"},
  { Launch_Primary,     0, "/root/abs.out", " -d"},

#if defined(WITH_LNX)
  // { Insmod,             0, "/sbin/insmod /root/IrSS/lr388b6-drv.o"},
  // { Insmod,             0, "/sbin/insmod /root/IrSSLnc/irsslauncher_drv.o"},
  // { Launch_Essential,  20, "/root/lnx.out" },
  // { Launch_Essential,  21, "/root/carte.out" },
#endif
};


#endif /* LAUNCHER_H */
