
EMULATOR    ?= NO

CONFIGMAKE = ../../Config.make
-include $(CONFIGMAKE)

#LD	= $(LINK)
LD	= "mips2_fp_be-ld --sysroot=$(SYSROOT)"
#AR	= $(LIBRARIAN)
MAKE	?= gmake
CP	?= cp -pf
RM	?= rm -rf
AR	?= ar
RANLIB	?= ranlib
INSTALL	?= install
MKDIR	?= mkdir

ifeq ($(EMULATOR), NO)
	CROSS_BUILD ?= 1
else
	CROSS_BUILD ?= 0
endif
#SYSROOT ?= /usr/local
DEBUG_LEVEL ?= 0

ifneq ($(DEBUG_LEVEL),0)
	DEBUG_OPT = -DIPTABLES_DEBUG
	DEBUG_OPT2 = 
else
	DEBUG_OPT =
	DEBUG_OPT2 = 
endif

#TOPDIR ?= /
KERNELDIR = $(shell cd $(TOPDIR) && pwd)/linux
PREFIX = /usr
LDPATH = -L$(SYSROOT)/lib -L$(SYSROOT)/usr/lib

TARGET_SDIR = $(SYSROOT)/sbin
TARGET_EDIR = $(SYSROOT)/etc
TARGET_LDIR = $(SYSROOT)/usr/lib
TARGET_IDIR = $(SYSROOT)/include
MODULE		= ip6tables
MODULE_OBJ	= $(MODULE).out
MODULE_DEP	= $(MODULE).dpd

SYSROOTFILE = SYSROOT
OLDSYSROOT  :=$(shell [ -f $(SYSROOTFILE) ] && cat $(SYSROOTFILE))

UCC = "$(CC)"
CFLAGS='-O2 -Wall -fno-strict-aliasing $(DEBUG_OPT) -I$(TARGET_IDIR) -DIPT_LIBDIR=$(TARGET_LDIR) -DLIBDIR=$(TARGET_LDIR)'


.PHONY: all install
all: $(MODULE_OBJ) install

$(MODULE_OBJ): $(MODULE)
	$(CP) $(MODULE) $(MODULE_OBJ)

$(MODULE):
	cd $(SYSROOT)/usr/lib;\
	sudo rm libnsl.so;\
	sudo ln -s ../../lib/libnsl.so.1 libnsl.so
	$(MAKE) -f Makefile CC=$(UCC) LD=$(LD) RANLIB=$(RANLIB) AR=$(AR) AS=$(AS) STRIP=$(STRIP) EXTCFLAGS=$(CFLAGS) EXTLDFLAGS="$(LDPATH)" $(DEBUG_OPT2) KERNEL_DIR=$(KERNELDIR) PREFIX=$(PREFIX) 
#NO_SHARED_LIBS=1

install: $(MODULE_OBJ)
	sudo $(INSTALL) -m 755 $(MODULE) $(TARGET_SDIR)
	if  [ ! -d $(SYSROOT)/usr/lib/iptables ]; then\
		sudo $(MKDIR) $(SYSROOT)/usr/lib/iptables; \
	fi
	sudo $(CP) -a extensions/libip6t_standard.so $(SYSROOT)/usr/lib/iptables/libip6t_standard.so

.PHONY: clean cleanall uninstall
clean:
	$(MAKE) -f Makefile $@
	$(RM) $(MODULE_OBJ)

cleanall: clean
	$(MAKE) -f Makefile clean
	sudo $(RM) $(TARGET_SDIR)/$(MODULE)
	sudo $(RM) $(SYSROOT)/usr/lib/iptables/libip6t_standard.so

uninstall:
	sudo $(RM) $(TARGET_SDIR)/$(MODULE)
	sudo $(RM) $(SYSROOT)/usr/lib/iptables/libip6t_standard.so

