
EMULATOR    ?= NO

CONFIGMAKE = ../../Config.make
-include $(CONFIGMAKE)

LD	= $(LINK)
AR	= $(LIBRARIAN)
MAKE	?= gmake
CP	?= cp -pf
RM	?= rm -rf

ifeq ($(EMULATOR), NO)
	CROSS_BUILD ?= 1
else
	CROSS_BUILD ?= 0
endif
SYSROOT ?= /usr/local
DEBUG_LEVEL ?= 0

ifneq ($(DEBUG_LEVEL),0)
	DEBUG_OPT = -DEBTABLES_DEBUG
	DEBUG_OPT2 = 
else
	DEBUG_OPT =
	DEBUG_OPT2 = 
endif

TARGET_SDIR = $(SYSROOT)/sbin
TARGET_EDIR = $(SYSROOT)/etc
TARGET_LDIR = $(SYSROOT)/usr/lib
MODULE		= ebtables
MODULE_OBJ	= $(MODULE).out
MODULE_DEP	= $(MODULE).dpd
ETHERTYPES	= ethertypes
EBTCLIB		= libebtc.so
EXTLIBS		= extensions/libebt_802_3.so	extensions/libebt_among.so \
	extensions/libebt_pkttype.so   extensions/libebt_arp.so \
	extensions/libebt_redirect.so  extensions/libebt_arpreply.so \
	extensions/libebt_standard.so  extensions/libebt_ip.so \
	extensions/libebt_stp.so       extensions/libebt_ulog.so \
	extensions/libebt_limit.so     extensions/libebt_vlan.so \
	extensions/libebt_log.so       extensions/libebtable_broute.so \
	extensions/libebt_mark.so      extensions/libebtable_filter.so \
	extensions/libebt_mark_m.so    extensions/libebtable_nat.so \
	extensions/libebt_nat.so

SYSROOTFILE = SYSROOT
OLDSYSROOT  :=$(shell [ -f $(SYSROOTFILE) ] && cat $(SYSROOTFILE))

UCC = "$(CC)"

.PHONY: all install
all: $(MODULE_OBJ)

$(MODULE_OBJ): $(MODULE)
	$(CP) $(MODULE) $(MODULE_OBJ)

$(MODULE):
#	$(MAKE) -f Makefile CC=$(UCC) LD=$(LD) RANLIB=$(RANLIB) AR=$(AR) AS=$(AS) STRIP=$(STRIP) CFLAGS='-O2 -Wall -fno-strict-aliasing $(DEBUG_OPT)' LDFLAGS=--static $(DEBUG_OPT2)
	$(MAKE) -f Makefile CC=$(UCC) LD=$(LD) RANLIB=$(RANLIB) AR=$(AR) AS=$(AS) STRIP=$(STRIP) CFLAGS='-O2 -Wall -fno-strict-aliasing $(DEBUG_OPT)' LDFLAGS= $(DEBUG_OPT2)

install: $(MODULE_OBJ)
	sudo $(INSTALL) -m 0755 $(MODULE) $(TARGET_SDIR)
	sudo $(INSTALL) -m 0755 $(EBTCLIB) $(TARGET_LDIR)
	sudo $(INSTALL) -m 0755 $(EXTLIBS) $(TARGET_LDIR)
	sudo $(INSTALL) -m 0644 $(ETHERTYPES) $(TARGET_EDIR)

.PHONY: clean cleanall uninstall
clean:
	$(MAKE) -f Makefile $@
	$(RM) $(MODULE_OBJ)

cleanall: clean
	$(MAKE) -f Makefile $@
	sudo $(RM) $(TARGET_SDIR)/$(MODULE_OBJ)
	sudo $(RM) $(TARGET_LDIR)/$(EBTCLIB)
	sudo $(RM) $(TARGET_LDIR)/libebt_*.so
	sudo $(RM) $(TARGET_LDIR)/libebtable_*.so

uninstall:
	sudo $(RM) $(TARGET_SDIR)/$(MODULE_OBJ)
	sudo $(RM) $(TARGET_LDIR)/$(EBTCLIB)

