/* ===================================================================== *
 * Copyright    : @(#)Copyright(C) 2009
 *              :        Panasonic Corporation.
 *              :                                    All Right reserved.
 * FileName     : eeprom.h
 * System       : EEPROM to NAND Access Driver 
 * Date         : 2009/12/09
 * Comment      : EEPROM إå
 * ===================================================================== */

#ifndef __EEPROM_H__
#define __EEPROM_H__

/* ===================================================================== *
 *  include
 * ===================================================================== */
#ifdef __KERNEL__
#include <linux/ioctl.h>
#else
#include <sys/ioctl.h>
#endif

#include <linux/config.h>

/* ===================================================================== *
 * Define
 * ===================================================================== */

#define EEPROM_MAJOR		172
#define EEPROM_NR_DEVS		3

#define EEPROM_IOC_MAGIC	0xDD
#define EEPROM_CMD_SELECT 	_IOW(EEPROM_IOC_MAGIC, 0x23, eep_select)

#define EEPROM_SELECT_MTD1	1

#if defined(CONFIG_MTD_NAND_MAP_V1)
#define EEPROM_SELECT_MTD11	11
#elif defined(CONFIG_MTD_NAND_MAP_V2)
#define EEPROM_SELECT_DEFAULT_MTD       16
#else
# error Unknown NAND MAP version !!
#endif

#define EEPROM_PATH_LEN		64
#define EEPROM_BLOCK_PATH	"/dev/mtdblock"

/* ===================================================================== *
 * ¤
 * ===================================================================== */

#ifdef __KERNEL__

#ifndef __ASSEMBLY__

typedef struct _eeprom_dev_t{
	struct semaphore sem;
	signed int minor;
} eeprom_dev_t;

typedef struct _eep_mydev_t{
	eeprom_dev_t *dev;
	struct file *myfilp;
} eep_mydev_t;

#endif /* __ASSEMBLY__ */

#endif /* __KERNEL__ */

typedef struct _eep_select{
	unsigned int select_mtd;
} eep_select;

#endif /* __EEPROM_H__ */

/* ===================================================================== *
 * Unpublished Copyright(C) 2009 by Panasonic Corporation.
 * ===================================================================== */
