/*
 * linux/arch/arm/mach-uniphier/include/mach/exsvc.h
 *
 * Copyright (C) 2011 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#ifndef	_ASM_ARCH_EXMEM_H
#define	_ASM_ARCH_EXMEM_H

#include <mach/cacheflush.h>
#ifndef __ASSEMBLY__
#include <linux/types.h>
#include <linux/ioctl.h>
#endif

#define	EXMEM_ALLOW_USER_L2COP			// If defined, allow user applications
						// to use L2 Cache operation of exmem.

struct exmem_ioctl {
	unsigned long	start;
	size_t		size;
	unsigned long	flags;
};

struct exmem_dma_alloc {
	void		**start;
	size_t		size;
};

struct exmem_dma_free {
	void		*start;
};

#define EXMEM_IOC_MAGIC			0xD0
#define EXMEM_IOC_UNC_ALLOC		_IO(EXMEM_IOC_MAGIC, 1)
#define EXMEM_IOC_UNC_FREE		_IO(EXMEM_IOC_MAGIC, 2)
#define EXMEM_IOC_VADDR_PURGE_CACHE	_IO(EXMEM_IOC_MAGIC, 3)
#define EXMEM_IOC_PADDR_PURGE_CACHE	_IO(EXMEM_IOC_MAGIC, 4)
#ifdef CONFIG_UNIPHIER_HAS_L2CA
#define EXMEM_IOC_UNCWG_ALLOC		_IO(EXMEM_IOC_MAGIC, 7)
#if defined(EXMEM_ALLOW_USER_L2COP)
#define EXMEM_IOC_VADDR_PURGE_L1C	_IO(EXMEM_IOC_MAGIC, 8)
#define EXMEM_IOC_PADDR_PURGE_L1C	_IO(EXMEM_IOC_MAGIC, 9)
#define EXMEM_IOC_VADDR_PURGE_L2C	_IO(EXMEM_IOC_MAGIC, 10)
#define EXMEM_IOC_PADDR_PURGE_L2C	_IO(EXMEM_IOC_MAGIC, 11)
#endif /* defined(EXMEM_ALLOW_USER_L2COP) */
#endif	/* CONFIG_UNIPHIER_HAS_L2CA */
#define EXMEM_IOC_DMA_ALLOC		_IO(EXMEM_IOC_MAGIC, 5)
#define EXMEM_IOC_DMA_FREE		_IO(EXMEM_IOC_MAGIC, 6)

#define EXMEM_IOC_PRGCACHE_V	PURGE_CACHE_D_PURGE
#define EXMEM_IOC_PRGCACHE_IV	PURGE_CACHE_D_PURGE_INV
#define EXMEM_IOC_PRGCACHE_SYNC	PURGE_CACHE_ID_SYNC

#define EXMEM_PURGE_DMA_V	EXMEM_IOC_PRGCACHE_V	/* obsolete */
#define EXMEM_PURGE_DMA_IV	EXMEM_IOC_PRGCACHE_IV	/* obsolete */
#define EXMEM_PURGE_MEM		EXMEM_IOC_PRGCACHE_SYNC	/* obsolete */

#define	MAP_UNCACHE_UCWG	0x60000000	/* Uncacheable write-gatherig mapping */
#define	MAP_UNCACHE_WB		0xa0000000	/* Uncacheable write-back mapping */
#define	MAP_UNCACHE		0x20000000	/* Uncacheable mapping   */
#define MAP_WRITEBACK		0x80000000	/* Write-Back mapping    */
#define MAP_WRITETHROUGH	0x40000000	/* Write-Through mapping */
#define	MAP_WB_UCWG		0xc0000000	/* Write-back write-gatherig mapping */
#define MAP_CACHEMASK		0xe0000000	/* Cache Flag Mask       */

extern void *exmem_dma_alloc_noncache(size_t size);

#endif /* _ASM_MN10300_EXMEM_H */

