/*
 *  linux/arch/arm/mach-uniphier/core.c
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *  - Derived from arch/arm/mach-realview/core.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/dma-mapping.h>
#include <linux/sysdev.h>
#include <linux/interrupt.h>
#include <linux/amba/bus.h>
#include <linux/amba/clcd.h>
#include <linux/clocksource.h>
#include <linux/clockchips.h>
#include <linux/io.h>
#include <linux/smsc911x.h>
#include <linux/ata_platform.h>
#include <linux/amba/mmci.h>

#include <asm/clkdev.h>
#include <asm/system.h>
#include <mach/hardware.h>
#include <asm/irq.h>
#include <asm/leds.h>
#include <asm/mach-types.h>
#include <asm/hardware/arm_timer.h>
#include <asm/hardware/icst307.h>

#include <asm/mach/arch.h>
#include <asm/mach/flash.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>

#include <asm/hardware/gic.h>

#include <mach/irqs.h>

#include "core.h"

/* used by entry-macro.S and platsmp.c */
void __iomem *gic_cpu_base_addr;

#ifdef CONFIG_ZONE_DMA
/*
 * Adjust the zones if there are restrictions for DMA access.
 */
void __init uniphier_adjust_zones(int node, unsigned long *size,
				  unsigned long *hole)
{
	unsigned long dma_size = SZ_256M >> PAGE_SHIFT;

	if (node || (size[0] <= dma_size))
		return;

	size[ZONE_NORMAL] = size[0] - dma_size;
	size[ZONE_DMA] = dma_size;
	hole[ZONE_NORMAL] = hole[0];
	hole[ZONE_DMA] = 0;
}
#endif

#if  defined(CONFIG_CPU_V7) && \
     defined(CONFIG_CPU_TLB_V7) && \
    !defined(CONFIG_ARM_ERRATA_430973)

#define TTB_S		(1 << 1)
#define TTB_RGN_OC_WBWA	(1 << 3)
#define TTB_RGN_OC_WB	(3 << 3)
#define TTB_NOS		(1 << 5)
#define TTB_IRGN_WBWA	((0 << 0) | (1 << 6))
#define TTB_IRGN_WB	((1 << 0) | (1 << 6))

#ifndef CONFIG_SMP
#define TTB_FLAGS	TTB_IRGN_WB|TTB_RGN_OC_WB
#else
#define TTB_FLAGS	TTB_IRGN_WBWA|TTB_S|TTB_NOS|TTB_RGN_OC_WBWA
#endif
#define TTB_FLAGS_MASK	0x7f
void switch_pt(u32 pgd_phys)
{
	unsigned long flags;
	const int zero = 0;
#ifndef CONFIG_ARM_ERRATA_720789
	int asid;
#endif

	BUG_ON(!in_interrupt());
	local_irq_save(flags);

#ifndef CONFIG_ARM_ERRATA_720789
	/* get ASID */
	asm volatile("mrc p15, 0, %0, c13, c0, 1" : "=&r" (asid));
#endif

	/* flush TLB & BTB */
	dsb();
#ifdef CONFIG_SMP
#ifdef CONFIG_ARM_ERRATA_720789
	asm volatile("mcr p15, 0, %0, c8, c3, 0" : : "r" (zero) : "cc");
#else
	asm volatile("mcr p15, 0, %0, c8, c3, 2" : : "r" (asid) : "cc");
#endif
	asm volatile("mcr p15, 0, %0, c7, c1, 6" : : "r" (zero) : "cc");
	dsb();
	isb();
#else /* CONFIG_SMP */
	asm volatile("mcr p15, 0, %0, c8, c7, 2" : : "r" (asid) : "cc");
	asm volatile("mcr p15, 0, %0, c7, c5, 6" : : "r" (zero) : "cc");
	dsb();
#endif /* CONFIG_SMP */

	/* set TTBR0 */
	asm volatile("mcr p15, 0, %0, c2, c0, 0"
		: : "r" ((pgd_phys & ~(TTB_FLAGS_MASK)) | (TTB_FLAGS)));
	isb();

	local_irq_restore(flags);
}
EXPORT_SYMBOL(switch_pt);
#else
#error Not supported yet.
#endif

#ifdef CONFIG_MN2WS_EXSVC
#include <linux/syscalls.h>
#include <mach/exsvc.h>

static DEFINE_SPINLOCK(exsvc_table_lock);

int exsvc_set_table(int exsvc_no, unsigned long func)
{
	int retval = 0;
	unsigned long flags;

	if ((exsvc_no < 0) || (exsvc_no >= NR_ex_syscalls))
		return -EINVAL;

	spin_lock_irqsave(&exsvc_table_lock, flags);
	if (func && (exsvc_table[exsvc_no] != (unsigned long)sys_ni_syscall)) {
		retval = -EBUSY;
		goto out_unlock;
	}

	if (func) {
		exsvc_table[exsvc_no] = func;
	} else {
		exsvc_table[exsvc_no] = (unsigned long)sys_ni_syscall;
	}

out_unlock:
	spin_unlock_irqrestore(&exsvc_table_lock, flags);
	return retval;
}
EXPORT_SYMBOL(exsvc_set_table);
#endif
