/* UniPhier Cache flushing
 *
 * Copyright (C) 2007 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licence
 * as published by the Free Software Foundation; either version
 * 2 of the Licence, or (at your option) any later version.
 */
#ifndef _ASM_ARCH_CACHEFLUSH_H
#define _ASM_ARCH_CACHEFLUSH_H

#define PURGE_CACHE_D_PURGE	0x00
#define PURGE_CACHE_D_PURGE_INV	0x01
#define PURGE_CACHE_ID_SYNC	0x02
#define PURGE_CACHE_D_INV	0x03
#define PURGE_CACHE_I_INV	0x04

#if defined(__KERNEL__) && !defined(__ASSEMBLY__)

extern void purge_L1cache(unsigned long start, unsigned long size, int flag);
extern void vaddr_purge_L1cache(unsigned long start, unsigned long size, int flag);

#ifdef CONFIG_OUTER_CACHE
#define	sync_l2cache()			outer_cache_sync()

#define	purge_l2cache_all()		outer_clean_all()
#define	purge_l2cache_all2()	 	outer_flush_all()
#define	invalidate_l2cache_all()	outer_inv_all()

extern void purge_L2cache(unsigned long start, unsigned long size, int flag);
#endif	/* CONFIG_OUTER_CACHE */

extern void purge_cache(unsigned long start, unsigned long size, int flag);
extern void vaddr_purge_cache(unsigned long start, unsigned long size, int flag);
#endif /* __KERNEL__ & !__ASSEMBLY__ */

#endif /* _ASM_ARCH_CACHEFLUSH_H */
