/*
 *  arch/arm/mach-uniphier/include/mach/memory.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *  - Derived from arch/arm/mach-realview/include/mach/memory.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_MEMORY_H
#define __ASM_ARCH_MEMORY_H

/*
 * Physical DRAM offset.
 */
#define PHYS_OFFSET		UL(CONFIG_KERNEL_RAM_BASE_ADDRESS)

#if !defined(__ASSEMBLY__) && defined(CONFIG_ZONE_DMA)
extern void uniphier_adjust_zones(int node, unsigned long *size,
				  unsigned long *hole);
#define arch_adjust_zones(node, size, hole) \
	uniphier_adjust_zones(node, size, hole)

#define ISA_DMA_THRESHOLD	(PHYS_OFFSET + SZ_256M - 1)
#define MAX_DMA_ADDRESS		(PAGE_OFFSET + SZ_256M)
#endif

#ifdef CONFIG_SPARSEMEM
#define MAX_PHYSMEM_BITS	32
#define SECTION_SIZE_BITS	29 /* assumed max size for each bank is 512MB */

/* bank page offsets */
#define PAGE_OFFSET1	(PAGE_OFFSET + \
	(CONFIG_KERNEL_RAM_END_ADDRESS0 - CONFIG_KERNEL_RAM_BASE_ADDRESS))

#define __phys_to_virt(phys)						\
	((phys) >= CONFIG_KERNEL_RAM_BASE_ADDRESS1 ?			\
	 (phys) - CONFIG_KERNEL_RAM_BASE_ADDRESS1 + PAGE_OFFSET1 :	\
	 (phys) - CONFIG_KERNEL_RAM_BASE_ADDRESS  + PAGE_OFFSET)

#define __virt_to_phys(virt)						\
	 ((virt) >= PAGE_OFFSET1 ?					\
	  (virt) - PAGE_OFFSET1 + CONFIG_KERNEL_RAM_BASE_ADDRESS1 :	\
	  (virt) - PAGE_OFFSET  + CONFIG_KERNEL_RAM_BASE_ADDRESS)
#endif /* CONFIG_SPARSEMEM */

#endif
