/*
 *  linux/arch/arm/mach-uniphier/include/mach/serial.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */


#ifndef __ASM_ARCH_SERIAL_H
#define __ASM_ARCH_SERIAL_H

#include <mach/irqs.h>
#include <mach/hardware.h>

#ifndef __raw_writeb
#define __raw_writeb(v,a)	(__chk_io_ptr(a), *(volatile unsigned char __force  *)(a) = (v))
#endif /* !__raw_writeb */
#ifndef __raw_writel
#define __raw_writel(v,a)	(__chk_io_ptr(a), *(volatile unsigned int __force   *)(a) = (v))
#endif /* !__raw_writel */

#ifndef __raw_readb
#define __raw_readb(a)		(__chk_io_ptr(a), *(volatile unsigned char __force  *)(a))
#endif /* !__raw_readb */
#ifndef __raw_readl
#define __raw_readl(a)		(__chk_io_ptr(a), *(volatile unsigned int __force   *)(a))
#endif /* !__raw_readl */

#ifdef CONFIG_UNIPHIER_UART

#define UNIPHIER_UART_TYPE	UPIO_UNIPHIER

#ifdef CONFIG_MACH_MN2WS0220_REF
#define UNIPHIER_UART_BASE_BAUD		( 36864000 /16 )
#endif /* CONFIG_MACH_MN2WS0220_REF */

#define UNIPHIER_UART_REG_SHIFT	0

#define UNIPHIER_UART_RX	0x00
#define UNIPHIER_UART_TX	0x00
#define UNIPHIER_UART_IER	0x04
#define UNIPHIER_UART_IIR	0x08
#define UNIPHIER_UART_FCR	0x0c
#define UNIPHIER_UART_LCR	0x10
#define UNIPHIER_UART_MCR	0x10
#define UNIPHIER_UART_LSR	0x14
#define UNIPHIER_UART_MSR	0x18
#define UNIPHIER_UART_DLL	0x24

#define UNIPHIER_UART_LCR_WLEN8	(UART_LCR_WLEN8<<8)

#ifdef CONFIG_UNIPHIER_UART4
#define IRQ_UNIPHIER_UART		IRQ_UNIPHIER_UART4
#define UNIPHIER_UART_VIRT_ADDR		UNIPHIER_UART4_BASE
#define UNIPHIER_UART_PHYS_ADDR		UNIPHIER_UART4_START
#elif defined(CONFIG_UNIPHIER_UART5)
#define IRQ_UNIPHIER_UART		IRQ_UNIPHIER_UART5
#define UNIPHIER_UART_VIRT_ADDR		UNIPHIER_UART5_BASE
#define UNIPHIER_UART_PHYS_ADDR		UNIPHIER_UART5_START
#elif defined(CONFIG_UNIPHIER_UART6)
#define IRQ_UNIPHIER_UART		IRQ_UNIPHIER_UART6
#define UNIPHIER_UART_VIRT_ADDR		UNIPHIER_UART6_BASE
#define UNIPHIER_UART_PHYS_ADDR		UNIPHIER_UART6_START
#endif /* CONFIG_UNIPHIER_UART4 */

#endif /* CONFIG_UNIPHIER_UART */

#ifdef CONFIG_SC_UART
#define UNIPHIER_SC_UART_BASE_BAUD	( 11059200 /16 )
#define UNIPHIER_SC_UART_REG_SHIFT	1

#ifndef CONFIG_UNIPHIER_UART
#define IRQ_UNIPHIER_UART		UNIPHIER_SC_UART_IRQ
#define UNIPHIER_UART_LSR		UART_LSR
#define UNIPHIER_UART_TX		UART_TX
#define UNIPHIER_UART_LCR_WLEN8		UART_LCR_WLEN8
#define UNIPHIER_UART_BASE_BAUD		UNIPHIER_SC_UART_BASE_BAUD
#define UNIPHIER_UART_VIRT_ADDR		UNIPHIER_SC_UART_BASE
#define UNIPHIER_UART_PHYS_ADDR		UNIPHIER_SC_UART_START
#define UNIPHIER_UART_REG_SHIFT		UNIPHIER_SC_UART_REG_SHIFT
#define UNIPHIER_UART_TYPE		UPIO_MEM
#endif /* !CONFIG_UNIPHIER_UART */

#endif /* CONFIG_SC_UART */

#ifndef UNIPHIER_UART_BASE_BAUD
# ifdef CONFIG_MACH_MN2WS0220_REF
#  define UNIPHIER_UART_BASE_BAUD	( 14770000 /16 )
# endif /* CONFIG_MACH_MN2WS0220_REF */
# define IRQ_UNIPHIER_UART		IRQ_UNIPHIER_UART4
# define UNIPHIER_UART_VIRT_ADDR	UNIPHIER_UART4_BASE
# define UNIPHIER_UART_PHYS_ADDR	UNIPHIER_UART4_START
#endif /* !UNIPHIER_UART_BASE_BAUD */

#define BASE_BAUD			UNIPHIER_UART_BASE_BAUD

#endif
