/* i2c-mn2ws.h: support for the I2C on mn2ws
 *
 * Copyright (C) 2010 Matsushita Electric Industrial Co., Ltd.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_UNIT_I2C_MN2WS_UNIT_H
#define _ASM_UNIT_I2C_MN2WS_UNIT_H

#define I2C_REG_BASE		(0x58400000UL)
#define I2C_OFFSET(ch)		(0x080000 * ch)

#define I2C_MN2WS_CH0_BASE (I2C_REG_BASE + I2C_OFFSET(0))	/* I2C #0 */
#define I2C_MN2WS_CH1_BASE (I2C_REG_BASE + I2C_OFFSET(1))	/* I2C #1 */
#define I2C_MN2WS_CH2_BASE (I2C_REG_BASE + I2C_OFFSET(2))	/* I2C #2 */
#define I2C_MN2WS_CH3_BASE (I2C_REG_BASE + I2C_OFFSET(3))	/* I2C #3 */
#define I2C_MN2WS_CH4_BASE (I2C_REG_BASE + I2C_OFFSET(4))	/* I2C #3 */

#define I2C_MN2WS_CH0_IRQ (73)	/* I2C #0 IRQ No. */
#define I2C_MN2WS_CH1_IRQ (74)	/* I2C #1 IRQ No. */
#define I2C_MN2WS_CH2_IRQ (75)	/* I2C #2 IRQ No. */
#define I2C_MN2WS_CH3_IRQ (76)	/* I2C #3 IRQ No. */
#define I2C_MN2WS_CH4_IRQ (77)	/* I2C #4 IRQ No. */

#define I2C_MN2WS_CH0_BUSRATE (10)
#define I2C_MN2WS_CH1_BUSRATE (10)
#define I2C_MN2WS_CH2_BUSRATE (10)
#define I2C_MN2WS_CH3_BUSRATE (10)
#define I2C_MN2WS_CH4_BUSRATE (10)

#endif /* _ASM_UNIT_I2C_MN2WS_UNIT_H */
