/* nand-mn2ws-unit.h: unit-specific mtd file
 *
 * Copyright (C) 2006-2008 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */

#ifndef _ASM_UNIT_NAND_MN2WS_UNIT_H
#define _ASM_UNIT_NAND_MN2WS_UNIT_H

#include <linux/config.h>

//#
//# Architecture dependent settings
//#

//Memory map of nand-gpbc
#define NAND_GPBC_UNIT_MEM_BASE		0xf8000000
#define NAND_GPBC_UNIT_MEM_SIZE		0x00000020
#define NAND_GPBC_UNIT_REG_BASE		0xf8100000
#define NAND_GPBC_UNIT_REG_SIZE		0x00001000

#ifdef	CONFIG_MTD_NAND_MN2WS_BB
	//the number of boot block {chip0, chip1, }
	#define NAND_GPBC_UNIT_BTBLOCKS				{1, 0, 0, 0, 0, 0, 0, 0}
	
	//the number of maintain block {chip0, chip1, }
#if defined(CONFIG_MTD_NAND_MAP_V1)
	#define NAND_GPBC_UNIT_MTBLOCKS				{128, 128, 0, 0, 0, 0, 0, 0}
#elif defined(CONFIG_MTD_NAND_MAP_V2)
//	#define NAND_GPBC_UNIT_MTBLOCKS				{400, 0, 0, 0, 0, 0, 0, 0}
	#define NAND_GPBC_UNIT_MTBLOCKS				{128, 128, 0, 0, 0, 0, 0, 0}
#else
# error Unknown NAND MAP version !!
#endif
#endif	//CONFIG_MTD_NAND_MN2WS_BB

// If maximum number of the corrected bit of each sector is larger than
// this definition, -EUCLEAN is notified to upper layer.
// If uncorrectable error occurs, -EBADMSG is notified to upper layer.
#define NAND_GPBC_CORRECTION_THRESHOLD	1


//#
//# Nand chip dependent settings
//#

// Enable banks
#ifdef CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND
#define NAND_GPBC_FLASH_BANKS		1
#else
//#define NAND_GPBC_FLASH_BANKS		2
#define NAND_GPBC_FLASH_BANKS		1
#endif	//CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND


// Manufacturer ID
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_MID		(0x98)
#else
#define NAND_GPBC_UNIT_MID		(0xec) /* samsung */
#endif

// Device ID
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_DID		(0xd3)
#else
#define NAND_GPBC_UNIT_DID		(0xda) /* 2kB, 128MiB */
#endif

// offset of ECC in oob area
#define NAND_GPBC_UNIT_OOB_ECCPOS	{50,51,52,53,54,55,56,57,58,59,60,61,62,63}

// user part in oob area {offset, size}
#ifdef CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

#ifdef CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{4,4},{64, 64}}
#else /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{2,6},{64, 64}}
#endif /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */

#else	//CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

#ifdef CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{4,4},{64, 64}}
#else
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{4,4},{36,28}}
#endif
#else /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{2,6},{64, 64}}
#endif /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */

#endif	//CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

// pulse settings
#define NAND_GPBC_UNIT_NCDWR	0x00001426
#define NAND_GPBC_UNIT_NCAAD	0x00001410
#if defined(CONFIG_USE_BOARD_OPTION_C)
#define NAND_GPBC_UNIT_NRW		0x0000000E
#else
#define NAND_GPBC_UNIT_NRW		0x00000008
#endif
#define NAND_GPBC_UNIT_NRDCP	0x00000009
#define NAND_GPBC_UNIT_NRWLP	0x00000007
#define NAND_GPBC_UNIT_NRWHP	0x00000004
#define NAND_GPBC_UNIT_NCES		0x00000003
#define NAND_GPBC_UNIT_NRR		0x00000004

#ifdef MTD_NAND_MN2WS_GPBC_ECC_BUG
	#define NAND_GPBC_UNIT_CA_BYTES		2	//Column Address Bytes
	#define NAND_GPBC_UNIT_PA_BYTES		3	//Page Address Bytes
#endif


//#
//# Partition settings
//#

/* NOTICE: Partition setting has been moved to unit-init.c */

#endif	//_ASM_UNIT_NAND_MN2WS_UNIT_H
