/*
 *  arch/arm/mach-uniphier/unit-mn2ws0220_ref/include/unit/timex.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ASM_UNIT_TIMEX_H
#define __ASM_UNIT_TIMEX_H

#ifndef __ASM_ARCH_TIMEX_H
#error only <mach/timex.h> can be included directly
#endif

#ifndef __ASSEMBLY__
#include <asm/io.h>
#endif /* __ASSEMBLY__ */

#include <mach/timer-regs.h>
#include <mach/clock.h>
#include <asm/param.h>

/*
 * jiffies counter specifications
 */

#define	TMJCBR_MAX		0xffffffff	/* 32bit */
#define	TMJCIRQ			TM5IRQ

#ifndef __ASSEMBLY__

#define MN_SRC_IOBCLK	MN_IOBCLK

#ifndef HZ
# error HZ undeclared.
#endif /* !HZ */

#define MN_JCCLK		(MN_SRC_IOBCLK)
#define MN_TSCCLK		(MN_SRC_IOBCLK)

#define MN_JC_PER_HZ		((MN_JCCLK + HZ / 2) / HZ)
#define MN_TSC_PER_HZ		((MN_TSCCLK + HZ / 2) / HZ)

/* Check bit width of MTM interval value that sets base register */
#if (MN_JC_PER_HZ - 1) > TMJCBR_MAX
# error tick timer interval value is overflow.
#endif

static inline void stop_jiffies_counter(void)
{
	u16 tmp;
	outw(0, TM4MD);
	outw(0, TM5MD);
	tmp = inw(TM4MD);
	tmp = inw(TM5MD);
}

static inline void reload_jiffies_counter(u32 cnt)
{
	u32 tmp;

	outl(cnt, TM45BR);
	tmp = inl(TM45BR);

	outw(TM4MD_INIT_COUNTER, TM4MD);
	tmp = inw(TM4MD);

	outw(TM5MD_SRC_TM4CASCADE | TM5MD_INIT_COUNTER, TM5MD);
	outw(TM5MD_SRC_TM4CASCADE | TM5MD_COUNT_ENABLE, TM5MD);
	tmp = inw(TM5MD);

	outw(TM4MD_COUNT_ENABLE, TM4MD);
	tmp = inw(TM4MD);
}

#endif /* !__ASSEMBLY__ */

#endif /* __ASM_UNIT_TIMEX_H */
