/*
 *  arch/arm/mach-uniphier/unit-mn2ws0220_ref/unit-init.c
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/sysdev.h>
#include <linux/io.h>
#include <linux/irq.h>
#include <linux/clockchips.h>
#include <linux/interrupt.h>

#include <asm/setup.h>
#include <asm/irq.h>
#include <asm/leds.h>
#include <asm/mach-types.h>
#include <asm/smp_twd.h>
#include <asm/localtimer.h>
#include <asm/hardware/gic.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/time.h>

#include <mach/hardware.h>
#include <mach/irqs.h>
#include <mach/serial.h>
#include <mach/timer-regs.h>

#include <linux/config.h>

struct machine_desc;

extern void __iomem *gic_cpu_base_addr;

#define head_cmdline ((char *)__phys_to_virt(PHYS_OFFSET+0x00003000))

static struct map_desc uniphier_io_desc[] __initdata = {
	{
		.virtual	= UNIPHIER_PRIVATE_IO_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_PRIVATE_IO_START),
		.length		= UNIPHIER_PRIVATE_IO_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= UNIPHIER_SYS_FLAGSSET_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_SYS_FLAGSSET_START),
		.length		= UNIPHIER_SYS_FLAGSSET_SIZE,
		.type		= MT_UNCACHED,
	},
	{
		.virtual	= UNIPHIER_AIDET_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_AIDET_START),
		.length		= UNIPHIER_AIDET_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= UNIPHIER_SSC_BASE0,
		.pfn		= __phys_to_pfn(UNIPHIER_SSC_START0),
		.length		= UNIPHIER_SSC_SIZE0,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= UNIPHIER_SSC_BASE1,
		.pfn		= __phys_to_pfn(UNIPHIER_SSC_START1),
		.length		= UNIPHIER_SSC_SIZE1,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= UNIPHIER_SSC_BASE2,
		.pfn		= __phys_to_pfn(UNIPHIER_SSC_START2),
		.length		= UNIPHIER_SSC_SIZE2,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= UNIPHIER_TIMER_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_TIMER_START),
		.length		= UNIPHIER_TIMER_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= UNIPHIER_UART_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_UART_START),
		.length		= UNIPHIER_UART_SIZE,
		.type		= MT_DEVICE,
	},
#ifdef CONFIG_SC_UART
	{
		.virtual	= UNIPHIER_SC_UART_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_SC_UART_START),
		.length		= UNIPHIER_SC_UART_SIZE,
		.type		= MT_DEVICE,
	},
#endif	/* CONFIG_SC_UART */
	{
		.virtual	= UNIPHIER_KERNEL_UNCACHE_BASE,
		.pfn		= __phys_to_pfn(UNIPHIER_KERNEL_UNCACHE_START),
		.length		= UNIPHIER_KERNEL_UNCACHE_SIZE,
		.type		= MT_UNCACHED,
	},
	{
		.virtual	= UNIPHIER_KERNEL_UCWG_BASE,
		.pfn		= 0,
		.length		= UNIPHIER_KERNEL_UCWG_SIZE,
		.type		= MT_MEMORY_BUFFERABLE,
	},
};

extern unsigned long ucwg_dummy[];

static void __init uniphier_map_io(void)
{
	uniphier_io_desc[ARRAY_SIZE(uniphier_io_desc)-1].pfn
		= __phys_to_pfn(__pa((unsigned long)&ucwg_dummy)
				 & ~(UNIPHIER_KERNEL_UCWG_SIZE-1));
	iotable_init(uniphier_io_desc, ARRAY_SIZE(uniphier_io_desc));
}

static unsigned int irq_trigger_type[] __initdata =
{
IRQ_TYPE_EDGE_FALLING,	/* 32 */
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,	/* 40 */
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,	/* 50 */
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,	/* 60 */
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,		/* 70 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_EDGE_RISING,	/* 80 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,	/* 90 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,	/* 100 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,	/* 110 */
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,	/* 120 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,		/* 130 */
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,	/* 140 */
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,		/* 150 */
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,	/* 160 */
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,		/* 170 */
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,	/* 180 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,		/* 190 */
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,	/* 200 */
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,		/* 210 */
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_EDGE_RISING,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,	/* 220 */
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,	/* 230 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_LEVEL_HIGH,	/* 240 */
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_HIGH,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_LEVEL_LOW,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,		/* 250 */
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
IRQ_TYPE_NONE,
};

static void __init gic_init_irq(void)
{
	int i;
	gic_cpu_base_addr = (void __iomem *)UNIPHIER_GIC_CPU_BASE;
	gic_dist_init(0, (void __iomem *)UNIPHIER_GIC_DIST_BASE, 29);
	for (i = 0;i < sizeof(irq_trigger_type)/sizeof(unsigned int);i++) {
		unsigned int type = irq_trigger_type[i];
		if (type == IRQ_TYPE_EDGE_RISING || type == IRQ_TYPE_EDGE_FALLING) {
			set_irq_type(IRQ_GIC_START + i, type);
		}
	}
	
	/* set IRQF_VALID/IRQF_NOAUTOEN for external irq */
	for(i=80;i<95;i++)
	{
		if(i!=93) /* 93 is not external(for exiv) */
		{
			set_irq_flags(i, (IRQF_VALID | IRQF_NOAUTOEN));
		}
	}
	
	gic_cpu_init(0, (void __iomem *)UNIPHIER_GIC_CPU_BASE);
}

#ifdef CONFIG_HAVE_ARM_TWD
extern unsigned long twd_timer_rate;
#endif /* CONFIG_HAVE_ARM_TWD */

extern void __init globaltimer_clocksource_init(void);
extern void __init init_clockevents(void);

static void __init uniphier_timer_init(void)
{
	u8 t8;

#ifdef CONFIG_HAVE_ARM_TWD
	twd_base = (void __iomem *)UNIPHIER_TWD_BASE;
#endif /* CONFIG_HAVE_ARM_TWD */
	globaltimer_clocksource_init();

	t8 = inb(TMPSCNT);
	t8 |= TMPSCNT_ENABLE;
	outb(t8, TMPSCNT);

	init_clockevents();
}

static struct sys_timer uniphier_timer = {
	.init		= uniphier_timer_init,
};

extern unsigned int __atags_pointer;

static void __init uniphier_fixup(struct machine_desc *mdesc, struct tag *tags,
			       char **cmdline, struct meminfo *meminfo)
{
#if !defined(CONFIG_XIP_KERNEL)
	if (__atags_pointer) {
		if (tags->hdr.tag == ATAG_CORE)
			return;
	}
	if ( head_cmdline[ 0] != '\0') {
		strncpy( *cmdline, head_cmdline, COMMAND_LINE_SIZE -1);
		tags->hdr.tag = ATAG_NONE;
	}
#endif
}

static void __init uniphier_init(void)
{
#ifdef CONFIG_LEDS
	leds_event = uniphier_leds_event;
#endif
}

MACHINE_START(MN2WS0220_REF, "Panasonic MN2WS0220")
	/* Maintainer: Panasonic */
	.phys_io	= UNIPHIER_UART_PHYS_ADDR,
	.io_pg_offst	= (UNIPHIER_UART_VIRT_ADDR >> 18) & 0xfffc,
	.fixup		= uniphier_fixup,
	.map_io		= uniphier_map_io,
	.init_irq	= gic_init_irq,
	.timer		= &uniphier_timer,
	.init_machine	= uniphier_init,
MACHINE_END

/*
 * I2C
 */
#if defined(CONFIG_I2C_MN2WS) || defined(CONFIG_I2C_MN2WS_MODULE)
	#include <linux/i2c/i2c-mn2ws.h>
	#include <unit/i2c-mn2ws-unit.h>
	
	// I2C channel 0
	static struct i2c_mn2ws_pdata i2c_mn2ws_pdata_0 = {
		.base = I2C_MN2WS_CH0_BASE,
		.irq  = I2C_MN2WS_CH0_IRQ,
		.rate = I2C_MN2WS_CH0_BUSRATE,
	};
	
	static struct platform_device i2c_mn2ws_pdev_0 = {
		.name = "i2c-mn2ws",
		.id   = 0,
		.dev= {
			.platform_data = &i2c_mn2ws_pdata_0,
		}
	};
	
	// I2C channel 1
	static struct i2c_mn2ws_pdata i2c_mn2ws_pdata_1 = {
		.base = I2C_MN2WS_CH1_BASE,
		.irq  = I2C_MN2WS_CH1_IRQ,
		.rate = I2C_MN2WS_CH1_BUSRATE,
	};
	
	static struct platform_device i2c_mn2ws_pdev_1 = {
		.name = "i2c-mn2ws",
		.id   = 1,
		.dev= {
			.platform_data = &i2c_mn2ws_pdata_1,
		}
	};
	
	// I2C channel 2
	static struct i2c_mn2ws_pdata i2c_mn2ws_pdata_2 = {
		.base = I2C_MN2WS_CH2_BASE,
		.irq  = I2C_MN2WS_CH2_IRQ,
		.rate = I2C_MN2WS_CH2_BUSRATE,
	};
	
	static struct platform_device i2c_mn2ws_pdev_2 = {
		.name = "i2c-mn2ws",
		.id   = 2,
		.dev= {
			.platform_data = &i2c_mn2ws_pdata_2,
		}
	};
	
	// I2C channel 3
	static struct i2c_mn2ws_pdata i2c_mn2ws_pdata_3 = {
		.base = I2C_MN2WS_CH3_BASE,
		.irq  = I2C_MN2WS_CH3_IRQ,
		.rate = I2C_MN2WS_CH3_BUSRATE,
	};
	
	static struct platform_device i2c_mn2ws_pdev_3 = {
		.name = "i2c-mn2ws",
		.id   = 3,
		.dev= {
			.platform_data = &i2c_mn2ws_pdata_3,
		}
	};
	
	// I2C channel 4
	static struct i2c_mn2ws_pdata i2c_mn2ws_pdata_4 = {
		.base = I2C_MN2WS_CH4_BASE,
		.irq  = I2C_MN2WS_CH4_IRQ,
		.rate = I2C_MN2WS_CH4_BUSRATE,
	};
	
	static struct platform_device i2c_mn2ws_pdev_4 = {
		.name = "i2c-mn2ws",
		.id   = 4,
		.dev= {
			.platform_data = &i2c_mn2ws_pdata_4,
		}
	};
#endif	//defined(CONFIG_I2C_MN2WS) || defined(CONFIG_I2C_MN2WS_MODULE)

#if defined(CONFIG_MTD_NAND_MN2WS_GPBC) || defined(CONFIG_MTD_NAND_MN2WS_GPBC_MODULE)
	#include <linux/mtd/nand.h>
	#include <linux/mtd/partitions.h>
	#include <unit/nand-gpbc-unit.h>
	
	#ifndef	CONFIG_MTD_CMDLINE_PARTS
		#include "mach/nand_partition.h"
	#else	//CONFIG_MTD_CMDLINE_PARTS
		//NAND Flash partition types for parse
		const char *nand_gpbc_part_probes[] = { "cmdlinepart", NULL };
	#endif	//CONFIG_MTD_CMDLINE_PARTS
	
	struct platform_nand_data nand_gpbc_platdata = {
		.chip	= {
			.nr_chips	= 1,
			.chip_offset	= 0,
			#ifndef	CONFIG_MTD_CMDLINE_PARTS
				.nr_partitions	= ARRAY_SIZE(nand_gpbc_partition_info),
				.partitions	= nand_gpbc_partition_info,
			#else	//CONFIG_MTD_CMDLINE_PARTS
				.part_probe_types = nand_gpbc_part_probes,
			#endif	//CONFIG_MTD_CMDLINE_PARTS
		},
	};
	static struct platform_device nand_gpbc_device = {
		.name	= "nand-gpbc",
		.id	= -1,
		.dev	= {
			.coherent_dma_mask = 0xffffffff,
			.platform_data = &nand_gpbc_platdata,
		}
	};
#ifdef PANA_SAMPLE_BOARD
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
	struct platform_nand_data nand_gpbc_platdata1 = {
		.chip	= {
			.nr_chips	= 1,
			.chip_offset	= 0,
			#ifndef	CONFIG_MTD_CMDLINE_PARTS
				.nr_partitions	= ARRAY_SIZE(nand_gpbc_partition_info1),
				.partitions	= nand_gpbc_partition_info1,
			#else	//CONFIG_MTD_CMDLINE_PARTS
				.part_probe_types = nand_gpbc_part_probes,
			#endif	//CONFIG_MTD_CMDLINE_PARTS
		},
	};
	static struct platform_device nand_gpbc_device1 = {
		.name	= "nand-gpbc",
		.id	= -1,
		.dev	= {
			.coherent_dma_mask = 0xffffffff,
			.platform_data = &nand_gpbc_platdata1,
		}
	};
#endif //defined(CONFIG_NANDBOOT_BANKCHOICE)
#endif	// PANA_SAMPLE_BOARD
#endif	//defined(CONFIG_MTD_NAND_MN2WS_GPBC) || defined(CONFIG_MTD_NAND_MN2WS_GPBC_MODULE)

static struct platform_device* unit_late_devices[] __initdata = 
{
	#if defined(CONFIG_I2C_MN2WS) || defined(CONFIG_I2C_MN2WS_MODULE)
		&i2c_mn2ws_pdev_0,
		&i2c_mn2ws_pdev_1,
		&i2c_mn2ws_pdev_2,
		&i2c_mn2ws_pdev_3,
		&i2c_mn2ws_pdev_4,
	#endif	//defined(CONFIG_I2C_MN2WS) || defined(CONFIG_I2C_MN2WS_MODULE)
	#if defined(CONFIG_MTD_NAND_MN2WS_GPBC) || defined(CONFIG_MTD_NAND_MN2WS_GPBC_MODULE)
		&nand_gpbc_device,
	#endif	//defined(CONFIG_MTD_NAND_MN2WS_GPBC) || defined(CONFIG_MTD_NAND_MN2WS_GPBC_MODULE)
};

#ifdef PANA_SAMPLE_BOARD
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
static struct platform_device* unit_late_devices1[] __initdata = 
{
	#if defined(CONFIG_I2C_MN2WS) || defined(CONFIG_I2C_MN2WS_MODULE)
		&i2c_mn2ws_pdev_0,
		&i2c_mn2ws_pdev_1,
		&i2c_mn2ws_pdev_2,
		&i2c_mn2ws_pdev_3,
		&i2c_mn2ws_pdev_4,
	#endif	//defined(CONFIG_I2C_MN2WS) || defined(CONFIG_I2C_MN2WS_MODULE)
	#if defined(CONFIG_MTD_NAND_MN2WS_GPBC) || defined(CONFIG_MTD_NAND_MN2WS_GPBC_MODULE)
		&nand_gpbc_device1,
	#endif	//defined(CONFIG_MTD_NAND_MN2WS_GPBC) || defined(CONFIG_MTD_NAND_MN2WS_GPBC_MODULE)
};
#endif	//defined(CONFIG_NANDBOOT_BANKCHOICE)

#if defined(CONFIG_NANDBOOT_BANKCHOICE)
static void bootbank_halt(void)
{
	printk(KERN_ERR "\n******************************\n");
	printk(KERN_ERR " Assert! Bad BootFlag Data! \n");
	printk(KERN_ERR " BootFlag area on DDR is broken!    \n");
	printk(KERN_ERR "********************************\n");

	while(1);
}

static int bootbank_get(void)
{
	#include <scc/ucd_memmap.h>
	#define FWBANK_BOOTFLAG_ADDR    (0x80000000 + DDR_CONFIG_OFFSET)
	#define FWBANK_BOOTFLAG_SIZE    (sizeof(int) * 3)
	#define BOOTFLAG_MAGIC          (0x746F6F42)    /* "Boot" */
	void *vaddr;
	int *addr;
	int magicnumber, bootbank;

	/* remap Boot Flag on DDR */
	vaddr = ioremap(FWBANK_BOOTFLAG_ADDR, FWBANK_BOOTFLAG_SIZE);

	/* get value from Boot Flag on DDR */
	addr = (int *)vaddr;
	magicnumber = *addr++;
	bootbank = *addr;

	/* unmap */
	iounmap(vaddr);

	/* check bootflag */
	if ((magicnumber != BOOTFLAG_MAGIC) || ((bootbank != 0) && (bootbank != 1))){
		/* invalid value */
		bootbank_halt();
	}	

	return bootbank;
}
#endif	//defined(CONFIG_NANDBOOT_BANKCHOICE)
#endif	// PANA_SAMPLE_BOARD

static int __init unit_late_init(void)
{
#ifdef PANA_SAMPLE_BOARD
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
	int bootbank;

	bootbank = bootbank_get();

	if (bootbank == 0) {
		/* boot bank0 */
		platform_add_devices( unit_late_devices, ARRAY_SIZE(unit_late_devices));
	}
	else {
		/* boot bank1 */
		platform_add_devices( unit_late_devices1, ARRAY_SIZE(unit_late_devices1));
	}
#else	//defined(CONFIG_NANDBOOT_BANKCHOICE)
	platform_add_devices( unit_late_devices, ARRAY_SIZE(unit_late_devices));
#endif	//defined(CONFIG_NANDBOOT_BANKCHOICE)

#else	// not PANA_SAMPLE_BOARD
	platform_add_devices( unit_late_devices, ARRAY_SIZE(unit_late_devices));
#endif	// not PANA_SAMPLE_BOARD
	return 0;
}

late_initcall( unit_late_init );
