/*
 * extended memory interface for MN10300.
 */

#ifndef _EXMEMDRV_H
#define _EXMEMDRV_H

extern void mn2ws_prepare_split_vma(struct vm_area_struct * vma, unsigned long addr);
extern void mn2ws_prepare_move_vma(struct vm_area_struct * vma, unsigned long addr, unsigned long old_len, unsigned long new_addr);

#ifdef CONFIG_ARM

#ifdef CONFIG_UNIPHIER_HAS_L2CA
#define	EXMEM_PAGE_UCWG		(L_PTE_MT_BUFFERABLE)
#endif	/* CONFIG_UNIPHIER_HAS_L2CA */
#define	EXMEM_PAGE_UCUC		(L_PTE_MT_UNCACHED)
#define	EXMEM_PAGE_WTWT		(L_PTE_MT_UNCACHED)
#define	EXMEM_PAGE_WBWB		(L_PTE_MT_WRITEALLOC)
#define	EXMEM_PAGE_CACHE_MASK	(L_PTE_MT_MASK)

#define IS_ADDR_UNCACHED(addr)	(0)

#else /* CONFIG_ARM */

#ifdef CONFIG_PROC_HAS_MN10300_L2CA
#define	EXMEM_PAGE_UCWG		(_PAGE_CACHE_WT)
#endif	/* CONFIG_PROC_HAS_MN10300_L2CA */
#define	EXMEM_PAGE_UCUC		(0)
#define	EXMEM_PAGE_WTWT		(_PAGE_CACHE | _PAGE_CACHE_WT)
#define	EXMEM_PAGE_WBWB		(_PAGE_CACHE)
#define	EXMEM_PAGE_CACHE_MASK	(_PAGE_CACHE | _PAGE_CACHE_WT)
#endif /* CONFIG_ARM */

static inline unsigned long
exmem_pte_cache_attr(unsigned long pte, unsigned long cache_attr)
{
	return (pte & ~EXMEM_PAGE_CACHE_MASK) | cache_attr;
}

extern const struct file_operations exmem_fops;

#endif	/* _EXMEMDRV_H */
