/*** CONFIDENTIAL ***/
/* Copyright (C) 2011, Panasonic Corporation */


#include <linux/types.h>

#include "fifo.h"

void
fusion_fifo_put (FusionFifo *fifo, FusionLink *link)
{
     link->prev = fifo->last;
     link->next = NULL;

     if (fifo->last)
          fifo->last->next = link;
     else
          fifo->first = link;

     fifo->last = link;

     fifo->count++;
}

FusionLink *
fusion_fifo_get (FusionFifo *fifo)
{
     FusionLink *first = fifo->first;

     if (!first)
          return NULL;

     fifo->first = first->next;

     if (fifo->last == first)
          fifo->last = NULL;
     else
          fifo->first->prev = NULL;

     fifo->count--;

     return first;
}
