/*** CONFIDENTIAL ***/
/* Copyright (C) 2011, Panasonic Corporation */

 
#ifndef __FUSION__SHMPOOL_H__
#define __FUSION__SHMPOOL_H__

#include "fusiondev.h"
#include "types.h"

#ifdef __x86_64__
#define FUSION_SHM_BASE    0x523000010000     
#define FUSION_SHM_SIZE    0x000FFFFEF000     
#else

#ifdef __mips__
#define FUSION_SHM_BASE    0x50010000     
#else
#define FUSION_SHM_BASE    0x20010000     
#endif

#define FUSION_SHM_SIZE    0x1FFEF000     
#endif

int  fusion_shmpool_init   (FusionDev *dev);
void fusion_shmpool_deinit (FusionDev *dev);

int fusion_shmpool_new      (FusionDev             *dev,
                             FusionSHMPoolNew      *pool);

int fusion_shmpool_attach   (FusionDev             *dev,
                             FusionSHMPoolAttach   *attach,
                             FusionID               fusion_id);

int fusion_shmpool_detach   (FusionDev             *dev,
                             int                    id,
                             FusionID               fusion_id);

int fusion_shmpool_dispatch (FusionDev             *dev,
                             FusionSHMPoolDispatch *dispatch,
                             Fusionee              *fusionee );

int fusion_shmpool_destroy  (FusionDev             *dev,
                             int                    id);

void fusion_shmpool_detach_all (FusionDev *dev,
                                FusionID   fusion_id);

int  fusion_shmpool_fork_all   (FusionDev *dev,
                                FusionID   fusion_id,
                                FusionID   from_id);

#endif

