/*** CONFIDENTIAL ***/
/* Copyright (C) 2011, Panasonic Corporation */


#ifndef __FUSION__SKIRMISH_H__
#define __FUSION__SKIRMISH_H__

#include "fusiondev.h"
#include "types.h"

int  fusion_skirmish_init   (FusionDev *dev);
void fusion_skirmish_deinit (FusionDev *dev);

int fusion_skirmish_new     (FusionDev *dev,
                             int       *id);

int fusion_skirmish_prevail (FusionDev *dev,
                             int        id,
                             int        fusion_id);

int fusion_skirmish_swoop   (FusionDev *dev,
                             int        id,
                             int        fusion_id);

int fusion_skirmish_lock_count (FusionDev *dev,
                                int     id,
                                int     fusion_id,
                                int    *ret_lock_count);

int fusion_skirmish_dismiss (FusionDev *dev,
                             int        id,
                             int        fusion_id);

int fusion_skirmish_destroy (FusionDev *dev,
                             int        id);

int fusion_skirmish_wait_   (FusionDev          *dev,
                             FusionSkirmishWait *wait,
                             FusionID            fusion_id);

int fusion_skirmish_notify_ (FusionDev *dev,
                             int        id,
                             FusionID   fusion_id);

void fusion_skirmish_dismiss_all (FusionDev *dev,
                                  int        fusion_id);

void fusion_skirmish_dismiss_all_from_pid (FusionDev *dev,
                                           int        pid);

void fusion_skirmish_transfer_all (FusionDev *dev,
                                   FusionID   to,
                                   FusionID   from,
                                   int        from_pid);

void fusion_skirmish_reclaim_all (FusionDev *dev,
                                  int        from_pid);

#endif
