/* $Id: nand-gpbc-reg.h,v 1.2 2012/02/10 01:19:19 txbsd Exp $
 * nand-gpbc-reg.h: NAND flash I/F dependent header
 *
 * Copyright (C) 2010-2011 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _NAND_GPBC_REG_H_
#define _NAND_GPBC_REG_H_

//DEVICE_RESET
#define	NAND_GPBC_NDRST				0x0
#define		NAND_GPBC_NDRST__B0RST			0x0001
#define		NAND_GPBC_NDRST__B1RST			0x0002

//TRANSFER_SPARE
#define	NAND_GPBC_NTS				0x10
#define		NAND_GPBC_NTS__TS				0x0001

//LOAD_WAIT_COUNT
#define	NAND_GPBC_NLWC				0x20
#define		NAND_GPBC_NLWC__LWC			0xffff

//PROGRAM_WAIT_COUNT
#define	NAND_GPBC_NPWC				0x30
#define		NAND_GPBC_NPWC__PWC			0xffff

//ERASE_WAIT_COUNT
#define	NAND_GPBC_NEWC				0x40
#define		NAND_GPBC_NEWC__EWC			0xffff

//INTERRUPT_MONITOR_CYCLE_COUNT
#define	NAND_GPBC_NIMCC				0x50
#define		NAND_GPBC_NIMCC__IMCC			0xffff

//READY_BUSY_ENABLE
#define	NAND_GPBC_NRBE				0x60
#define		NAND_GPBC_NRBE__B0RBEN			0x0001
#define		NAND_GPBC_NRBE__B1RBEN			0x0002
#define		NAND_GPBC_NRBE__MASK			0x0003

//COPYBACK_DISABLE
#define	NAND_GPBC_NCBDIS			0x90
#define		NAND_GPBC_NCBDIS__CBDIS			0x0001

//CACHE_WRITE_ENABLE
#define	NAND_GPBC_NCWE				0xa0
#define		NAND_GPBC_NCWE__CWEN			0x0001

//CACHE_READ_ENABLE
#define	NAND_GPBC_NCRE				0xb0
#define		NAND_GPBC_NCRE__CREN			0x0001

//PREFETCH_MODE
#define	NAND_GPBC_NPFM				0xc0
#define		NAND_GPBC_NPFM__PFEN				0x0001
#define		NAND_GPBC_NPFM__PFLENGTH			0xfff0

//CHIP_ENABLE_DONT_CARE
#define	NAND_GPBC_NCEDC				0xd0
#define		NAND_GPBC_NCEDC__CEDCEN				0x01

//ECC_ENABLE
#define	NAND_GPBC_NECCE				0xe0
#define		NAND_GPBC_NECCE__ECCEN				0x0001

//GLOBAL_INTERRUPT_ENABLE
#define	NAND_GPBC_NGINTE			0xf0
#define		NAND_GPBC_NGINTE__INTEN				0x0001
#define		NAND_GPBC_NGINTE__WDTDIS			0x0010
#define		NAND_GPBC_NGINTE__ERRRPTDIS			0x0100

//COMMAND_TO_DATA_AND_WRITE_TO_READ_PARAMETER
#define	NAND_GPBC_NCDWR				0x100
#define		NAND_GPBC_NCDWR__WE2RE				0x003f
#define		NAND_GPBC_NCDWR__TWHR2				0x3f00

//COMMAND_TO_ADDRESS_AND_ADDRESS_TO_DATA
#define	NAND_GPBC_NCAAD				0x110
#define		ADDR_2_DATA__ADDR2DATA				0x003f
#define		ADDR_2_DATA__TCWAW					0x3f00

//READ_TO_WRITE_PARAMETER
#define	NAND_GPBC_NRW				0x120
#define		NAND_GPBC_NRW__RE2WE				0x003f

//READ_DATA_CAPTURE_PARAMETER
#define	NAND_GPBC_NRDCP				0x130
#define		NAND_GPBC_NRDCP__RDCP				0x000f

//PAGES_PER_BLOCK
#define	NAND_GPBC_NBPNUM			0x150
#define		NAND_GPBC_NBPNUM__BPNUM				0xffff

//DEVICE_MAIN_AREA_SIZE
#define	NAND_GPBC_NMASZ				0x170
#define		NAND_GPBC_NMASZ__MASZ				0xffff

//DEVICE_SPARE_AREA_SIZE
#define	NAND_GPBC_NSASZ				0x180
#define		NAND_GPBC_NSASZ__SASZ				0xffff

//ECC_CORRECTION
#define	NAND_GPBC_NECCC				0x1b0
#define		NAND_GPBC_NECCC__ECCC				0x00ff

//READ_MODE
#define	NAND_GPBC_NRMOD				0x1c0
#define		NAND_GPBC_NRMOD__RMODE				0x000f

//WRITE_MODE
#define	NAND_GPBC_NWMOD				0x1d0
#define		NAND_GPBC_NWMOD__WMODE				0x000f

//COPY_BACK_MODE
#define NAND_GPBC_NCPBMOD			0x1e0
#define		NAND_GPBC_NCPBMOD__CPBMODE			0x1e0

//RW_ENABLE_LOW_PULSE
#define	NAND_GPBC_NRWLP				0x1f0
#define		NAND_GPBC_NRWLP__RWLP				0x001f

//RW_ENABLE_HIGH_PULSE
#define	NAND_GPBC_NRWHP				0x200
#define		NAND_GPBC_NRWHP__RWHP				0x001f

//CS_SETUP_PARAMETER
#define	NAND_GPBC_NCES				0x220
#define		NAND_GPBC_NCES__CES					0x001f

//SPARE_AREA_SKIP_BYTES
#define	NAND_GPBC_NSASK				0x230
#define		NAND_GPBC_NSASK__SASK				0x003f

//SPARE_AREA_MARKER
#define	NAND_GPBC_NSAMK				0x240
#define		NAND_GPBC_NSAMK__SAMK				0xffff

//WRITE_PROTECT_TERMINAL_CONTROL
#define	NAND_GPBC_NWPD				0x280
#define		NAND_GPBC_NWPD__WPD					0x0001

//READ_TO_READ_PARAMETER
#define	NAND_GPBC_NRR				0x290
#define		NAND_GPBC_NRR__RE2RE				0x003f

//MANUFACTURER_ID
#define	NAND_GPBC_NMID				0x300
#define		NAND_GPBC_NMID__MID					0x00ff

//DEVICE_ID
#define	NAND_GPBC_NDID				0x310
#define		NAND_GPBC_NDID__DID					0x00ff

//DEVICE_PARAMETER_0
#define	NAND_GPBC_NDP0				0x320
#define		NAND_GPBC_NDP0__DP0					0x00ff

//DEVICE_PARAMETER_1
#define	NAND_GPBC_NDP1				0x330
#define		NAND_GPBC_NDP1__DP1			0x00ff

//DEVICE_PARAMETER_2
#define	NAND_GPBC_NDP2				0x340
#define		NAND_GPBC_NDP2__DP2			0x00ff

//ONFI_DEVICE_FEATURES
#define	NAND_GPBC_NONDF				0x380
#define		NAND_GPBC_NONDF__ONDF			0xffff

//ONFI_DEVICE_NO_OF_LUNS
#define NAND_GPBC_NONDNOL			0x3c0
#define		NAND_GPBC_NONDNOL__ONFI			0x0100

//TRANSFER_MODE
#define	NAND_GPBC_NTMOD				0x400
#define		NAND_GPBC_NTMOD__B0TM			0x0003
#define		NAND_GPBC_NTMOD__B1TM			0x000c

//INTERRUPT_STATUS_BANK0
#define	NAND_GPBC_NIST0			0x410
#define		NAND_GPBC_NI__ECCUNCOR				0x0001
#define		NAND_GPBC_NI__DMA_CMD_COMP			0x0004
#define		NAND_GPBC_NI__TOUT					0x0008
#define		NAND_GPBC_NI__PROFAIL				0x0010
#define		NAND_GPBC_NI__ERAFAIL				0x0020
#define		NAND_GPBC_NI__LDCMP					0x0040
#define		NAND_GPBC_NI__PROCMP				0x0080
#define		NAND_GPBC_NI__ERACMP				0x0100
#define		NAND_GPBC_NI__PIPECPYBCKCMDCOMP		0x0200
#define		NAND_GPBC_NI__LOCKBLK				0x0400
#define		NAND_GPBC_NI__UNSUPCMD				0x0800
#define		NAND_GPBC_NI__INTACT				0x1000
#define		NAND_GPBC_NI__RSTCMP				0x2000
#define		NAND_GPBC_NI__PIPECMDERR			0x4000
#define		NAND_GPBC_NI__PTRANS				0x8000
#define		NAND_GPBC_NI__MASK					0xFFFD
#define		NAND_GPBC_NI__ERR					0x4C38

//INTERRUPT_ENABLE_BANK0
#define	NAND_GPBC_NIE0				0x420

//PAGE_COUNT_BANK0
#define	NAND_GPBC_NPCB0				0x430
#define		NAND_GPBC_NPCB0__B0PC				0x00ff

//ERROR_PAGE_ADDRESS_BANK0
#define	NAND_GPBC_NEPAB0			0x440
#define		NAND_GPBC_NEPAB0__B0ERRPA			0xffff

//ERROR_BLOCK_ADDRESS_BANK0
#define	NAND_GPBC_NEBAB0			0x450
#define		NAND_GPBC_NEBAB0__B0ERRBA			0xffff

//INTERRUPT_STATUS_BANK1
#define	NAND_GPBC_NIST1			0x460

//INTERRUPT_ENABLE_BANK1
#define	NAND_GPBC_NIE1				0x470

//PAGE_COUNT_BANK1
#define	NAND_GPBC_NPCB1				0x480
#define		NAND_GPBC_NPCB1__B1PC				0x00ff

//ERROR_PAGE_ADDRESS_BANK1
#define	NAND_GPBC_NEPAB1			0x490
#define		NAND_GPBC_NEPAB1__B1ERRPA			0xffff

//ERROR_BLOCK_ADDRESS_BANK1
#define	NAND_GPBC_NEBAB1			0x4a0
#define		NAND_GPBC_NEBAB1__B1ERRBA			0xffff

//ECC CORRECTION INFORMATION
#define	NAND_GPBC_NECCINF			0x650
#define		NAND_GPBC_NECCINF__B0MAXERR			0x007F
#define		NAND_GPBC_NECCINF__B0UNCOR			0x0080
#define		NAND_GPBC_NECCINF__B1MAXERR			0x7F00
#define		NAND_GPBC_NECCINF__B1UNCOR			0x8000
#define		NAND_GPBC_NECCINF__MASK_MAXERR		0x007F

//NAND DMA ENABLE
#define	NAND_GPBC_NDME				0x700
#define		NAND_GPBC_NDME__FLAG				0x0001

#endif	//_NAND_GPBC_REG_H_
