/* $Id: nand-gpbc.h,v 1.4 2012/02/18 06:16:23 txbsd Exp $
 * nand-gpbc.h: NAND flash I/F dependent header
 *
 * Copyright (C) 2010-2011 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#include <linux/mtd/nand.h> 

#ifndef _NAND_GPBC_H_
#define _NAND_GPBC_H_

#define	NAND_GPBC_DRV_NAME		"nand-gpbc"

/* NAND Flash data bytes per ecc step */
#define	NAND_GPBC_ECCSIZE		1024

/* NAND Flash ecc bytes per step */
#define	NAND_GPBC_ECCBYTES		14

#define NAND_GPBC_OOB_SKIP_SIZE		8

//#define NAND_GPBC_MAX_FLASH_BANKS	2
#define NAND_GPBC_MAX_FLASH_BANKS	1

#define NAND_GPBC_CMD_TIMEOUT	10000	//[ms]

#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_IRQ
	#define NAND_GPBC_IRQ_TIMEOUT	100000	//[ms]
	#define NAND_GPBC_IRQ_ID		97
#endif

#define NAND_GPBC_MAP00		0x00000000
#define NAND_GPBC_MAP01		0x04000000
#define NAND_GPBC_MAP10		0x08000000
#define NAND_GPBC_MAP11		0x0C000000

#define NAND_GPBC_BANK_SEL		24


#define NAND_GPBC_MAP10_ERASE			0x01
#define NAND_GPBC_MAP10_SPARE			0x41
#define NAND_GPBC_MAP10_DEFAULT			0x42
#define NAND_GPBC_MAP10_MAIN_SPARE		0x43

#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_DMA
//	#define NAND_GPBC_DMA_BURST		0x8		//success
//	#define NAND_GPBC_DMA_BURST		0x10	//fail=>success
//	#define NAND_GPBC_DMA_BURST		0x20	//fail=>success
//	#define NAND_GPBC_DMA_BURST		0x40	//fail=>success
	#define NAND_GPBC_DMA_BURST		0x80	//fail=>success
	#define NAND_GPBC_MAP10_BEAT0_READ		(0x01002001 | (NAND_GPBC_DMA_BURST << 16))	//PP:1
	#define NAND_GPBC_MAP10_BEAT0_WRITE		(0x01002101 | (NAND_GPBC_DMA_BURST << 16))	//PP:1
#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ
#define NAND_GPBC_MAP10_BEAT0_CMD_DMA		(0x00000080)	//ch:0

#define NAND_GPBC_CMD_FLAGS_TRANS_DEFAULT	(0x0 << 12)
#define NAND_GPBC_CMD_FLAGS_TRANS_MAIN_SPARE	(0x1 << 12)
#define NAND_GPBC_CMD_FLAGS_TRANS_SPARE		(0x2 << 12)
#define NAND_GPBC_CMD_FLAGS_TRANS_MAIN_META	(0x3 << 12)
#define NAND_GPBC_CMD_FLAGS_WAIT_MEMCPY		(0x1 << 11)
#define NAND_GPBC_CMD_FLAGS_MEMCPY		(0x1 << 10)
#define NAND_GPBC_CMD_FLAGS_CONT		(0x1 << 9)
#define NAND_GPBC_CMD_FLAGS_INT			(0x1 << 8)
#define NAND_GPBC_CMD_FLAGS_BURST_LEN		(NAND_GPBC_DMA_BURST << 0)
#endif /* CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ */
#endif

#define NAND_GPBC_MAP11_CMD		0x0
#define NAND_GPBC_MAP11_ADR		0x1
#define NAND_GPBC_MAP11_DAT		0x2


#define NAND_GPBC_CMDP__BANK(x)		((x) << 24)
#define NAND_GPBC_CMDP__TYPE_CMD		0
#define NAND_GPBC_CMDP__TYPE_ADR		1
#define NAND_GPBC_CMDP__TYPE_DAT		2

/* bbt/bbm option */
#define NAND_GPBC_BBT_OPTION (NAND_BBT_LASTBLOCK\
					|NAND_BBT_CREATE\
					|NAND_BBT_WRITE\
					|NAND_BBT_2BIT\
					|NAND_BBT_VERSION\
					|NAND_BBT_PERCHIP\
					|NAND_BBT_SCAN2NDPAGE)
/*
 * NAND_BBT_LASTBLOCK	save bbt/bbm from last block
 * NAND_BBT_CREATE	create bbt/bbm
 * NAND_BBT_WRITE	save bbt/bbm on MTD
 * NAND_BBT_2BIT	bit information of each block is 2 bit
 * NAND_BBT_VERSION	BBT/BBM version
 * NAND_BBT_PERCHIP	make bbt/bbm of each chip
 * NAND_BBT_SCAN2NDPAGE	scan bb only on page 1 and 2
 */

#ifdef CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
/* offset of the bbt/bbm pattern in the data area */
#define NAND_GPBC_BBT_OFFS		0
/* length of the bbt/bbm pattern, if 0 no pattern check is performed */
#define NAND_GPBC_BBT_LEN		4
/* offset of the bbt/bbm version in the data area */
#define NAND_GPBC_BBT_VEROFFS		4
#else /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */
/* offset of the bbt/bbm pattern in the oob area of the page */
#define NAND_GPBC_BBT_OFFS		2
/* length of the bbt/bbm pattern, if 0 no pattern check is performed */
#define NAND_GPBC_BBT_LEN		4
/* offset of the bbt/bbm version in the oob area of the page */
#define NAND_GPBC_BBT_VEROFFS		6
#endif /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */

/* maximum number of blocks to search for a bbt */
#define NAND_GPBC_UNIT_BBT_MAXBLOCKS		4

#ifndef	CONFIG_MTD_NAND_MN2WS_BB
/* master bbt/bbm pattern */
	#define NAND_GPBC_UNIT_BBT_PATTERN_MASTER		{'b','B','t','0'}
/* mirror bbt/bbm pattern */
	#define NAND_GPBC_UNIT_BBT_PATTERN_MIRROR		{'1','t','B','b'}
#else	/* CONFIG_MTD_NAND_MN2WS_BB */
	#define NAND_GPBC_UNIT_BBT_PATTERN_MASTER		{'B','b','t','0'}
	#define NAND_GPBC_UNIT_BBT_PATTERN_MIRROR		{'1','t','b','B'}
#endif	/* CONFIG_MTD_NAND_MN2WS_BB */

#ifdef CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
/* offset of the bbt flag in the oob area of the page */
#define	NAND_GPBC_BBT_FLAG_OFFS	2

/* length of the bbt flag */
#define	NAND_GPBC_BBT_FLAG_LEN	1

/* bbt flag pattern */
#define	NAND_GPBC_BBT_FLAG_FF_PATTERN	{0xff}
#endif /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */

/* NAND options(bottom 16bits will be overwritten by chip option ) */
#define NAND_GPBC_OPTIONS \
					(NAND_NO_AUTOINCR\
					|NAND_USE_FLASH_BBT)

/* offset of the bad block pattern in the oob area of the page */
#define	NAND_GPBC_BBTSCAN_OFFS	0

/* length of the bad block pattern */
#define	NAND_GPBC_BBTSCAN_LEN	2

/* bad block pattern */
#define	NAND_GPBC_BBTSCAN_FF_PATTERN	{0xff, 0xff}

struct nand_gpbc_priv {
	unsigned char		*work_bufp;
	unsigned int		anumPage;
};

#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ
struct nand_gpbc_cmd_desc_t {
	u64	next_ptr;
	u32	flash_page;
	u32	reserved0;
	u16	cmd_type;
	u16	cmd_flags;
	u32	sync_arg;
	u64	mem_ptr;
	u16	status;
	u16	reserved1;
	u32	reserved2;
	u64	sync_flag_ptr;
	u64	mem_copy_addr;
	u64	meta_data_addr;
};

#define NAND_GPBC_CDESC_STAT_CMP		0x8000
#define NAND_GPBC_CDESC_STAT_FAIL		0x4000
#define NAND_GPBC_CDESC_STAT_TMOUT		0x0400
#define NAND_GPBC_CDESC_STAT_MAX_ERR		0x03f0
#define NAND_GPBC_CDESC_STAT_DESC_ERR		0x0008
#define NAND_GPBC_CDESC_STAT_LOCKED_BLOCK	0x0004
#define NAND_GPBC_CDESC_STAT_UNSUP_ERR		0x0002
#define NAND_GPBC_CDESC_STAT_ACCESS_ERR		0x0001
#define NAND_GPBC_CDESC_STAT_ERR (NAND_GPBC_CDESC_STAT_TMOUT		| \
				  NAND_GPBC_CDESC_STAT_DESC_ERR		| \
				  NAND_GPBC_CDESC_STAT_LOCKED_BLOCK	| \
				  NAND_GPBC_CDESC_STAT_UNSUP_ERR	| \
				  NAND_GPBC_CDESC_STAT_ACCESS_ERR)

#define NAND_GPBC_CDESC_STAT_MAX_ERR_SHIFT	4
#endif /* CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ */

struct nand_gpbc_info{
	struct mtd_info			mtd;
	struct nand_chip		chip;
	void __iomem	*regBase;
	void __iomem	*memBase;
	u32			nist[NAND_GPBC_MAX_FLASH_BANKS];
	u32			nie[NAND_GPBC_MAX_FLASH_BANKS];
	u32			dwordBuf;
	int			status;
	u32			sectSize2;
	u32			oobSkipSize;
	u32			sectSize3;
	u32			aId[4];
	u32			pagesPerBlock;
	u32			banks;
	#ifdef CONFIG_MTD_PARTITIONS
		int					nr_parts;
		struct mtd_partition		*parts;
	#endif	/* CONFIG_MTD_PARTITIONS */
	u8			*pPageBuf;
	#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_DMA
		u8			*pPageBufRaw;
		u32			pageBufPhys;
		u32			dmaAlignSize;
#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ
	struct nand_gpbc_cmd_desc_t *cmd_desc;
	u32 cmd_desc_phys;
#endif /* CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ */
	#endif
	#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_IRQ
		unsigned int		irq;
		volatile int		event;
		wait_queue_head_t	queue;
	#endif
};


#endif	/* _NAND_GPBC_H_ */

