/*
 * Copyright (C) 2010, Panasonic Corporation 
 */

#if defined(CONFIG_USB_PANASONIC_SLD3)

#include <asm/page.h>

static inline void internal_host_peripheryhw_init( void )
{
	unsigned long mio_reg_base;

	mio_reg_base = (unsigned long)ioremap(0x5f800000, PAGE_SIZE);
	if (!mio_reg_base) {
		printk(KERN_ERR "internal_host_peripheryhw_init: ioremap failed\n");
		return;
	}

	writel(0x05142400, mio_reg_base + 0x0500);	/* emphasis on */
	writel(0x05142400, mio_reg_base + 0x0508);	/* emphasis on */
	writel(0x05142400, mio_reg_base + 0x0510);	/* emphasis on */
	writel(0x05142400, mio_reg_base + 0x0518);	/* emphasis on */

	iounmap((void *)mio_reg_base);
	
	mio_reg_base = (unsigned long)ioremap(0x59810000, PAGE_SIZE);
	if (!mio_reg_base) {
		printk(KERN_ERR "internal_host_peripheryhw_init: ioremap failed\n");
		return;
	}

	writel(0x00000001, mio_reg_base + 0x0114); /* MIO_USBRSTCTRL0 */
	writel(0x00000001, mio_reg_base + 0x0314); /* MIO_USBRSTCTRL1 */
	writel(0x00000001, mio_reg_base + 0x0514); /* MIO_USBRSTCTRL2 */
	writel(0x00000001, mio_reg_base + 0x0714); /* MIO_USBRSTCTRL3 */

	iounmap((void *)mio_reg_base);
#if 0

	outl( 0x00010000, 0x59810030 );
	outl( 0x00010000, 0x59810230 );
	outl( 0x00010000, 0x59810430 );

	outl( 0x00001100, 0x5A000030 );
	outl( 0x00001100, 0x5A010010 );
	outl( 0x00001100, 0x5A010030 );
#endif


}

#define INTERNAL_EHCI_BASE_ADR_0	(0x5A800000)
#define INTERNAL_EHCI_IRQ_NUM_0		(112)
#define INTERNAL_EHCI_BASE_ADR_1	(0x5A810000)
#define INTERNAL_EHCI_IRQ_NUM_1		(113)
#define INTERNAL_EHCI_BASE_ADR_2	(0x5A820000)
#define INTERNAL_EHCI_IRQ_NUM_2		(114)
#define INTERNAL_EHCI_BASE_ADR_3	(0x5A830000)
#define INTERNAL_EHCI_IRQ_NUM_3		(115)
#ifdef CONFIG_USB_PANASONIC_HOST_INTRMEM
#define INTERMEM_SIZE	16384
#define INTERMEM_OFFSET	0x4000
typedef struct _INTERMEM_CONFIG{
	int size;
	int num;
} INTERMEM_CONFIG;

static const INTERMEM_CONFIG intermem_configuration[]={
	{	2048,	1},
	{	128,	112},
};
#endif

#endif /* CONFIG_USB_PANASONIC_SLD3 */

