/*
 * Copyright (C) 2010, Panasonic Corporation.
 *                       All Rights Reserved.
 *
 */

#if defined(CONFIG_USB_PANASONIC_TEST_MODE_IN_USB_DRIVER)
#include "ehci-test.h"

int usb_ehci_panasonic_test_mode( struct usb_hcd *hcd, u32 testid, enum usb_device_speed speed )
{
	u32 status, status_spd, status_mode;
	const char *msgMode, *msgSpeed;
	struct ehci_hcd	*ehci;
	
	ehci = hcd_to_ehci( hcd );
	if( !ehci )
		return -EINVAL;
	status = readl( &ehci->regs->port_status[0] );
	
	switch( testid ){
		case USB_TESTMD_PID_SE0:
			status_mode = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_SE0);
			msgMode = "SE0";
			break;
		
		case USB_TESTMD_PID_J:
			status_mode = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_J);
			msgMode = "J_STATE";
			break;
		
		case USB_TESTMD_PID_K:
			status_mode = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_K);
			msgMode = "K_STATE";
			break;
		
		case USB_TESTMD_PID_PACKET:
			status_mode = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_PKT);
			msgMode = "TEST_PACKET";
			break;
		
		default:
			printk("Internal USB Host Test Driver Error (Product ID Error) \n");
			return -EINVAL;
	}
	
	switch( speed ){
		case USB_SPEED_LOW:
			status_spd = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_LS);
			msgSpeed = "low";
			break;
		
		case USB_SPEED_FULL:	
			status_spd = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_FS);
			msgSpeed = "full";
			break;
		
		case USB_SPEED_HIGH:	
			status_spd = ((status & USBREG_PORTSC_PTC_MSK) | USBREG_PORTSC_PTC_HS);
			msgSpeed = "high";
			break;
		
		default: return -EINVAL;
	}

	writel( USBREG_CMD_INIT,	&ehci->regs->command		);

	writel( USBREG_USBMD_INIT,	(char*)ehci->regs +USBH_OFFSET_USBMODE	);
	writel( USBREG_CMD_RUN,		&ehci->regs->command		);
	writel( status_spd,			&ehci->regs->port_status[0]	);
	writel( status_mode,		&ehci->regs->port_status[0]	);
	
	printk( "internal_host_test_core OK [mode:%s, Speed:%s] \n", msgMode, msgSpeed );
	
	return 0;
}
EXPORT_SYMBOL_GPL( usb_ehci_panasonic_test_mode );
#endif

