/*
 * Copyright (C) 2010, Panasonic Corporation.
 *                       All Rights Reserved.
 *
 */

#define assert(expr) \
	if (!(expr)) { \
		printk("Assertion failed! %s,%s,%s,line=%d\n", \
		#expr, __FILE__, __func__, __LINE__); \
	}

#define _READB(_reg)     		readb((volatile void __iomem*)(_reg))
#define _READL(_reg)     		readl((volatile void __iomem*)(_reg))
#define _WRITEB(_val, _reg)     writeb((u8)(_val), (volatile void __iomem*)(_reg))
#define _WRITEL(_val, _reg)     writel((u32)(_val), (volatile void __iomem*)(_reg))

#define _REG_R8(_reg)           _READB(_reg)
#define _REG_R16(_reg)          _READW(_reg)
#define _REG_R32(_reg)          _READL(_reg)

#define _REG_W8(_reg, _val)     _WRITEB(_val, _reg)
#define _REG_W16(_reg, _val)    _WRITEW(_val, _reg)
#define _REG_W32(_reg, _val)    _WRITEL(_val, _reg)

#define _REG_SET8(_reg, _val) \
    _REG_W8((_reg), _REG_R8(_reg) | (u8)(_val))
#define _REG_SET16(_reg, _val) \
    _REG_W16((_reg), _REG_R16(_reg) | (u16)(_val))
#define _REG_SET32(_reg, _val) \
    _REG_W32((_reg), _REG_R32(_reg) | (u32)(_val))

#define _REG_SETM8(_reg, _val, _mask) \
    _REG_W8((_reg), (_REG_R8(_reg) & (u8)(_mask)) | (u8)(_val))
#define _REG_SETM16(_reg, _val, _mask) \
    _REG_W16((_reg), (_REG_R16(_reg) & (u16)(_mask)) | (u16)(_val))
#define _REG_SETM32(_reg, _val, _mask) \
    _REG_W32((_reg), (_REG_R32(_reg) & (u32)(_mask)) | (u32)(_val))

#define _REG_CLR8(_reg, _val) \
    _REG_W8((_reg), (_REG_R8(_reg) & (~(u8)(_val))))
#define _REG_CLR16(_reg, _val) \
    _REG_W16((_reg), (_REG_R16(_reg) & (~(u16)(_val))))
#define _REG_CLR32(_reg, _val) \
    _REG_W32((_reg), (_REG_R32(_reg) & (~(u32)(_val))))

#define _REG_TEST8(_reg, _val) \
    ((_REG_R8(_reg) & (u8)(_val)) != 0 ? 1 : 0)
#define _REG_TEST16(_reg, _val) \
    ((_REG_R16(_reg) & (u16)(_val)) != 0 ? 1 : 0)
#define _REG_TEST32(_reg, _val) \
    ((_REG_R32(_reg) & (u32)(_val)) != 0 ? 1 : 0)


#if defined(CONFIG_USB_PANASONIC_SLD2H)
#include "ehci-panasonic-register-sld2h.h"
#endif

#if defined(CONFIG_USB_PANASONIC_SLD3)
#include "ehci-panasonic-register-sld3.h"
#endif

#define USBH_EHCI_BURSTSIZE         (0x00004080)
#define USBH_EHCI_TXFILLTUNING      (0x00020000)
#define INTERNAL_EHCI_MEM_LEN       (0x200)
#define INTERNAL_EHCI_CAPS_BASE     (0x0100)
#define INTERNAL_EHCI_REGS_BASE     (0x0140)
#define USBH_IOBASEADDR       		(0x0)

#if defined(CONFIG_USB_PANASONIC_TEST_MODE_IN_USB_DRIVER)

#define USBH_OFFSET_USBMODE	  		0x01A8

#define USBREG_PORTSC_PTC_MSK		0xFFF0FFFF
#define USBREG_PORTSC_PTC_DIS		0x00000000
#define USBREG_PORTSC_PTC_J			0x00010000
#define USBREG_PORTSC_PTC_K			0x00020000
#define USBREG_PORTSC_PTC_SE0		0x00030000
#define USBREG_PORTSC_PTC_PKT		0x00040000
#define USBREG_PORTSC_PTC_HS		0x00050000
#define USBREG_PORTSC_PTC_FS		0x00060000
#define USBREG_PORTSC_PTC_LS		0x00070000

#define USBREG_CMD_INIT				0x00080b02
#define USBREG_CMD_RUN				0x00080b01

#define USBREG_USBMD_INIT			0x00000003

#endif /* CONFIG_USB_PANASONIC_TEST_MODE_IN_USB_DRIVER */

