/*
 * Copyright (C) 2010, Panasonic Corporation.
 *                       All Rights Reserved.
 *
 */

#ifndef __INTERNAL_HOST_TEST_H
#define __INTERNAL_HOST_TEST_H

#define		USB_TESTMD_VDR_SE0			0x1A0A
#define		USB_TESTMD_PID_SE0			0x0101

#define		USB_TESTMD_VDR_J			0x1A0A
#define		USB_TESTMD_PID_J			0x0102

#define		USB_TESTMD_VDR_K			0x1A0A
#define		USB_TESTMD_PID_K			0x0103

#define		USB_TESTMD_VDR_PACKET		0x1A0A
#define		USB_TESTMD_PID_PACKET		0x0104

#define		USB_TESTMD_VDR_SUSRUM		0x1A0A
#define		USB_TESTMD_PID_SUSRUM		0x0106

#define		USB_TESTMD_VDR_GETDEV		0x1A0A
#define		USB_TESTMD_PID_GETDEV		0x0107

#define		USB_TESTMD_VDR_SETFEA		0x1A0A
#define		USB_TESTMD_PID_SETFEA		0x0108


#ifdef CONFIG_USB_PANASONIC_USE_DUMMY_TEST_DEVICES

#define		DUMMY_USB_TESTMD_VDR_SE0		0x0000
#define		DUMMY_USB_TESTMD_PID_SE0		0x0001

#define		DUMMY_USB_TESTMD_VDR_J			0x0000
#define		DUMMY_USB_TESTMD_PID_J			0x0002

#define		DUMMY_USB_TESTMD_VDR_K			0x0000
#define		DUMMY_USB_TESTMD_PID_K			0x0003

#define		DUMMY_USB_TESTMD_VDR_PACKET		0x0000
#define		DUMMY_USB_TESTMD_PID_PACKET		0x0004

#define		DUMMY_USB_TESTMD_VDR_SUSRUM		0x0000
#define		DUMMY_USB_TESTMD_PID_SUSRUM		0x0005

#define		DUMMY_USB_TESTMD_VDR_GETDEV		0x0000
#define		DUMMY_USB_TESTMD_PID_GETDEV		0x0006

#define		DUMMY_USB_TESTMD_VDR_SETFEA		0x0000
#define		DUMMY_USB_TESTMD_PID_SETFEA		0x0007

#define CASE_DUMMY_TO_REAL( VAL )	case ((u32)DUMMY_USB_TESTMD_VDR_##VAL<<16) | DUMMY_USB_TESTMD_PID_##VAL: return USB_TESTMD_PID_##VAL;
static inline u32 dummyid2testid( u16 vendor, u16 product )
{
	switch( (u32)vendor<<16 | product ){
		CASE_DUMMY_TO_REAL( SE0 );
		CASE_DUMMY_TO_REAL( J );
		CASE_DUMMY_TO_REAL( K );
		CASE_DUMMY_TO_REAL( PACKET );
		CASE_DUMMY_TO_REAL( SUSRUM );
		CASE_DUMMY_TO_REAL( GETDEV );
		CASE_DUMMY_TO_REAL( SETFEA );
		default: return product;
	}
}

#define USB_DUMMY_TEST_DEVICES_ID_TABLE	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_SE0,		DUMMY_USB_TESTMD_PID_SE0)		},	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_J,		DUMMY_USB_TESTMD_PID_J)			},	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_K,		DUMMY_USB_TESTMD_PID_K)			},	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_PACKET,	DUMMY_USB_TESTMD_PID_PACKET)	},	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_SUSRUM,	DUMMY_USB_TESTMD_PID_SUSRUM)	},	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_GETDEV,	DUMMY_USB_TESTMD_PID_GETDEV)	},	\
	{USB_DEVICE (DUMMY_USB_TESTMD_VDR_SETFEA,	DUMMY_USB_TESTMD_PID_SETFEA)	},

#endif

extern int usb_ehci_panasonic_test_mode( struct usb_hcd *hcd, u32 testid, enum usb_device_speed speed );

#endif /* __INTERNAL_HOST_TEST_H */

