/*
 *  i2c-mn2ws.h i2c driver for Panasonic MN2WS series
 *    (C) Copyright 2008 Panasonic Corporation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LINUX_I2C_MN2WS__H__INCLLUDED /* [ */
#define LINUX_I2C_MN2WS__H__INCLLUDED 1

#include <linux/types.h>


#ifdef __KERNEL__ /* [ */

struct i2c_mn2ws_pdata {
	unsigned long		base;
	int		irq;
	int		rate;
};

#endif /* ] __KERNEL__ */


struct i2c_busreset_ioctl_data {
	__u16 interval;
	__u16 times;
};

#define I2C_BUSRESET		(0x0730)
#define I2C_SET_BUSRATE		(0x0731)
#define I2C_GET_BUSRATE		(0x0732)

#endif /* ] LINUX_I2C_MN2WS__H__INCLLUDED */
