##############################################################################
#Copyright (c) SHARP CORPORATION
#
#Purpose:  Makefile for auto-ip module
##############################################################################

CONFIGMAKE     = Config.make
include $(CONFIGMAKE)

MODULE         = autoip
MODULE_DEP     = $(MODULE).dpd
TARGET_LIB     = lib$(MODULE).a
TARGET_DIR     = $(LNXSRCDIR)/lib
TARGET_INC_DIR = $(LNXSRCDIR)/include
PUBLIC_HEADERS = aip.h
TARGET_OBJS    = aip.o AVH-IPv4LL.o 
TARGET_SRCS    = $(subst .o,.c, $(TARGET_OBJS))

ifdef AIP_UNIT_TEST
CFLAGS+=-DAIP_UNIT_TEST
endif

all: depend $(TARGET_LIB)
$(TARGET_LIB): $(TARGET_OBJS)

test :$(TARGET_OBJS)
	$(CC) -lpthread -o test $(TARGET_OBJS) 

.PHONY:test

clean:
	$(RM) $(TARGET_LIB) *.o *~

cleanall: clean uninstall
	$(RM) $(MODULE_DEP)

install: all
	$(MKDIR) $(TARGET_INC_DIR)
	$(CP) $(PUBLIC_HEADERS) $(TARGET_INC_DIR)
	$(MKDIR) $(TARGET_DIR)
	$(CP) $(TARGET_LIB) $(TARGET_DIR)

uninstall: 
	$(RM) $(TARGET_DIR)/$(TARGET_LIB)
	$(RM) $(addprefix $(TARGET_INC_DIR)/,$(PUBLIC_HEADERS))

test doc:

# ¸եɤ߹
$(eval $(call includedepend,$(MODULE_DEP)))
depend: $(MODULE_DEP)
$(MODULE_DEP): $(TARGET_SRCS)
