/*
 * fontdemo - freetype font demonstration program for Nano-X
 */
#include <stdio.h>
#include <stdlib.h>
#define MWINCLUDECOLORS
#include "nano-X.h"

/*#define FONTNAME	"lt1-r-omega-serif.ttf"*/
/*#define FONTNAME	"arial.ttf" */
/*#define FONTNAME	"times.ttf" */
/*#define FONTNAME	"kochi-mincho-subst.ttf"*/
/*#define FONTNAME	"kochi-gothic-subst.ttf"*/
/*#define FONTNAME	"sharphis.ttf"*/
/*#define FONTNAME	"sharphi.ttf"*/
#define FONTNAME	"hghg5ar.ttf"

extern ARAPP_UpdateGraphic(void);

#define FGCOLOR		BLACK
#define BGCOLOR		WHITE

GR_WINDOW_ID	w;
GR_GC_ID	gc;
GR_FONT_ID	font;
GR_BOOL		aa = GR_TRUE;


static void
do_paint(GR_EVENT_EXPOSURE *ep)
{
	int	i, x = 150, y = 100;
	long	flag;

#if 0
	for (i=3; i<=30; ++i) {
#else
	{
		i = 24;
#endif
		GR_FONT_INFO	info;
		char		buf_jis[64], buf_euc[64];
		char		buf2[256];
		int		rlen;

		font = GrCreateFont(FONTNAME, i, NULL);
		if (aa)
//			GrSetFontAttr(font, GR_TFANTIALIAS|GR_TFKERNING, 0);
			GrSetFontAttr(font, MWTF_ANTIALIAS|MWTF_KERNING|MWTF_FREETYPE, 0);
		/*GrSetFontRotation(font, 150);*/
		GrSetGCFont(gc, font);

//#include "text_uni.c"
#include "text_jis.c"
#include "text_euc.c"

//		flag = MWTF_DBCS_EUCJP | MWTF_TOP;
		flag = MWTF_DBCS_JIS | MWTF_TOP;
//		flag = MWTF_UTF8 | MWTF_TOP;
//		flag = MWTF_UC16 | MWTF_TOP;
//		flag = MWTF_ASCII | MWTF_TOP;
//		flag = MWTF_DBCS_BIG5 | MWTF_TOP;
//		flag = MWTF_DBCS_EUCCN | MWTF_TOP;
//		flag = MWTF_DBCS_EUCKR | MWTF_TOP;
//		rlen = 14;
//		rlen = 17;
		rlen = -1;
		GrText(w, gc, x, y, buf_jis, rlen, flag);

		GrGetFontInfo(font, &info);
		y += info.height;
		flag = MWTF_DBCS_EUCJP | MWTF_TOP;
		GrText(w, gc, x, y, buf_euc, rlen, flag);

		GrDestroyFont(font);
	}
	ARAPP_UpdateGraphic();
}

#if 0
int
main(int ac, char **av)
#else
int fontdemo_main(void)
#endif
{
	if (GrOpen() < 0)
		exit(1);

	w = GrNewWindowEx(GR_WM_PROPS_APPWINDOW, "fontdemo", GR_ROOT_WINDOW_ID,
		10, 10, 1900, 1070, BGCOLOR);
	GrSelectEvents(w, GR_EVENT_MASK_EXPOSURE|GR_EVENT_MASK_BUTTON_DOWN|
		GR_EVENT_MASK_CLOSE_REQ);
	GrMapWindow(w);

	gc = GrNewGC();
	GrSetGCUseBackground(gc, GR_FALSE);
	GrSetGCForeground(gc, FGCOLOR);
	GrSetGCBackground(gc, BGCOLOR);

	while (1) {
		GR_EVENT event;

		GrGetNextEvent(&event);
		switch (event.type) {
		case GR_EVENT_TYPE_EXPOSURE:
			do_paint(&event.exposure);
			break;

		case GR_EVENT_TYPE_BUTTON_DOWN:
			{
			GR_WINDOW_INFO info;

			aa = !aa;
			GrGetWindowInfo(w, &info);
			GrSetGCForeground(gc, BGCOLOR);
			GrFillRect(w, gc, 0, 0, info.width, info.height);
			GrSetGCForeground(gc, FGCOLOR);
			do_paint(&event.exposure);	/*FIXME*/
			}
			break;

		case GR_EVENT_TYPE_CLOSE_REQ:
			GrClose();
			exit(0);
		}
	}
}
