####################################################################
# Microwindows and Nano-X configuration file
#
# This package can be configured to run on Linux (MIPS, ARM, x86)
# UNIX, ELKS, DJGPP, or RTEMS.
# On Linux, we've got drivers for Linux 2.x framebuffers, X11, or,
# svgalib for VGA hardware.
# In addition, a gpm or direct serial mouse driver can be configured.
# On ELKS, the bios screen driver and serial mouse driver are always used.
#
# Either Microwindows and/or Nano-X can be built.
# Microwindows and Nano-X have several demos.
#
# For MSDOS makes, see mcmwin.mak and mcnanox.mak
####################################################################

####################################################################
#
# build target platform
#
# Valid ARCH values are:
#
# LINUX-NATIVE
# LINUX-ARM
# LINUX-MIPS
# SOLARIS
# RTEMS
# DJGPP
# ELKS
#
# note: ELKS can't build client/server nano-X, nor widget lib
#
####################################################################
ARCH                     = LINUX-ARM
ARMTOOLSPREFIX           = arm-linux-
MIPSTOOLSPREFIX          = mipsel-linux-
RTEMSTOOLSPREFIX         = i386-rtemself-

####################################################################
#
# Compiling options
#
####################################################################
OPTIMIZE                 = Y
DEBUG                    = N
VERBOSE                  = N

####################################################################
#
# Libraries to build: microwin, nano-X, nanowidget, object frameworks
#
####################################################################
MICROWIN                 = Y
NANOX                    = Y
SHAREDLIBS               = N
NWIDGET                  = N
OBJFRAMEWORK             = N


####################################################################
#
# Demos to build
#
####################################################################
MICROWINDEMO             = Y
NANOXDEMO                = Y

####################################################################
#
# Applications to build
#
####################################################################
NANOWM                   = Y

####################################################################
#
# The pixeltype of the native hardware or underlying graphics library.
# This definition defines the PIXELVAL to be 32, 16 or 8 bits wide.
# If using Linux framebuffer, set to MWPF_TRUECOLOR0888, and use fbset.
# It also enables GdArea/GrArea for this particular pixel packing format.
#
# define MWPF_PALETTE       /* pixel is packed 8 bits 1, 4 or 8 pal index*/
# define MWPF_TRUECOLOR0888 /* pixel is packed 32 bits 8/8/8 truecolor*/
# define MWPF_TRUECOLOR888  /* pixel is packed 24 bits 8/8/8 truecolor*/
# define MWPF_TRUECOLOR565  /* pixel is packed 16 bits 5/6/5 truecolor*/
# define MWPF_TRUECOLOR332  /* pixel is packed 8 bits 3/3/2 truecolor*/
#
####################################################################
SCREEN_PIXTYPE           = MWPF_TRUECOLOR0888

####################################################################
#
# NanoX: Put Y to the following line to link the nano-X application
# with the server.  This is required for ELKS, if no network is present,
# or for speed or debugging.  This affects the nano-X server only.
#
####################################################################
LINK_APP_INTO_SERVER     = N

####################################################################
#
# File I/O support
# Supporting either below drags in libc stdio, which may not be wanted
#
####################################################################
HAVE_FILEIO              = Y

####################################################################
# BMP, GIF reading support
####################################################################
HAVE_BMP_SUPPORT         = Y
HAVE_GIF_SUPPORT         = Y
HAVE_PNM_SUPPORT         = Y
HAVE_XPM_SUPPORT         = Y

####################################################################
# JPEG support through libjpeg, see README.txt in contrib/jpeg
####################################################################
HAVE_JPEG_SUPPORT        = N
INCJPEG                  = .
LIBJPEG                  = /usr/lib/libjpeg.a

####################################################################
# PNG support via libpng and libz
####################################################################
HAVE_PNG_SUPPORT         = N
INCPNG                   = .
LIBPNG                   = /usr/lib/libpng.a
LIBZ                     = /usr/lib/libz.a

####################################################################
# T1 adobe type1 font support thru t1lib
####################################################################
HAVE_T1LIB_SUPPORT       = N
INCT1LIB                 = /usr/include
LIBT1LIB                 = /usr/lib/libt1.a

####################################################################
# TrueType font support thru FreeType
####################################################################
HAVE_FREETYPE_SUPPORT    = N
INCFTLIB                 = /usr/include
LIBFTLIB                 = /usr/lib/libttf.so

####################################################################
# Shared memory support for Nano-X client/server protocol speedup
####################################################################
HAVE_SHAREDMEM_SUPPORT   = N

####################################################################
# Chinese Han Zi Ku font support
####################################################################
HAVE_HZK_SUPPORT         = N
HZK_FONT_DIR             = "fonts/chinese"

####################################################################
# Chinese GB2312 compiled in font support (gb2312font.c)
####################################################################
HAVE_GB2312_SUPPORT      = N

####################################################################
#
# Window move algorithms for Microwindows
# Change for tradeoff between cpu speed and looks
# ERASEMOVE repaints only backgrounds while window dragging, quicker.
# Otherwise an XOR redraw is used for window moves only after button up,
# quickest (should set for ELKS)
# UPDATEREGIONS paints in update clipping region only for better look and feel
#
####################################################################
ERASEMOVE                = Y
UPDATEREGIONS            = Y

####################################################################
#
# Use MS fonts (default no)
#
####################################################################
HAVEMSFONTS              = N

####################################################################
#
# Link with Gray Palette (valid only for 4bpp modes)
#
####################################################################
GRAYPALETTE              = N

####################################################################
#
# If the platform is running UNIX, Linux or RTEMS...
#
####################################################################
ifneq ($(ARCH), ELKS)

# X Window screen, mouse and kbd drivers
X11                      = N

ifeq ($(X11), Y)
# predefined model or select screen width, height, depth(palette mode only)
SCREEN_E15               = N
SCREEN_WIDTH             = 640
SCREEN_HEIGHT            = 480
SCREEN_DEPTH             = 4

else

# framebuffer screen driver (linear and/or vga 4 planes)
# set VTSWITCH to include virtual terminal switch code
# set PORTRAIT_MODE to L or R for left or right orientation
FRAMEBUFFER              = Y
FBVGA                    = Y
VTSWITCH                 = Y
PORTRAIT_MODE            = N

# svgalib screen driver
VGALIB                   = N

# direct VGA hardware access screen driver
HWVGA                    = N

####################################################################
# Mouse or touch screen driver
# TPMOUSE for Linux-VR and Embedded Planet
# ADSMOUSE for ADS Graphics Client
# IPAQMOUSE for Compaq iPAQ
####################################################################
GPMMOUSE                 = N
SUNMOUSE                 = N
SERMOUSE                 = N
TPMOUSE                  = N
ADSMOUSE                 = Y
IPAQMOUSE                = N
NOMOUSE                  = N

# keyboard or null kbd driver
TTYKBD                   = N
NOKBD			 = Y

endif

####################################################################
#
# If the platform is a LINUX-ARM box ....
#
####################################################################
ifeq ($(ARCH), LINUX-ARM)

# If 4bpp driver with arm SA1100 LCD controller is used ...
SA1100_LCD_LTLEND        = N

endif


####################################################################
#
# If the platform is a RTEMS box ....
#
####################################################################
ifeq ($(ARCH), RTEMS)

# Location & BSP information of the RTEMS build
RTEMS_BUILD              = /tools/build-i386-elf-rtems
RTEMS_BSP                = pc386
LINK_APP_INTO_SERVER     = Y

endif

endif

####################################################################
#
# If the platform is an ELKS box ...
#
####################################################################
ifeq ($(ARCH), ELKS)

# Higher speed asm driver, c driver of hercules screen driver
ASMVGADRIVER             = Y
CVGADRIVER               = N
HERCDRIVER               = N
DBGDRIVER                = N

# Mouse support
SERMOUSE                 = Y

endif
