/*
 * Copyright (c) 1999, 2000, 2001, 2002 Greg Haerr <greg@censoft.com>
 * Portions Copyright (c) 2002 Koninklijke Philips Electronics
 *
 * Microwindows Screen Driver for TC90400 OSD
 *
 * Portions used from Ben Pfaff's BOGL <pfaffben@debian.org>
 * 
 * Note: modify select_fb_driver() to add new framebuffer subdrivers
 */
#define _GNU_SOURCE 1
#include <assert.h>
#include <fcntl.h>
#include <limits.h>
#include <linux/fb.h>
#include <linux/kd.h>
#include <linux/vt.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "device.h"
#include "genfont.h"
#include "genmem.h"
#include "fb.h"
//#include "osdepend.h"
//#include "tspapi.h"
//#include "tspdef.h"
//#include "gfx.h"
#include "ssw_system.h"
//#include "ssw_address.h"


#undef	ACCESS_LLDD

//#define LLDD_GFX960PLANE

//#ifdef LLDD_GFX960PLANE
#if GFX960PLANE
//#define LLDD_WIDTH	(1920)
#define LLDD_WIDTH	(960) // azuma modify 061006
#define LLDD_HEIGHT	(1080)
#else
#define LLDD_WIDTH	(720)
#define LLDD_HEIGHT	(480)
#endif

#if 0
#define DP_FUNC(a)		printf("[%s] %s\n", __FUNCTION__, a)
#define DP_FUNC_START		DP_FUNC("start")
#define DP_FUNC_END		DP_FUNC("end")
#define DPRINT(str, args...)	printf(__FUNCTION__ ":"str, ##args)
#else
#define DP_FUNC(a)
#define DP_FUNC_START
#define DP_FUNC_END
#define DPRINT(str, args...)
#endif
 
static PSD  lldd_open(PSD psd);
static void lldd_close(PSD psd);
static void lldd_setportrait(PSD psd, int portraitmode);
static void lldd_setpalette(PSD psd, int first, int count, MWPALENTRY *palette);
static void gen_getscreeninfo(PSD psd, PMWSCREENINFO psi);


SCREENDEVICE	scrdev = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL,
	lldd_open,
	lldd_close,
	gen_getscreeninfo,
	lldd_setpalette,
	NULL,			/* DrawPixel subdriver*/
	NULL,			/* ReadPixel subdriver*/
	NULL,			/* DrawHorzLine subdriver*/
	NULL,			/* DrawVertLine subdriver*/
	NULL,			/* FillRect subdriver*/
	gen_fonts,
	NULL,			/* Blit subdriver*/
	NULL,			/* PreSelect*/
	NULL,			/* DrawArea subdriver*/
	NULL,			/* SetIOPermissions*/
	gen_allocatememgc,
	fb_mapmemgc,
	gen_freememgc,
	NULL,			/* StretchBlit subdriver*/
	NULL,			/* SetPortrait*/
};

/* static variables*/
static int status;		/* 0=never inited, 1=once inited, 2=inited. */

#if defined(ACCESS_LLDD)
static gfx_obj_t	g_Src;
static char		g_Initialized = 0;
#endif
static gfx_color_t	g_Pal[256];
#if 0	/* TEST */
static char		g_Map[LLDD_WIDTH * LLDD_HEIGHT];
#else
#define	g_Map		_SSW_ADR_GFX_BITMAP
#endif	/* TEST */

#if 0
extern SUBDRIVER fbportrait_left, fbportrait_right, fbportrait_down;
static PSUBDRIVER pdrivers[4] = { /* portrait mode subdrivers*/
	NULL, &fbportrait_left, &fbportrait_right, &fbportrait_down
};
#endif


/* init OSD framebuffer*/
static PSD lldd_open(PSD psd)
{
#if defined(ACCESS_LLDD)
	int	i, ret;
	unsigned int sts;
	tsd_init_param_t tInitParam;
#endif
	PSUBDRIVER subdriver;

	assert(status < 2);

DP_FUNC_START;

#if defined(ACCESS_LLDD)
#endif
	/* setup screen device from framebuffer info*/
	psd->portrait = MWPORTRAIT_NONE;
	psd->xres = psd->xvirtres = LLDD_WIDTH;
	psd->yres = psd->yvirtres = LLDD_HEIGHT;
	psd->planes = 1;


#if (MWPIXEL_FORMAT == MWPF_PALETTE)
	psd->bpp = 8;
	/* set linelen to byte length, possibly converted later*/
	psd->linelen = LLDD_WIDTH;
	/* set pixel format*/
	psd->pixtype = MWPF_PALETTE;
#elif (MWPIXEL_FORMAT == MWPF_TRUECOLOR8888)
	psd->bpp = 32;
	/* set linelen to byte length, possibly converted later*/
	psd->linelen = LLDD_WIDTH * 4;
	/* set pixel format*/
	psd->pixtype = MWPF_TRUECOLOR8888;
#endif
	psd->ncolors = (psd->bpp >= 24)? (1 << 24): (1 << psd->bpp);

	psd->size = 0;		/* force subdriver init of size*/
	psd->flags = PSF_SCREEN | PSF_HAVEBLIT;


	/*DPRINTF("%dx%dx%d linelen %d type %d visual %d bpp %d\n", psd->xres,
	 	psd->yres, psd->ncolors, psd->linelen, type, visual,
		psd->bpp);*/

	/* select a framebuffer subdriver based on planes and bpp*/
	DPRINT("select_fb_subdriver start %dbpp\n", psd->bpp);
	subdriver = select_fb_subdriver(psd);
	if (!subdriver) {
		DPRINT("No driver for screen bpp %d\n", psd->bpp);
		goto fail;
	}

	/*
	 * set and initialize subdriver into screen driver
	 * psd->size is calculated by subdriver init
	 */
	DPRINT("set_subdriver start\n");
	if (!set_subdriver(psd, subdriver, TRUE)) {
		DPRINT("Driver initialize failed bpp %d\n", psd->bpp);
		goto fail;
	}

	/* remember original subdriver for portrait mode switching*/
//	pdrivers[0] = psd->orgsubdriver = subdriver;

	/* mmap framebuffer into this address space*/
	psd->size = (psd->size + getpagesize () - 1)
			/ getpagesize () * getpagesize ();

#if 0
	psd->addr = mmap(NULL, psd->size, PROT_READ|PROT_WRITE,MAP_SHARED,fb,0);
	if ((psd->addr == NULL) || (psd->addr == (unsigned char *)-1)) {
		EPRINTF("Error mmaping %s: %m\n", env);
		goto fail;
	}
#else
	psd->addr = g_Map;
	DPRINT("mapped address %x\n", g_Map);
#endif

	status = 2;
DP_FUNC_END;
	return psd;	/* success*/

fail:
	return NULL;
}

/* close framebuffer*/
static void lldd_close(PSD psd)
{
#if defined(ACCESS_LLDD)
	int ret;
#endif

DP_FUNC_START;
	/* if not opened, return*/
	if (status != 2) {
		DPRINT("not initialized : %x\n", status);
		return;
	}
	status = 1;

#if defined(ACCESS_LLDD)
	ret = GFX_EnableDevice(_GFX_DEVICE_OSD, FALSE);
	if (ret != 0) {
		/* error */
		DPRINT("GFX_EnableDevice : %x\n", ret);
	}
#endif
DP_FUNC_END;
}

#if 0
static void lldd_setportrait(PSD psd, int portraitmode)
{
	psd->portrait = portraitmode;

	/* swap x and y in left or right portrait modes*/
	if (portraitmode & (MWPORTRAIT_LEFT|MWPORTRAIT_RIGHT)) {
		/* swap x, y*/
		psd->xvirtres = psd->yres;
		psd->yvirtres = psd->xres;
	} else {
		/* normal x, y*/
		psd->xvirtres = psd->xres;
		psd->yvirtres = psd->yres;
	}
	/* assign portrait subdriver which calls original subdriver*/
	if (portraitmode == MWPORTRAIT_DOWN)
		portraitmode = 3;	/* change bitpos to index*/
	set_subdriver(psd, pdrivers[portraitmode], FALSE);
}
#endif

static int fade = 100;

/* convert Microwindows palette to framebuffer format and set it*/
static void lldd_setpalette(PSD psd, int first, int count, MWPALENTRY *palette)
{
	int 	i, ret;

DP_FUNC_START;
	if (count > 256) {
		count = 256;
	}

	/* convert palette to framebuffer format*/
	for (i = 0; i < count; i++) {
		MWPALENTRY *p = &palette[i];

		/* grayscale computation:
		 * red[i] = green[i] = blue[i] =
		 *	(p->r * 77 + p->g * 151 + p->b * 28);
		 */
		g_Pal[i + first] = RGB2PIXEL8888((p->r * fade / 100), (p->g * fade / 100), (p->b * fade / 100));
#if 0	/* TSOL */
printf("IDX[%d]=(%02x, %02x, %02x)\n", i + first, p->r, p->g, p->b);
#endif
	}
#if defined(ACCESS_LLDD)
//	ret = GFX_SetPlaneClut(_GFX_DEVICE_OSD, g_Pal);
	ret = GfxSetPlaneClut(_GFX_DEVICE_OSD, g_Pal);
	if (ret != 0) {
		/* error */
		DPRINT("GFX_SetPlaneClut : %x\n", ret);
	}
#endif
DP_FUNC_END;
}

#if 0
/* get framebuffer palette*/
void ioctl_getpalette(int start, int len, short *red, short *green, short *blue)
{
	int i;
	struct fb_cmap cmap;

	for (i = 0; i < len; i++) {
		MWPALENTRY *p = &palette[i];

		/* grayscale computation:
		 * red[i] = green[i] = blue[i] =
		 *	(p->r * 77 + p->g * 151 + p->b * 28);
		 */
		red[i] = PARSE_R(g_Pal[i + start]);
		green[i] = PARSE_G(g_Pal[i + start]);
		blue[i] = PARSE_B(g_Pal[i + start]);
	}
}

/* set framebuffer palette*/
void ioctl_setpalette(int start, int len, short *red, short *green, short *blue)
{
	struct fb_cmap cmap;

	cmap.start = start;
	cmap.len = len;
	cmap.red = red;
	cmap.green = green;
	cmap.blue = blue;
	cmap.transp = NULL;

	ioctl(fb, FBIOPUTCMAP, &cmap);
}
#endif

/* experimental palette animation*/
void setfadelevel(PSD psd, int f)
{
	int	i, ret;
	extern MWPALENTRY gr_palette[256];

DP_FUNC_START;
	if (psd->pixtype != MWPF_PALETTE) {
		return;
	}

	fade = f;
	if (fade > 100) {
		fade = 100;
	}
	for (i = 0; i < 256; ++i) {
		g_Pal[i] = RGB2PIXEL8888((gr_palette[i].r * fade / 100), (gr_palette[i].g * fade / 100), (gr_palette[i].b * fade / 100));
	}
#if defined(ACCESS_LLDD)
//	ret = GFX_SetPlaneClut(_GFX_DEVICE_OSD, g_Pal);
	ret = GfxSetPlaneClut(_GFX_DEVICE_OSD, g_Pal);
	if (ret != 0) {
		/* error */
		DPRINT("GFX_SetPlaneClut : %x\n", ret);
	}
#endif
DP_FUNC_END;
}

static void gen_getscreeninfo(PSD psd,PMWSCREENINFO psi)
{
DP_FUNC_START;
	psi->rows = psd->yvirtres;
	psi->cols = psd->xvirtres;
	psi->planes = psd->planes;
	psi->bpp = psd->bpp;
	psi->ncolors = psd->ncolors;
	psi->fonts = NUMBER_FONTS;
	psi->portrait = psd->portrait;
	psi->fbdriver = TRUE;	/* running fb driver, can direct map*/

	psi->pixtype = psd->pixtype;
	switch (psd->pixtype) {
	case MWPF_TRUECOLOR8888:
	case MWPF_TRUECOLOR0888:
	case MWPF_TRUECOLOR888:
		psi->rmask 	= 0xff0000;
		psi->gmask 	= 0x00ff00;
		psi->bmask	= 0x0000ff;
		break;
	case MWPF_TRUECOLOR565:
		psi->rmask 	= 0xf800;
		psi->gmask 	= 0x07e0;
		psi->bmask	= 0x001f;
		break;
	case MWPF_TRUECOLOR555:
		psi->rmask 	= 0x7c00;
		psi->gmask 	= 0x03e0;
		psi->bmask	= 0x001f;
		break;
	case MWPF_TRUECOLOR332:
		psi->rmask 	= 0xe0;
		psi->gmask 	= 0x1c;
		psi->bmask	= 0x03;
		break;
	case MWPF_PALETTE:
	default:
		psi->rmask 	= 0xff;
		psi->gmask 	= 0xff;
		psi->bmask	= 0xff;
		break;
	}

	if(psd->yvirtres > 480) {
		/* SVGA 800x600*/
		psi->xdpcm = 33;	/* assumes screen width of 24 cm*/
		psi->ydpcm = 33;	/* assumes screen height of 18 cm*/
	} else if(psd->yvirtres > 350) {
		/* VGA 640x480*/
		psi->xdpcm = 27;	/* assumes screen width of 24 cm*/
		psi->ydpcm = 27;	/* assumes screen height of 18 cm*/
        } else if(psd->yvirtres <= 240) {
		/* half VGA 640x240 */
		psi->xdpcm = 14;        /* assumes screen width of 24 cm*/ 
		psi->ydpcm =  5;
	} else {
		/* EGA 640x350*/
		psi->xdpcm = 27;	/* assumes screen width of 24 cm*/
		psi->ydpcm = 19;	/* assumes screen height of 18 cm*/
	}
DP_FUNC_END;
}

